/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.common;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.formats.common.BasicFormatInfo;
import org.apache.inlong.sort.formats.common.TimestampTypeInfo;

public class TimestampFormatInfo
implements BasicFormatInfo<Timestamp> {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_FORMAT = "format";
    private static final int DEFAULT_PRECISION_FOR_TIMESTAMP = 2;
    @JsonProperty(value="format")
    @Nonnull
    private final String format;
    @JsonIgnore
    @Nullable
    private final SimpleDateFormat simpleDateFormat;
    @JsonProperty(value="precision")
    private int precision;

    @JsonCreator
    public TimestampFormatInfo(@JsonProperty(value="format") @Nonnull String format, @JsonProperty(value="precision") int precision) {
        this.format = format;
        this.precision = precision;
        this.simpleDateFormat = !format.equals("MICROS") && !format.equals("MILLIS") && !format.equals("SECONDS") && !"SQL".equals(format) && !"ISO_8601".equals(format) ? new SimpleDateFormat(format) : null;
    }

    public TimestampFormatInfo(@JsonProperty(value="format") @Nonnull String format) {
        this(format, 2);
    }

    public TimestampFormatInfo() {
        this("yyyy-MM-dd HH:mm:ss", 2);
    }

    public TimestampFormatInfo(@JsonProperty(value="precision") int precision) {
        this("yyyy-MM-dd HH:mm:ss", precision);
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    @Override
    public TimestampTypeInfo getTypeInfo() {
        return TimestampTypeInfo.INSTANCE;
    }

    @Override
    public String serialize(Timestamp timestamp) {
        switch (this.format) {
            case "MICROS": {
                long millis = timestamp.getTime();
                long micros = TimeUnit.MILLISECONDS.toMicros(millis);
                return Long.toString(micros);
            }
            case "MILLIS": {
                long millis = timestamp.getTime();
                return Long.toString(millis);
            }
            case "SECONDS": {
                long millis = timestamp.getTime();
                long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
                return Long.toString(seconds);
            }
        }
        if (this.simpleDateFormat == null) {
            throw new IllegalStateException();
        }
        return this.simpleDateFormat.format(timestamp);
    }

    @Override
    public Timestamp deserialize(String text) throws ParseException {
        switch (this.format) {
            case "MICROS": {
                long micros = Long.parseLong(text);
                long millis = TimeUnit.MICROSECONDS.toMillis(micros);
                return new Timestamp(millis);
            }
            case "MILLIS": {
                long millis = Long.parseLong(text);
                return new Timestamp(millis);
            }
            case "SECONDS": {
                long seconds = Long.parseLong(text);
                long millis = TimeUnit.SECONDS.toMillis(seconds);
                return new Timestamp(millis);
            }
        }
        if (this.simpleDateFormat == null) {
            throw new IllegalStateException();
        }
        Date date = this.simpleDateFormat.parse(text);
        return new Timestamp(date.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampFormatInfo that = (TimestampFormatInfo)o;
        return this.format.equals(that.format);
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }

    public String toString() {
        return "TimestampFormatInfo{format='" + this.format + '\'' + '}';
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

