/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.common;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.formats.common.TypeInfo;

public class RowTypeInfo
implements TypeInfo {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_FIELD_NAMES = "fieldNames";
    private static final String FIELD_FIELD_TYPES = "fieldTypes";
    public static final RowTypeInfo EMPTY = new RowTypeInfo(new String[0], new TypeInfo[0]);
    @JsonProperty(value="fieldNames")
    @Nonnull
    private final String[] fieldNames;
    @JsonProperty(value="fieldTypes")
    @Nonnull
    private final TypeInfo[] fieldTypeInfos;

    @JsonCreator
    public RowTypeInfo(@JsonProperty(value="fieldNames") @Nonnull String[] fieldNames, @JsonProperty(value="fieldTypes") @Nonnull TypeInfo[] fieldTypeInfos) {
        RowTypeInfo.checkArity(fieldNames, fieldTypeInfos);
        RowTypeInfo.checkDuplicates(fieldNames);
        this.fieldNames = fieldNames;
        this.fieldTypeInfos = fieldTypeInfos;
    }

    private static void checkArity(String[] fieldNames, TypeInfo[] fieldTypeInfos) {
        if (fieldNames.length != fieldTypeInfos.length) {
            throw new IllegalArgumentException("The number of names and formats is not equal.");
        }
    }

    private static void checkDuplicates(String[] fieldNames) {
        long numFieldNames = fieldNames.length;
        long numDistinctFieldNames = Arrays.stream(fieldNames).collect(Collectors.toSet()).size();
        if (numDistinctFieldNames != numFieldNames) {
            throw new IllegalArgumentException("There exist duplicated field names.");
        }
    }

    @Nonnull
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Nonnull
    public TypeInfo[] getFieldTypeInfos() {
        return this.fieldTypeInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowTypeInfo that = (RowTypeInfo)o;
        return Arrays.equals(this.fieldTypeInfos, that.fieldTypeInfos);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fieldTypeInfos);
    }

    public String toString() {
        return "RowTypeInfo{fieldTypeInfos=" + Arrays.toString(this.fieldTypeInfos) + '}';
    }
}

