/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.factories.TableFormatFactoryBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.formats.base.ProjectedDeserializationSchemaFactory;
import org.apache.inlong.sort.formats.base.ProjectedSerializationSchemaFactory;
import org.apache.inlong.sort.formats.base.TableFormatDeserializer;
import org.apache.inlong.sort.formats.base.TableFormatDeserializerFactory;
import org.apache.inlong.sort.formats.base.TableFormatSerializer;
import org.apache.inlong.sort.formats.base.TableFormatSerializerFactory;
import org.apache.inlong.sort.formats.common.ArrayFormatInfo;
import org.apache.inlong.sort.formats.common.ArrayTypeInfo;
import org.apache.inlong.sort.formats.common.BasicFormatInfo;
import org.apache.inlong.sort.formats.common.BinaryFormatInfo;
import org.apache.inlong.sort.formats.common.BinaryTypeInfo;
import org.apache.inlong.sort.formats.common.BooleanFormatInfo;
import org.apache.inlong.sort.formats.common.BooleanTypeInfo;
import org.apache.inlong.sort.formats.common.ByteFormatInfo;
import org.apache.inlong.sort.formats.common.ByteTypeInfo;
import org.apache.inlong.sort.formats.common.DateFormatInfo;
import org.apache.inlong.sort.formats.common.DateTypeInfo;
import org.apache.inlong.sort.formats.common.DecimalFormatInfo;
import org.apache.inlong.sort.formats.common.DecimalTypeInfo;
import org.apache.inlong.sort.formats.common.DoubleFormatInfo;
import org.apache.inlong.sort.formats.common.DoubleTypeInfo;
import org.apache.inlong.sort.formats.common.FloatFormatInfo;
import org.apache.inlong.sort.formats.common.FloatTypeInfo;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.FormatUtils;
import org.apache.inlong.sort.formats.common.IntFormatInfo;
import org.apache.inlong.sort.formats.common.IntTypeInfo;
import org.apache.inlong.sort.formats.common.LocalZonedTimestampFormatInfo;
import org.apache.inlong.sort.formats.common.LocalZonedTimestampTypeInfo;
import org.apache.inlong.sort.formats.common.LongFormatInfo;
import org.apache.inlong.sort.formats.common.LongTypeInfo;
import org.apache.inlong.sort.formats.common.MapFormatInfo;
import org.apache.inlong.sort.formats.common.MapTypeInfo;
import org.apache.inlong.sort.formats.common.NullFormatInfo;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.common.RowTypeInfo;
import org.apache.inlong.sort.formats.common.ShortFormatInfo;
import org.apache.inlong.sort.formats.common.ShortTypeInfo;
import org.apache.inlong.sort.formats.common.StringFormatInfo;
import org.apache.inlong.sort.formats.common.StringTypeInfo;
import org.apache.inlong.sort.formats.common.TimeFormatInfo;
import org.apache.inlong.sort.formats.common.TimeTypeInfo;
import org.apache.inlong.sort.formats.common.TimestampFormatInfo;
import org.apache.inlong.sort.formats.common.TimestampTypeInfo;
import org.apache.inlong.sort.formats.common.TypeInfo;
import org.apache.inlong.sort.formats.common.VarBinaryFormatInfo;
import org.apache.inlong.sort.formats.common.VarCharFormatInfo;

public class TableFormatUtils {
    public static <T> DeserializationSchema<T> getDeserializationSchema(Map<String, String> properties, ClassLoader classLoader) {
        DeserializationSchemaFactory deserializationSchemaFactory = (DeserializationSchemaFactory)TableFactoryService.find(DeserializationSchemaFactory.class, properties, (ClassLoader)classLoader);
        return deserializationSchemaFactory.createDeserializationSchema(properties);
    }

    public static <T> SerializationSchema<T> getSerializationSchema(Map<String, String> properties, ClassLoader classLoader) {
        SerializationSchemaFactory serializationSchemaFactory = (SerializationSchemaFactory)TableFactoryService.find(SerializationSchemaFactory.class, properties, (ClassLoader)classLoader);
        return serializationSchemaFactory.createSerializationSchema(properties);
    }

    public static <T> DeserializationSchema<Row> getProjectedDeserializationSchema(Map<String, String> properties, int[] fields, ClassLoader classLoader) {
        ProjectedDeserializationSchemaFactory deserializationSchemaFactory = (ProjectedDeserializationSchemaFactory)TableFactoryService.find(ProjectedDeserializationSchemaFactory.class, properties, (ClassLoader)classLoader);
        return deserializationSchemaFactory.createProjectedDeserializationSchema(properties, fields);
    }

    public static SerializationSchema<Row> getProjectedSerializationSchema(Map<String, String> properties, int[] fields, ClassLoader classLoader) {
        ProjectedSerializationSchemaFactory serializationSchemaFactory = (ProjectedSerializationSchemaFactory)TableFactoryService.find(ProjectedSerializationSchemaFactory.class, properties, (ClassLoader)classLoader);
        return serializationSchemaFactory.createProjectedSerializationSchema(properties, fields);
    }

    public static TableFormatSerializer getTableFormatSerializer(Map<String, String> properties, ClassLoader classLoader) {
        TableFormatSerializerFactory tableFormatSerializerFactory = (TableFormatSerializerFactory)TableFactoryService.find(TableFormatSerializerFactory.class, properties, (ClassLoader)classLoader);
        return tableFormatSerializerFactory.createFormatSerializer(properties);
    }

    public static TableFormatDeserializer getTableFormatDeserializer(Map<String, String> properties, ClassLoader classLoader) {
        TableFormatDeserializerFactory tableFormatDeserializerFactory = (TableFormatDeserializerFactory)TableFactoryService.find(TableFormatDeserializerFactory.class, properties, (ClassLoader)classLoader);
        return tableFormatDeserializerFactory.createFormatDeserializer(properties);
    }

    public static FormatInfo deriveFormatInfo(LogicalType logicalType) {
        if (logicalType instanceof VarCharType) {
            return StringFormatInfo.INSTANCE;
        }
        if (logicalType instanceof BooleanType) {
            return BooleanFormatInfo.INSTANCE;
        }
        if (logicalType instanceof TinyIntType) {
            return ByteFormatInfo.INSTANCE;
        }
        if (logicalType instanceof SmallIntType) {
            return ShortFormatInfo.INSTANCE;
        }
        if (logicalType instanceof IntType) {
            return IntFormatInfo.INSTANCE;
        }
        if (logicalType instanceof BigIntType) {
            return LongFormatInfo.INSTANCE;
        }
        if (logicalType instanceof FloatType) {
            return FloatFormatInfo.INSTANCE;
        }
        if (logicalType instanceof DoubleType) {
            return DoubleFormatInfo.INSTANCE;
        }
        if (logicalType instanceof DecimalType) {
            return DecimalFormatInfo.INSTANCE;
        }
        if (logicalType instanceof DateType) {
            return new DateFormatInfo();
        }
        if (logicalType instanceof TimeType) {
            return new TimeFormatInfo();
        }
        if (logicalType instanceof TimestampType) {
            return new TimestampFormatInfo();
        }
        if (logicalType instanceof LocalZonedTimestampType) {
            return new LocalZonedTimestampFormatInfo();
        }
        if (logicalType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)logicalType;
            LogicalType elementType = arrayType.getElementType();
            FormatInfo elementFormatInfo = TableFormatUtils.deriveFormatInfo(elementType);
            return new ArrayFormatInfo(elementFormatInfo);
        }
        if (logicalType instanceof MapType) {
            MapType mapType = (MapType)logicalType;
            LogicalType keyType = mapType.getKeyType();
            LogicalType valueType = mapType.getValueType();
            FormatInfo keyFormatInfo = TableFormatUtils.deriveFormatInfo(keyType);
            FormatInfo valueFormatInfo = TableFormatUtils.deriveFormatInfo(valueType);
            return new MapFormatInfo(keyFormatInfo, valueFormatInfo);
        }
        if (logicalType instanceof RowType) {
            RowType rowType = (RowType)logicalType;
            List rowFields = rowType.getFields();
            String[] fieldNames = new String[rowFields.size()];
            FormatInfo[] fieldFormatInfos = new FormatInfo[rowFields.size()];
            for (int i = 0; i < rowFields.size(); ++i) {
                RowType.RowField rowField = (RowType.RowField)rowFields.get(i);
                fieldNames[i] = rowField.getName();
                fieldFormatInfos[i] = TableFormatUtils.deriveFormatInfo(rowField.getType());
            }
            return new RowFormatInfo(fieldNames, fieldFormatInfos);
        }
        if (logicalType instanceof BinaryType) {
            return BinaryFormatInfo.INSTANCE;
        }
        if (logicalType instanceof VarBinaryType) {
            return VarBinaryFormatInfo.INSTANCE;
        }
        if (logicalType instanceof NullType) {
            return NullFormatInfo.INSTANCE;
        }
        throw new IllegalArgumentException(String.format("not found logicalType %s", logicalType == null ? "null" : logicalType.toString()));
    }

    public static LogicalType deriveLogicalType(FormatInfo formatInfo) {
        if (formatInfo instanceof StringFormatInfo) {
            return new VarCharType(Integer.MAX_VALUE);
        }
        if (formatInfo instanceof VarCharFormatInfo) {
            return new VarCharType(((VarCharFormatInfo)formatInfo).getLength());
        }
        if (formatInfo instanceof BooleanFormatInfo) {
            return new BooleanType();
        }
        if (formatInfo instanceof ByteFormatInfo) {
            return new TinyIntType();
        }
        if (formatInfo instanceof ShortFormatInfo) {
            return new SmallIntType();
        }
        if (formatInfo instanceof IntFormatInfo) {
            return new IntType();
        }
        if (formatInfo instanceof LongFormatInfo) {
            return new BigIntType();
        }
        if (formatInfo instanceof FloatFormatInfo) {
            return new FloatType();
        }
        if (formatInfo instanceof DoubleFormatInfo) {
            return new DoubleType();
        }
        if (formatInfo instanceof DecimalFormatInfo) {
            DecimalFormatInfo decimalFormatInfo = (DecimalFormatInfo)formatInfo;
            return new DecimalType(decimalFormatInfo.getPrecision(), decimalFormatInfo.getScale());
        }
        if (formatInfo instanceof TimeFormatInfo) {
            return new TimeType(((TimeFormatInfo)formatInfo).getPrecision());
        }
        if (formatInfo instanceof DateFormatInfo) {
            return new DateType();
        }
        if (formatInfo instanceof TimestampFormatInfo) {
            return new TimestampType(((TimestampFormatInfo)formatInfo).getPrecision());
        }
        if (formatInfo instanceof LocalZonedTimestampFormatInfo) {
            return new LocalZonedTimestampType(((LocalZonedTimestampFormatInfo)formatInfo).getPrecision());
        }
        if (formatInfo instanceof ArrayFormatInfo) {
            FormatInfo elementFormatInfo = ((ArrayFormatInfo)formatInfo).getElementFormatInfo();
            return new ArrayType(TableFormatUtils.deriveLogicalType(elementFormatInfo));
        }
        if (formatInfo instanceof MapFormatInfo) {
            MapFormatInfo mapFormatInfo = (MapFormatInfo)formatInfo;
            FormatInfo keyFormatInfo = mapFormatInfo.getKeyFormatInfo();
            FormatInfo valueFormatInfo = mapFormatInfo.getValueFormatInfo();
            return new MapType(TableFormatUtils.deriveLogicalType(keyFormatInfo), TableFormatUtils.deriveLogicalType(valueFormatInfo));
        }
        if (formatInfo instanceof RowFormatInfo) {
            RowFormatInfo rowFormatInfo = (RowFormatInfo)formatInfo;
            FormatInfo[] formatInfos = rowFormatInfo.getFieldFormatInfos();
            int formatInfosSize = formatInfos.length;
            LogicalType[] logicalTypes = new LogicalType[formatInfosSize];
            for (int i = 0; i < formatInfosSize; ++i) {
                logicalTypes[i] = TableFormatUtils.deriveLogicalType(formatInfos[i]);
            }
            return RowType.of((LogicalType[])logicalTypes, (String[])rowFormatInfo.getFieldNames());
        }
        if (formatInfo instanceof BinaryFormatInfo) {
            BinaryFormatInfo binaryFormatInfo = (BinaryFormatInfo)formatInfo;
            return new BinaryType(binaryFormatInfo.getLength());
        }
        if (formatInfo instanceof VarBinaryFormatInfo) {
            VarBinaryFormatInfo varBinaryFormatInfo = (VarBinaryFormatInfo)formatInfo;
            return new VarBinaryType(varBinaryFormatInfo.getLength());
        }
        if (formatInfo instanceof NullFormatInfo) {
            return new NullType();
        }
        throw new IllegalArgumentException(String.format("not found formatInfo %s", formatInfo == null ? "null" : formatInfo.toString()));
    }

    public static TypeInformation<?> getType(TypeInfo typeInfo) {
        if (typeInfo instanceof StringTypeInfo) {
            return Types.STRING;
        }
        if (typeInfo instanceof BooleanTypeInfo) {
            return Types.BOOLEAN;
        }
        if (typeInfo instanceof ByteTypeInfo) {
            return Types.BYTE;
        }
        if (typeInfo instanceof ShortTypeInfo) {
            return Types.SHORT;
        }
        if (typeInfo instanceof IntTypeInfo) {
            return Types.INT;
        }
        if (typeInfo instanceof LongTypeInfo) {
            return Types.LONG;
        }
        if (typeInfo instanceof FloatTypeInfo) {
            return Types.FLOAT;
        }
        if (typeInfo instanceof DoubleTypeInfo) {
            return Types.DOUBLE;
        }
        if (typeInfo instanceof DecimalTypeInfo) {
            return Types.BIG_DEC;
        }
        if (typeInfo instanceof DateTypeInfo) {
            return Types.SQL_DATE;
        }
        if (typeInfo instanceof TimeTypeInfo) {
            return Types.SQL_TIME;
        }
        if (typeInfo instanceof TimestampTypeInfo) {
            return Types.SQL_TIMESTAMP;
        }
        if (typeInfo instanceof LocalZonedTimestampTypeInfo) {
            return Types.LOCAL_DATE_TIME;
        }
        if (typeInfo instanceof BinaryTypeInfo) {
            return Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE);
        }
        if (typeInfo instanceof ArrayTypeInfo) {
            ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
            TypeInfo elementTypeInfo = arrayTypeInfo.getElementTypeInfo();
            TypeInformation<?> elementType = TableFormatUtils.getType(elementTypeInfo);
            return Types.OBJECT_ARRAY(elementType);
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            TypeInfo keyTypeInfo = mapTypeInfo.getKeyTypeInfo();
            TypeInfo valueTypeInfo = mapTypeInfo.getValueTypeInfo();
            TypeInformation<?> keyType = TableFormatUtils.getType(keyTypeInfo);
            TypeInformation<?> valueType = TableFormatUtils.getType(valueTypeInfo);
            return Types.MAP(keyType, valueType);
        }
        if (typeInfo instanceof RowTypeInfo) {
            RowTypeInfo rowTypeInfo = (RowTypeInfo)typeInfo;
            String[] fieldNames = rowTypeInfo.getFieldNames();
            TypeInfo[] fieldTypeInfos = rowTypeInfo.getFieldTypeInfos();
            TypeInformation[] fieldTypes = (TypeInformation[])Arrays.stream(fieldTypeInfos).map(TableFormatUtils::getType).toArray(TypeInformation[]::new);
            return Types.ROW_NAMED((String[])fieldNames, (TypeInformation[])fieldTypes);
        }
        throw new IllegalStateException("Unexpected type info " + typeInfo + ".");
    }

    public static RowFormatInfo deserializeRowFormatInfo(DescriptorProperties descriptorProperties) {
        try {
            String schema = descriptorProperties.getString("format.schema");
            FormatInfo formatInfo = FormatUtils.demarshall(schema);
            if (!(formatInfo instanceof RowFormatInfo)) {
                throw new IllegalStateException("Unexpected format type.");
            }
            return (RowFormatInfo)formatInfo;
        }
        catch (Exception e) {
            throw new ValidationException("The schema is invalid.", (Throwable)e);
        }
    }

    public static RowFormatInfo deriveRowFormatInfo(DescriptorProperties descriptorProperties) {
        TableSchema tableSchema = TableFormatFactoryBase.deriveSchema((Map)descriptorProperties.asMap());
        int numFields = tableSchema.getFieldCount();
        String[] fieldNames = tableSchema.getFieldNames();
        DataType[] fieldTypes = tableSchema.getFieldDataTypes();
        FormatInfo[] fieldFormatInfos = new FormatInfo[numFields];
        for (int i = 0; i < numFields; ++i) {
            LogicalType fieldType = fieldTypes[i].getLogicalType();
            fieldFormatInfos[i] = TableFormatUtils.deriveFormatInfo(fieldType);
        }
        return new RowFormatInfo(fieldNames, fieldFormatInfos);
    }

    public static RowFormatInfo getRowFormatInfo(DescriptorProperties descriptorProperties) {
        if (descriptorProperties.containsKey("format.schema")) {
            return TableFormatUtils.deserializeRowFormatInfo(descriptorProperties);
        }
        return TableFormatUtils.deriveRowFormatInfo(descriptorProperties);
    }

    public static RowFormatInfo projectRowFormatInfo(RowFormatInfo rowFormatInfo, int[] fields) {
        String[] fieldNames = rowFormatInfo.getFieldNames();
        FormatInfo[] fieldFormatInfos = rowFormatInfo.getFieldFormatInfos();
        String[] projectedFieldNames = new String[fields.length];
        FormatInfo[] projectedFieldFormatInfos = new FormatInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            projectedFieldNames[i] = fieldNames[fields[i]];
            projectedFieldFormatInfos[i] = fieldFormatInfos[fields[i]];
        }
        return new RowFormatInfo(projectedFieldNames, projectedFieldFormatInfos);
    }

    public static void validateSchema(DescriptorProperties descriptorProperties) {
        boolean defineSchema = descriptorProperties.containsKey("format.schema");
        boolean deriveSchema = descriptorProperties.containsKey("format.derive-schema");
        if (defineSchema && deriveSchema) {
            throw new ValidationException("Format cannot define a schema and derive from the table's schema at the same time.");
        }
        if (defineSchema) {
            descriptorProperties.validateString("format.schema", false);
        } else if (deriveSchema) {
            descriptorProperties.validateBoolean("format.derive-schema", false);
        } else {
            throw new ValidationException("A definition of a schema or derivation from the table's schema is required.");
        }
    }

    public static Object deserializeBasicField(String fieldName, FormatInfo fieldFormatInfo, String fieldText, String nullLiteral) {
        Preconditions.checkState((boolean)(fieldFormatInfo instanceof BasicFormatInfo));
        if (fieldText == null) {
            return null;
        }
        if (nullLiteral == null) {
            if (fieldText.isEmpty()) {
                if (fieldFormatInfo instanceof StringFormatInfo) {
                    return "";
                }
                return null;
            }
        } else if (fieldText.equals(nullLiteral)) {
            return null;
        }
        try {
            return ((BasicFormatInfo)fieldFormatInfo).deserialize(fieldText);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not properly deserialize the text " + fieldText + " for field " + fieldName + ".", e);
        }
    }

    public static String serializeBasicField(String fieldName, FormatInfo fieldFormatInfo, Object field, String nullLiteral) {
        Preconditions.checkState((boolean)(fieldFormatInfo instanceof BasicFormatInfo));
        if (field == null) {
            return nullLiteral == null ? "" : nullLiteral;
        }
        try {
            return ((BasicFormatInfo)fieldFormatInfo).serialize(field);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not properly serialize the value " + field + " for field " + fieldName + ".", e);
        }
    }

    public static void getValidateProperties(DescriptorProperties properties) {
        properties.validateString("format.type", false, 1);
        properties.validateString("format.property-version", true, 1);
        properties.validateString("format.escape-character", true, 1, 1);
    }
}

