/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.msg;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class InLongMsgAttrBuilder {
    public static MsgAttrProtocolM0 getProtocolM0() {
        return new MsgAttrProtocolM0();
    }

    public static MsgAttrProtocolM100 getProtocolM100() {
        return new MsgAttrProtocolM100();
    }

    public static void main(String[] args) throws Exception {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat f1 = new SimpleDateFormat("yyyyMMddHH");
        System.out.println(InLongMsgAttrBuilder.getProtocolM0().setId("interfaceid").setTimeType(TimeType.S).setTime(String.valueOf(System.currentTimeMillis() / 1000L)).buildAttr());
        System.out.println(InLongMsgAttrBuilder.getProtocolM0().setId("interfaceid").setTime(System.currentTimeMillis()).setTimeType(TimeType.MS).buildAttr());
        System.out.println(InLongMsgAttrBuilder.getProtocolM0().setId("interfaceid").setTime(f1.format(new Date(System.currentTimeMillis()))).buildAttr());
        System.out.println(InLongMsgAttrBuilder.getProtocolM0().setId("interfaceid").setTime(f.format(new Date(System.currentTimeMillis()))).setTimeType(TimeType.STANDARD).buildAttr());
        System.out.println(InLongMsgAttrBuilder.getProtocolM0().setId("interfaceid").setTime(f1.format(new Date(System.currentTimeMillis()))).setTimeType(TimeType.NORMAL).buildAttr());
        System.out.println(InLongMsgAttrBuilder.getProtocolM0().setId("interfaceid").setTimeType(TimeType.S).setTime(String.valueOf(System.currentTimeMillis() / 1000L)).setPartitionUnit(PartitionUnit.DAY).buildAttr());
        System.out.println(InLongMsgAttrBuilder.getProtocolM0().setId("interfaceid").setTimeType(TimeType.S).setTime(String.valueOf(System.currentTimeMillis() / 1000L)).setPartitionUnit(PartitionUnit.HOUR).buildAttr());
        System.out.println(InLongMsgAttrBuilder.getProtocolM0().setId("interfaceid").setTimeType(TimeType.S).setTime(String.valueOf(System.currentTimeMillis() / 1000L)).setPartitionUnit(PartitionUnit.QUARTER).buildAttr());
        System.out.println();
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().buildAttr());
        System.out.println("\t\t\t\t\t\t// ---- all the param is default : s=\\t, idp=0, tp=1, tt=#ms, p=h ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setSpliter(",").buildAttr());
        System.out.println("\t\t\t\t\t// ---- : idp=0, tp=1, tt=#ms, p=h ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setSpliter(",").setIdPos(0).buildAttr());
        System.out.println("\t\t\t\t\t// ---- : tp=1, tt=#ms, p=h ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setSpliter(",").setTimePos(1).buildAttr());
        System.out.println("\t\t\t\t\t// ---- : idp=0, tt=#ms, p=h ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setSpliter(",").setIdPos(0).setTimePos(1).buildAttr());
        System.out.println("\t\t\t\t// ---- : tt=#ms, p=h ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setSpliter(",").setIdPos(0).setTimePos(1).setTimeType(TimeType.S).buildAttr());
        System.out.println("\t\t\t// ---- : p=h ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setSpliter(",").setIdPos(0).setTimePos(1).setPartitionUnit(PartitionUnit.QUARTER).buildAttr());
        System.out.println("\t\t\t// ---- : tt=#s ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setSpliter(",").setIdPos(0).setTimePos(1).setTimeType(TimeType.MS).setPartitionUnit(PartitionUnit.QUARTER).buildAttr());
        System.out.println("\t\t\t// ---- : all ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setId("interfaceid").setSpliter(",").setIdPos(0).setTimePos(1).setTimeType(TimeType.MS).setPartitionUnit(PartitionUnit.QUARTER).buildAttr());
        System.out.println("\t// ---- : id is set so idp is ignored ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setSpliter(",").setIdPos(0).setTimePos(1).setTime(System.currentTimeMillis()).setTimeType(TimeType.MS).setPartitionUnit(PartitionUnit.QUARTER).buildAttr());
        System.out.println("\t\t\t// ---- : t is set so tp is ignored ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setId("interfaceid").setSpliter(",").setIdPos(0).setTimePos(1).setTime(System.currentTimeMillis()).setTimeType(TimeType.MS).setPartitionUnit(PartitionUnit.QUARTER).buildAttr());
        System.out.println("\t\t// ---- : id and t are all set so idpos and tp are all ignored ");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setId("interfaceid").setSpliter(",").setIdPos(0).setTimePos(1).setTime(f1.format(new Date(System.currentTimeMillis()))).setTimeType(TimeType.NORMAL).setPartitionUnit(PartitionUnit.QUARTER).buildAttr());
        System.out.println("\t\t// ---- : TimeType.NORMAL ");
        System.out.println("\nAttention !!!! m=0 is contained by m=100, so just use m=100");
        System.out.print(InLongMsgAttrBuilder.getProtocolM100().setSpliter(",").setIdPos(0).setTimePos(1).setTimeType(TimeType.STANDARD).setPartitionUnit(PartitionUnit.QUARTER).buildAttr());
    }

    private static Date transData(TimeType tt, String timeStr) throws Exception {
        Date d = null;
        if (tt == TimeType.MS) {
            d = new Date(Long.valueOf(timeStr));
        } else if (tt == TimeType.S) {
            d = new Date(Long.valueOf(timeStr) * 1000L);
        } else if (tt == TimeType.STANDARD) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            d = f.parse(timeStr);
        } else if (tt == TimeType.NORMAL) {
            SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHH");
            d = f.parse(timeStr);
        }
        return d;
    }

    public static class MsgAttrProtocolM100 {
        private final StringBuffer attrBuffer = new StringBuffer();
        private String id = null;
        private String t = null;
        private int idp = -1;
        private int tp = -1;
        private TimeType tt = null;
        private PartitionUnit p = null;

        public MsgAttrProtocolM100() {
            this.attrBuffer.append("m=100");
        }

        public MsgAttrProtocolM100 setSpliter(String s2) {
            this.attrBuffer.append("&s=").append(s2);
            return this;
        }

        public MsgAttrProtocolM100 setId(String id) {
            this.id = id;
            return this;
        }

        public MsgAttrProtocolM100 setTime(String t2) {
            this.t = t2;
            return this;
        }

        public MsgAttrProtocolM100 setTime(long t2) {
            return this.setTime(String.valueOf(t2));
        }

        public MsgAttrProtocolM100 setIdPos(int idp) {
            this.idp = idp;
            return this;
        }

        public MsgAttrProtocolM100 setTimePos(int tp) {
            this.tp = tp;
            return this;
        }

        public MsgAttrProtocolM100 setTimeType(String tt) {
            return this.setTimeType(TimeType.of(tt));
        }

        public MsgAttrProtocolM100 setTimeType(TimeType tt) {
            this.tt = tt;
            return this;
        }

        public MsgAttrProtocolM100 setPartitionUnit(String p) {
            return this.setPartitionUnit(PartitionUnit.of(p));
        }

        public MsgAttrProtocolM100 setPartitionUnit(PartitionUnit p) {
            this.p = p;
            return this;
        }

        public String buildAttr() throws Exception {
            if (this.id != null) {
                this.attrBuffer.append("&iname=").append(this.id);
            } else if (this.idp >= 0) {
                this.attrBuffer.append("&idp=").append(this.idp);
            }
            if (this.t != null) {
                String tstr = null;
                if (this.tt != null && this.tt == TimeType.NORMAL) {
                    if (this.makeSureTimeNormal(this.t)) {
                        tstr = this.t;
                    }
                } else {
                    if (this.p == null) {
                        this.p = PartitionUnit.HOUR;
                    }
                    Date d = InLongMsgAttrBuilder.transData(this.tt, this.t);
                    if (this.p == PartitionUnit.DAY) {
                        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
                        tstr = f.format(d);
                    } else if (this.p == PartitionUnit.HOUR) {
                        SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHH");
                        tstr = f.format(d);
                    } else if (this.p == PartitionUnit.HALFHOUR) {
                        int idx = (int)(d.getTime() % 3600000L / 1800000L);
                        SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHH");
                        tstr = f.format(d) + "n" + idx;
                    } else if (this.p == PartitionUnit.QUARTER) {
                        int idx = (int)(d.getTime() % 3600000L / 900000L);
                        SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHH");
                        tstr = f.format(d) + "q" + idx;
                    } else if (this.p == PartitionUnit.TENMINS) {
                        int idx = (int)(d.getTime() % 3600000L / 600000L);
                        SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHH");
                        tstr = f.format(d) + "t" + idx;
                    } else if (this.p == PartitionUnit.FIVEMINS) {
                        int idx = (int)(d.getTime() % 3600000L / 300000L);
                        SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHH");
                        tstr = f.format(d) + "f" + idx;
                    }
                }
                if (tstr != null) {
                    this.attrBuffer.append("&t=").append(tstr);
                }
            } else if (this.tp >= 0) {
                this.attrBuffer.append("&tp=").append(this.tp);
                if (this.tt != null) {
                    this.attrBuffer.append("&tt=").append((Object)this.tt);
                }
                if (this.p != null) {
                    this.attrBuffer.append("&p=").append((Object)this.p);
                }
            }
            return this.attrBuffer.toString();
        }

        private boolean makeSureTimeNormal(String time) {
            int len = time.length();
            return len == 8 || len == 10 || len == 12 && time.charAt(10) == 'p';
        }
    }

    public static class MsgAttrProtocolM0 {
        private final StringBuffer attrBuffer;
        private String id = null;
        private String t = null;
        private TimeType tt = TimeType.NORMAL;
        private PartitionUnit p = PartitionUnit.HOUR;

        public MsgAttrProtocolM0() {
            this.attrBuffer = new StringBuffer();
            this.attrBuffer.append("m=0");
        }

        public MsgAttrProtocolM0 setId(String id) {
            this.id = id;
            return this;
        }

        public MsgAttrProtocolM0 setSpliter(String s2) {
            this.attrBuffer.append("&s=").append(s2);
            return this;
        }

        public MsgAttrProtocolM0 setTime(String t2) {
            this.t = t2;
            return this;
        }

        public MsgAttrProtocolM0 setTime(long t2) {
            return this.setTime(String.valueOf(t2));
        }

        public MsgAttrProtocolM0 setTimeType(String tt) {
            this.tt = TimeType.of(tt);
            return this;
        }

        public MsgAttrProtocolM0 setTimeType(TimeType tt) {
            this.tt = tt;
            return this;
        }

        public MsgAttrProtocolM0 setPartitionUnit(String p) {
            this.p = PartitionUnit.of(p);
            return this;
        }

        public MsgAttrProtocolM0 setPartitionUnit(PartitionUnit p) {
            this.p = p;
            return this;
        }

        public String buildAttr() throws Exception {
            if (this.id == null) {
                throw new Exception("id is null");
            }
            if (this.t == null) {
                throw new Exception("t is null");
            }
            this.attrBuffer.append("&iname=").append(this.id);
            Date d = InLongMsgAttrBuilder.transData(this.tt, this.t);
            String tstr = null;
            if (this.p == PartitionUnit.DAY) {
                SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
                tstr = f.format(d);
            } else if (this.p == PartitionUnit.HOUR) {
                SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHH");
                tstr = f.format(d);
            } else if (this.p == PartitionUnit.QUARTER) {
                int idx = (int)(d.getTime() % 3600000L / 900000L);
                SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHH");
                tstr = f.format(d) + "q" + idx;
            }
            return this.attrBuffer.append("&t=").append(tstr).toString();
        }
    }

    public static enum TimeType {
        MS("#ms"),
        S("#s"),
        STANDARD("#"),
        NORMAL("#n");

        private static final Map<String, TimeType> STRING_TO_TYPE_MAP;
        private final String value;

        private TimeType(String value) {
            this.value = value;
        }

        public static TimeType of(String tt) {
            TimeType type = STRING_TO_TYPE_MAP.get(tt);
            if (type == null) {
                return STANDARD;
            }
            return type;
        }

        public String toString() {
            return this.value;
        }

        static {
            STRING_TO_TYPE_MAP = new HashMap<String, TimeType>();
            for (TimeType type : TimeType.values()) {
                STRING_TO_TYPE_MAP.put(type.value, type);
            }
        }
    }

    public static enum PartitionUnit {
        DAY("d"),
        HOUR("h"),
        HALFHOUR("n"),
        QUARTER("q"),
        TENMINS("t"),
        FIVEMINS("f");

        private static final Map<String, PartitionUnit> STRING_TO_TYPE_MAP;
        private final String value;

        private PartitionUnit(String value) {
            this.value = value;
        }

        public static PartitionUnit of(String p) {
            PartitionUnit type = STRING_TO_TYPE_MAP.get(p);
            if (type == null) {
                return HOUR;
            }
            return type;
        }

        public String toString() {
            return this.value;
        }

        static {
            STRING_TO_TYPE_MAP = new HashMap<String, PartitionUnit>();
            for (PartitionUnit type : PartitionUnit.values()) {
                STRING_TO_TYPE_MAP.put(type.value, type);
            }
        }
    }
}

