/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.IOException;
import java.util.List;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcBatchReader;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.OrcSplitReader;
import org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.types.Row;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.TypeDescription;

public class OrcRowSplitReader
extends OrcSplitReader<Row, VectorizedRowBatch> {
    private final TypeDescription schema;
    private final int[] selectedFields;
    private final Row[] rows;

    public OrcRowSplitReader(Configuration conf, TypeDescription schema, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates, int batchSize, Path path, long splitStart, long splitLength) throws IOException {
        super(OrcShim.defaultShim(), conf, schema, selectedFields, conjunctPredicates, batchSize, path, splitStart, splitLength);
        this.schema = schema;
        this.selectedFields = selectedFields;
        this.rows = new Row[batchSize];
        for (int i = 0; i < batchSize; ++i) {
            this.rows[i] = new Row(selectedFields.length);
        }
    }

    @Override
    protected int fillRows() {
        return OrcBatchReader.fillRows(this.rows, this.schema, (VectorizedRowBatch)this.rowBatchWrapper.getBatch(), this.selectedFields);
    }

    @Override
    public Row nextRecord(Row reuse) {
        return this.rows[this.nextRow++];
    }
}

