/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.OrcSplitReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.TypeDescription;

public abstract class OrcInputFormat<T>
extends FileInputFormat<T> {
    protected int batchSize;
    protected Configuration conf;
    protected TypeDescription schema;
    protected int[] selectedFields;
    protected ArrayList<OrcFilters.Predicate> conjunctPredicates = new ArrayList();
    protected transient OrcSplitReader<T, ?> reader;

    public OrcInputFormat(Path path, TypeDescription orcSchema, Configuration orcConfig, int batchSize) {
        super(path);
        this.schema = orcSchema;
        this.conf = orcConfig;
        this.batchSize = batchSize;
        this.selectedFields = new int[this.schema.getChildren().size()];
        for (int i = 0; i < this.selectedFields.length; ++i) {
            this.selectedFields[i] = i;
        }
    }

    public void selectFields(int ... selectedFields) {
        this.selectedFields = selectedFields;
    }

    public void addPredicate(OrcFilters.Predicate predicate) {
        this.validatePredicate(predicate);
        this.conjunctPredicates.add(predicate);
    }

    private void validatePredicate(OrcFilters.Predicate pred) {
        if (pred instanceof OrcFilters.ColumnPredicate) {
            String colName = ((OrcFilters.ColumnPredicate)pred).columnName;
            if (!this.schema.getFieldNames().contains(colName)) {
                throw new IllegalArgumentException("Predicate cannot be applied. Column '" + colName + "' does not exist in ORC schema.");
            }
        } else if (pred instanceof OrcFilters.Not) {
            this.validatePredicate(((OrcFilters.Not)pred).child());
        } else if (pred instanceof OrcFilters.Or) {
            for (OrcFilters.Predicate p : ((OrcFilters.Or)pred).children()) {
                this.validatePredicate(p);
            }
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
    }

    public void closeInputFormat() throws IOException {
        this.schema = null;
    }

    public boolean reachedEnd() throws IOException {
        return this.reader.reachedEnd();
    }

    public T nextRecord(T reuse) throws IOException {
        return this.reader.nextRecord(reuse);
    }

    @VisibleForTesting
    OrcSplitReader<T, ?> getReader() {
        return this.reader;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.batchSize);
        this.conf.write((DataOutput)out);
        out.writeUTF(this.schema.toString());
        out.writeInt(this.selectedFields.length);
        for (int f : this.selectedFields) {
            out.writeInt(f);
        }
        out.writeInt(this.conjunctPredicates.size());
        Object object = this.conjunctPredicates.iterator();
        while (object.hasNext()) {
            OrcFilters.Predicate p = (OrcFilters.Predicate)object.next();
            out.writeObject(p);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.batchSize = in.readInt();
        Configuration configuration = new Configuration();
        configuration.readFields((DataInput)in);
        if (this.conf == null) {
            this.conf = configuration;
        }
        this.schema = TypeDescription.fromString(in.readUTF());
        this.selectedFields = new int[in.readInt()];
        for (int i = 0; i < this.selectedFields.length; ++i) {
            this.selectedFields[i] = in.readInt();
        }
        this.conjunctPredicates = new ArrayList();
        int numPreds = in.readInt();
        for (int i = 0; i < numPreds; ++i) {
            this.conjunctPredicates.add((OrcFilters.Predicate)in.readObject());
        }
    }

    public boolean supportsMultiPaths() {
        return true;
    }

    @VisibleForTesting
    Configuration getConfiguration() {
        return this.conf;
    }

    @VisibleForTesting
    int getBatchSize() {
        return this.batchSize;
    }

    @VisibleForTesting
    String getSchema() {
        return this.schema.toString();
    }
}

