/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.formats.parquet.ParquetColumnarRowInputFormat;
import org.apache.flink.formats.parquet.row.ParquetRowDataBuilder;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.BulkDecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.BulkReaderFormatFactory;
import org.apache.flink.table.factories.BulkWriterFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.filesystem.FileSystemOptions;
import org.apache.flink.table.filesystem.PartitionFieldExtractor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

public class ParquetFileFormatFactory
implements BulkReaderFormatFactory,
BulkWriterFormatFactory {
    public static final String IDENTIFIER = "parquet";
    public static final ConfigOption<Boolean> UTC_TIMEZONE = ConfigOptions.key((String)"utc-timezone").booleanType().defaultValue((Object)false).withDescription("Use UTC timezone or local timezone to the conversion between epoch time and LocalDateTime. Hive 0.x/1.x/2.x use local timezone. But Hive 3.x use UTC timezone");

    public BulkDecodingFormat<RowData> createDecodingFormat(final DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        return new BulkDecodingFormat<RowData>(){

            public BulkFormat<RowData, FileSourceSplit> createRuntimeDecoder(DynamicTableSource.Context sourceContext, DataType producedDataType) {
                String defaultPartName = (String)context.getCatalogTable().getOptions().getOrDefault(FileSystemOptions.PARTITION_DEFAULT_NAME.key(), FileSystemOptions.PARTITION_DEFAULT_NAME.defaultValue());
                return ParquetColumnarRowInputFormat.createPartitionedFormat(ParquetFileFormatFactory.getParquetConfiguration(formatOptions), (RowType)producedDataType.getLogicalType(), context.getCatalogTable().getPartitionKeys(), PartitionFieldExtractor.forFileSystem((String)defaultPartName), 2048, (Boolean)formatOptions.get(UTC_TIMEZONE), true);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public EncodingFormat<BulkWriter.Factory<RowData>> createEncodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        return new EncodingFormat<BulkWriter.Factory<RowData>>(){

            public BulkWriter.Factory<RowData> createRuntimeEncoder(DynamicTableSink.Context sinkContext, DataType consumedDataType) {
                return ParquetRowDataBuilder.createWriterFactory((RowType)consumedDataType.getLogicalType(), ParquetFileFormatFactory.getParquetConfiguration(formatOptions), (Boolean)formatOptions.get(UTC_TIMEZONE));
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    private static org.apache.hadoop.conf.Configuration getParquetConfiguration(ReadableConfig options) {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        Properties properties = new Properties();
        ((Configuration)options).addAllToProperties(properties);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> conf.set("parquet." + k, v.toString())));
        return conf;
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new HashSet();
    }
}

