/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.debezium;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.debezium.DebeziumJsonDeserializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;

public class DebeziumJsonDecodingFormat
implements DecodingFormat<DeserializationSchema<RowData>> {
    private List<String> metadataKeys;
    private final boolean schemaInclude;
    private final boolean ignoreParseErrors;
    private final TimestampFormat timestampFormat;
    private static final StringData KEY_SOURCE_TIMESTAMP = StringData.fromString((String)"ts_ms");
    private static final StringData KEY_SOURCE_DATABASE = StringData.fromString((String)"db");
    private static final StringData KEY_SOURCE_SCHEMA = StringData.fromString((String)"schema");
    private static final StringData KEY_SOURCE_TABLE = StringData.fromString((String)"table");

    public DebeziumJsonDecodingFormat(boolean schemaInclude, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        this.schemaInclude = schemaInclude;
        this.ignoreParseErrors = ignoreParseErrors;
        this.timestampFormat = timestampFormat;
        this.metadataKeys = Collections.emptyList();
    }

    public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType physicalDataType) {
        List<ReadableMetadata> readableMetadata = this.metadataKeys.stream().map(k -> Stream.of(ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).collect(Collectors.toList());
        List metadataFields = readableMetadata.stream().map(m4 -> DataTypes.FIELD((String)m4.key, (DataType)m4.dataType)).collect(Collectors.toList());
        DataType producedDataType = DataTypeUtils.appendRowFields((DataType)physicalDataType, metadataFields);
        TypeInformation producedTypeInfo = context.createTypeInformation(producedDataType);
        return new DebeziumJsonDeserializationSchema(physicalDataType, readableMetadata, (TypeInformation<RowData>)producedTypeInfo, this.schemaInclude, this.ignoreParseErrors, this.timestampFormat);
    }

    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        Stream.of(ReadableMetadata.values()).forEachOrdered(m4 -> metadataMap.put(m4.key, m4.dataType));
        return metadataMap;
    }

    public void applyReadableMetadata(List<String> metadataKeys) {
        this.metadataKeys = metadataKeys;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    private static Object readProperty(GenericRowData row, int pos, StringData key) {
        GenericMapData map = (GenericMapData)row.getMap(pos);
        if (map == null) {
            return null;
        }
        return map.get((Object)key);
    }

    static enum ReadableMetadata {
        SCHEMA("schema", (DataType)DataTypes.STRING().nullable(), false, DataTypes.FIELD((String)"schema", (DataType)DataTypes.STRING()), new DebeziumJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getString(pos);
            }
        }),
        INGESTION_TIMESTAMP("ingestion-timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).nullable(), true, DataTypes.FIELD((String)"ts_ms", (DataType)DataTypes.BIGINT()), new DebeziumJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return TimestampData.fromEpochMillis((long)row.getLong(pos));
            }
        }),
        SOURCE_TIMESTAMP("source.timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).nullable(), true, DataTypes.FIELD((String)"source", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())), new DebeziumJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                StringData timestamp = (StringData)DebeziumJsonDecodingFormat.readProperty(row, pos, KEY_SOURCE_TIMESTAMP);
                if (timestamp == null) {
                    return null;
                }
                return TimestampData.fromEpochMillis((long)Long.parseLong(timestamp.toString()));
            }
        }),
        SOURCE_DATABASE("source.database", (DataType)DataTypes.STRING().nullable(), true, DataTypes.FIELD((String)"source", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())), new DebeziumJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return DebeziumJsonDecodingFormat.readProperty(row, pos, KEY_SOURCE_DATABASE);
            }
        }),
        SOURCE_SCHEMA("source.schema", (DataType)DataTypes.STRING().nullable(), true, DataTypes.FIELD((String)"source", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())), new DebeziumJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return DebeziumJsonDecodingFormat.readProperty(row, pos, KEY_SOURCE_SCHEMA);
            }
        }),
        SOURCE_TABLE("source.table", (DataType)DataTypes.STRING().nullable(), true, DataTypes.FIELD((String)"source", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())), new DebeziumJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return DebeziumJsonDecodingFormat.readProperty(row, pos, KEY_SOURCE_TABLE);
            }
        }),
        SOURCE_PROPERTIES("source.properties", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable())).nullable(), true, DataTypes.FIELD((String)"source", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())), new DebeziumJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getMap(pos);
            }
        });

        final String key;
        final DataType dataType;
        final boolean isJsonPayload;
        final DataTypes.Field requiredJsonField;
        final DebeziumJsonDeserializationSchema.MetadataConverter converter;

        private ReadableMetadata(String key, DataType dataType, boolean isJsonPayload, DataTypes.Field requiredJsonField, DebeziumJsonDeserializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.isJsonPayload = isJsonPayload;
            this.requiredJsonField = requiredJsonField;
            this.converter = converter;
        }
    }
}

