/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.canal;

import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonOptions;
import org.apache.flink.formats.json.JsonRowDataSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;

public class CanalJsonSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final StringData OP_INSERT = StringData.fromString((String)"INSERT");
    private static final StringData OP_DELETE = StringData.fromString((String)"DELETE");
    private transient GenericRowData reuse;
    private final JsonRowDataSerializationSchema jsonSerializer;

    public CanalJsonSerializationSchema(RowType rowType, TimestampFormat timestampFormat, JsonOptions.MapNullKeyMode mapNullKeyMode, String mapNullKeyLiteral, boolean encodeDecimalAsPlainNumber) {
        this.jsonSerializer = new JsonRowDataSerializationSchema(CanalJsonSerializationSchema.createJsonRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType)), timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber);
    }

    public void open(SerializationSchema.InitializationContext context) {
        this.reuse = new GenericRowData(2);
    }

    public byte[] serialize(RowData row) {
        try {
            StringData opType = this.rowKind2String(row.getRowKind());
            GenericArrayData arrayData = new GenericArrayData((Object[])new RowData[]{row});
            this.reuse.setField(0, (Object)arrayData);
            this.reuse.setField(1, (Object)opType);
            return this.jsonSerializer.serialize((RowData)this.reuse);
        }
        catch (Throwable t2) {
            throw new RuntimeException("Could not serialize row '" + row + "'.", t2);
        }
    }

    private StringData rowKind2String(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: 
            case UPDATE_AFTER: {
                return OP_INSERT;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                return OP_DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported operation '" + rowKind + "' for row kind.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanalJsonSerializationSchema that = (CanalJsonSerializationSchema)o;
        return Objects.equals(this.jsonSerializer, that.jsonSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSerializer);
    }

    private static RowType createJsonRowType(DataType databaseSchema) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)DataTypes.ARRAY((DataType)databaseSchema)), DataTypes.FIELD((String)"type", (DataType)DataTypes.STRING())}).getLogicalType();
    }
}

