/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.AbstractDeserializationSchema;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.avro.shaded.org.apache.avro.LogicalTypes;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericDatumReader;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericFixed;
import org.apache.flink.avro.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.flink.avro.shaded.org.apache.avro.io.DatumReader;
import org.apache.flink.avro.shaded.org.apache.avro.io.Decoder;
import org.apache.flink.avro.shaded.org.apache.avro.io.DecoderFactory;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificData;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificDatumReader;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificRecord;
import org.apache.flink.formats.avro.JodaConverter;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.formats.avro.utils.MutableByteArrayInputStream;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class AvroRowDeserializationSchema
extends AbstractDeserializationSchema<Row> {
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private static final long MICROS_PER_SECOND = 1000000L;
    private Class<? extends SpecificRecord> recordClazz;
    private String schemaString;
    private transient Schema schema;
    private transient RowTypeInfo typeInfo;
    private transient IndexedRecord record;
    private transient DatumReader<IndexedRecord> datumReader;
    private transient MutableByteArrayInputStream inputStream;
    private transient Decoder decoder;
    @Nullable
    private transient JodaConverter jodaConverter;

    public AvroRowDeserializationSchema(Class<? extends SpecificRecord> recordClazz) {
        Preconditions.checkNotNull(recordClazz, (String)"Avro record class must not be null.");
        this.recordClazz = recordClazz;
        this.schema = SpecificData.get().getSchema(recordClazz);
        this.typeInfo = (RowTypeInfo)AvroSchemaConverter.convertToTypeInfo(recordClazz);
        this.schemaString = this.schema.toString();
        this.record = (IndexedRecord)SpecificData.newInstance(recordClazz, this.schema);
        this.datumReader = new SpecificDatumReader<IndexedRecord>(this.schema);
        this.inputStream = new MutableByteArrayInputStream();
        this.decoder = DecoderFactory.get().binaryDecoder(this.inputStream, null);
        this.jodaConverter = JodaConverter.getConverter();
    }

    public AvroRowDeserializationSchema(String avroSchemaString) {
        Preconditions.checkNotNull((Object)avroSchemaString, (String)"Avro schema must not be null.");
        this.recordClazz = null;
        TypeInformation typeInfo = AvroSchemaConverter.convertToTypeInfo(avroSchemaString);
        Preconditions.checkArgument((boolean)(typeInfo instanceof RowTypeInfo), (Object)"Row type information expected.");
        this.typeInfo = (RowTypeInfo)typeInfo;
        this.schemaString = avroSchemaString;
        this.schema = new Schema.Parser().parse(avroSchemaString);
        this.record = new GenericData.Record(this.schema);
        this.datumReader = new GenericDatumReader<IndexedRecord>(this.schema);
        this.inputStream = new MutableByteArrayInputStream();
        this.decoder = DecoderFactory.get().binaryDecoder(this.inputStream, null);
        this.jodaConverter = JodaConverter.getConverter();
    }

    public Row deserialize(byte[] message) throws IOException {
        try {
            this.inputStream.setBuffer(message);
            this.record = this.datumReader.read(this.record, this.decoder);
            return this.convertAvroRecordToRow(this.schema, this.typeInfo, this.record);
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize Avro record.", e);
        }
    }

    public TypeInformation<Row> getProducedType() {
        return this.typeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AvroRowDeserializationSchema that = (AvroRowDeserializationSchema)((Object)o);
        return Objects.equals(this.recordClazz, that.recordClazz) && Objects.equals(this.schemaString, that.schemaString);
    }

    public int hashCode() {
        return Objects.hash(this.recordClazz, this.schemaString);
    }

    private Row convertAvroRecordToRow(Schema schema, RowTypeInfo typeInfo, IndexedRecord record) {
        List<Schema.Field> fields = schema.getFields();
        TypeInformation[] fieldInfo = typeInfo.getFieldTypes();
        int length = fields.size();
        Row row = new Row(length);
        for (int i = 0; i < length; ++i) {
            Schema.Field field = fields.get(i);
            row.setField(i, this.convertAvroType(field.schema(), fieldInfo[i], record.get(i)));
        }
        return row;
    }

    private Object convertAvroType(Schema schema, TypeInformation<?> info, Object object) {
        if (object == null) {
            return null;
        }
        switch (schema.getType()) {
            case RECORD: {
                if (object instanceof IndexedRecord) {
                    return this.convertAvroRecordToRow(schema, (RowTypeInfo)info, (IndexedRecord)object);
                }
                throw new IllegalStateException("IndexedRecord expected but was: " + object.getClass());
            }
            case ENUM: 
            case STRING: {
                return object.toString();
            }
            case ARRAY: {
                if (info instanceof BasicArrayTypeInfo) {
                    TypeInformation elementInfo = ((BasicArrayTypeInfo)info).getComponentInfo();
                    return this.convertToObjectArray(schema.getElementType(), elementInfo, object);
                }
                TypeInformation elementInfo = ((ObjectArrayTypeInfo)info).getComponentInfo();
                return this.convertToObjectArray(schema.getElementType(), elementInfo, object);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)info;
                HashMap<String, Object> convertedMap = new HashMap<String, Object>();
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    convertedMap.put(entry.getKey().toString(), this.convertAvroType(schema.getValueType(), mapTypeInfo.getValueTypeInfo(), entry.getValue()));
                }
                return convertedMap;
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                int size = types.size();
                if (size == 2 && types.get(0).getType() == Schema.Type.NULL) {
                    return this.convertAvroType(types.get(1), info, object);
                }
                if (size == 2 && types.get(1).getType() == Schema.Type.NULL) {
                    return this.convertAvroType(types.get(0), info, object);
                }
                if (size == 1) {
                    return this.convertAvroType(types.get(0), info, object);
                }
                return object;
            }
            case FIXED: {
                byte[] fixedBytes = ((GenericFixed)object).bytes();
                if (info == Types.BIG_DEC) {
                    return this.convertToDecimal(schema, fixedBytes);
                }
                return fixedBytes;
            }
            case BYTES: {
                ByteBuffer byteBuffer = (ByteBuffer)object;
                byte[] bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
                if (info == Types.BIG_DEC) {
                    return this.convertToDecimal(schema, bytes);
                }
                return bytes;
            }
            case INT: {
                if (info == Types.SQL_DATE) {
                    return this.convertToDate(object);
                }
                if (info == Types.SQL_TIME) {
                    return this.convertToTime(object);
                }
                return object;
            }
            case LONG: {
                if (info == Types.SQL_TIMESTAMP) {
                    return this.convertToTimestamp(object, schema.getLogicalType() == LogicalTypes.timestampMicros());
                }
                if (info == Types.SQL_TIME) {
                    return this.convertToTime(object);
                }
                return object;
            }
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return object;
            }
        }
        throw new RuntimeException("Unsupported Avro type:" + schema);
    }

    private BigDecimal convertToDecimal(Schema schema, byte[] bytes) {
        LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)schema.getLogicalType();
        return new BigDecimal(new BigInteger(bytes), decimalType.getScale());
    }

    private Date convertToDate(Object object) {
        long millis;
        if (object instanceof Integer) {
            Integer value = (Integer)object;
            long t2 = (long)value.intValue() * 86400000L;
            millis = t2 - (long)LOCAL_TZ.getOffset(t2);
        } else if (object instanceof LocalDate) {
            long t3 = ((LocalDate)object).toEpochDay() * 86400000L;
            millis = t3 - (long)LOCAL_TZ.getOffset(t3);
        } else if (this.jodaConverter != null) {
            millis = this.jodaConverter.convertDate(object);
        } else {
            throw new IllegalArgumentException("Unexpected object type for DATE logical type. Received: " + object);
        }
        return new Date(millis);
    }

    private Time convertToTime(Object object) {
        long millis;
        if (object instanceof Integer) {
            millis = ((Integer)object).intValue();
        } else if (object instanceof Long) {
            millis = (Long)object / 1000L;
        } else if (object instanceof LocalTime) {
            millis = ((LocalTime)object).get(ChronoField.MILLI_OF_DAY);
        } else if (this.jodaConverter != null) {
            millis = this.jodaConverter.convertTime(object);
        } else {
            throw new IllegalArgumentException("Unexpected object type for DATE logical type. Received: " + object);
        }
        return new Time(millis - (long)LOCAL_TZ.getOffset(millis));
    }

    private Timestamp convertToTimestamp(Object object, boolean isMicros) {
        long millis;
        if (object instanceof Long) {
            if (isMicros) {
                long micros = (Long)object;
                int offsetMillis = LOCAL_TZ.getOffset(micros / 1000L);
                long seconds = micros / 1000000L - (long)(offsetMillis / 1000);
                int nanos = (int)(micros % 1000000L) * 1000 - offsetMillis % 1000 * 1000;
                Timestamp timestamp = new Timestamp(seconds * 1000L);
                timestamp.setNanos(nanos);
                return timestamp;
            }
            millis = (Long)object;
        } else {
            if (object instanceof Instant) {
                Instant instant = (Instant)object;
                int offsetMillis = LOCAL_TZ.getOffset(instant.toEpochMilli());
                long seconds = instant.getEpochSecond() - (long)(offsetMillis / 1000);
                int nanos = instant.getNano() - offsetMillis % 1000 * 1000;
                Timestamp timestamp = new Timestamp(seconds * 1000L);
                timestamp.setNanos(nanos);
                return timestamp;
            }
            if (this.jodaConverter != null) {
                millis = this.jodaConverter.convertTimestamp(object);
            } else {
                throw new IllegalArgumentException("Unexpected object type for DATE logical type. Received: " + object);
            }
        }
        return new Timestamp(millis - (long)LOCAL_TZ.getOffset(millis));
    }

    private Object[] convertToObjectArray(Schema elementSchema, TypeInformation<?> elementInfo, Object object) {
        List list = (List)object;
        Object[] convertedArray = (Object[])Array.newInstance(elementInfo.getTypeClass(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            convertedArray[i] = this.convertAvroType(elementSchema, elementInfo, list.get(i));
        }
        return convertedArray;
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.writeObject(this.recordClazz);
        outputStream.writeUTF(this.schemaString);
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        this.recordClazz = (Class)inputStream.readObject();
        this.schemaString = inputStream.readUTF();
        this.typeInfo = (RowTypeInfo)AvroSchemaConverter.convertToTypeInfo(this.schemaString);
        this.schema = new Schema.Parser().parse(this.schemaString);
        this.record = this.recordClazz != null ? (SpecificRecord)SpecificData.newInstance(this.recordClazz, this.schema) : new GenericData.Record(this.schema);
        this.datumReader = new SpecificDatumReader<IndexedRecord>(this.schema);
        this.inputStream = new MutableByteArrayInputStream();
        this.decoder = DecoderFactory.get().binaryDecoder(this.inputStream, null);
        this.jodaConverter = JodaConverter.getConverter();
    }
}

