/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonError;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonItem;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonQuery;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonTemplate;
import org.springframework.lang.Nullable;

final class CollectionJson<T> {
    private final String version;
    @Nullable
    private final String href;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Links links;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<CollectionJsonItem<T>> items;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<CollectionJsonQuery> queries;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final CollectionJsonTemplate template;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final CollectionJsonError error;

    @JsonCreator
    CollectionJson(@JsonProperty(value="version") String version, @JsonProperty(value="href") @Nullable String href, @JsonProperty(value="links") @Nullable Links links, @JsonProperty(value="items") @Nullable List<CollectionJsonItem<T>> items, @JsonProperty(value="queries") @Nullable List<CollectionJsonQuery> queries, @JsonProperty(value="template") @Nullable CollectionJsonTemplate template, @JsonProperty(value="error") @Nullable CollectionJsonError error) {
        this.version = version;
        this.href = href;
        this.links = links == null ? Links.NONE : links;
        this.items = items == null ? Collections.emptyList() : items;
        this.queries = queries == null ? Collections.emptyList() : queries;
        this.template = template;
        this.error = error;
    }

    CollectionJson() {
        this("1.0", null, Links.NONE, Collections.emptyList(), null, null, null);
    }

    CollectionJson<T> withVersion(String version) {
        return this.version == version ? this : new CollectionJson<T>(version, this.href, this.links, this.items, this.queries, this.template, this.error);
    }

    CollectionJson<T> withHref(@Nullable String href) {
        return this.href == href ? this : new CollectionJson<T>(this.version, href, this.links, this.items, this.queries, this.template, this.error);
    }

    CollectionJson<T> withLinks(Link ... links) {
        return this.withLinks(Links.of(links));
    }

    CollectionJson<T> withLinks(Links links) {
        return this.links == links ? this : new CollectionJson<T>(this.version, this.href, links, this.items, this.queries, this.template, this.error);
    }

    CollectionJson<T> withOwnSelfLink() {
        String href = this.href;
        if (href == null) {
            return this;
        }
        return this.withLinks(Links.of(Link.of(href)).merge(Links.MergeMode.SKIP_BY_REL, this.links));
    }

    @SafeVarargs
    final CollectionJson<T> withItems(CollectionJsonItem<T> ... items) {
        return this.withItems(Arrays.asList(items));
    }

    CollectionJson<T> withItems(List<CollectionJsonItem<T>> items) {
        return this.items == items ? this : new CollectionJson<T>(this.version, this.href, this.links, items, this.queries, this.template, this.error);
    }

    CollectionJson<T> withQueries(List<CollectionJsonQuery> queries) {
        return this.queries == queries ? this : new CollectionJson<T>(this.version, this.href, this.links, this.items, queries, this.template, this.error);
    }

    CollectionJson<T> withTemplate(@Nullable CollectionJsonTemplate template) {
        return this.template == template ? this : new CollectionJson<T>(this.version, this.href, this.links, this.items, this.queries, template, this.error);
    }

    CollectionJson<T> withError(@Nullable CollectionJsonError error) {
        return this.error == error ? this : new CollectionJson<T>(this.version, this.href, this.links, this.items, this.queries, this.template, error);
    }

    boolean hasItems() {
        return !this.items.isEmpty();
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    @Nullable
    public String getHref() {
        return this.href;
    }

    @JsonProperty
    public Links getLinks() {
        return this.links;
    }

    @JsonProperty
    public List<CollectionJsonItem<T>> getItems() {
        return this.items;
    }

    @JsonProperty
    public List<CollectionJsonQuery> getQueries() {
        return this.queries;
    }

    @JsonProperty
    @Nullable
    public CollectionJsonTemplate getTemplate() {
        return this.template;
    }

    @JsonProperty
    @Nullable
    public CollectionJsonError getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionJson that = (CollectionJson)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.href, that.href) && Objects.equals(this.links, that.links) && Objects.equals(this.items, that.items) && Objects.equals(this.queries, that.queries) && Objects.equals(this.template, that.template) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.href, this.links, this.items, this.queries, this.template, this.error);
    }

    public String toString() {
        return "CollectionJson{version='" + this.version + '\'' + ", href='" + this.href + '\'' + ", links=" + this.links + ", items=" + this.items + ", queries=" + this.queries + ", template=" + this.template + ", error=" + this.error + '}';
    }
}

