/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.sink;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import io.netty.handler.codec.TooLongFrameException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.apache.inlong.audit.base.HighPriorityThreadFactory;
import org.apache.inlong.audit.sink.EventStat;
import org.apache.inlong.audit.sink.pulsar.CreatePulsarClientCallBack;
import org.apache.inlong.audit.sink.pulsar.PulsarClientService;
import org.apache.inlong.audit.sink.pulsar.SendMessageCallBack;
import org.apache.inlong.audit.utils.FailoverChannelProcessorHolder;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSink
extends AbstractSink
implements Configurable,
SendMessageCallBack,
CreatePulsarClientCallBack {
    private static final Logger logger = LoggerFactory.getLogger(PulsarSink.class);
    private static String TOPIC = "topic";
    private static int BAD_EVENT_QUEUE_SIZE = 10000;
    private static int BATCH_SIZE = 10000;
    private static final int DEFAULT_LOG_EVERY_N_EVENTS = 100000;
    private static String LOG_EVERY_N_EVENTS = "log_every_n_events";
    private static String DISK_IO_RATE_PER_SEC = "disk_io_rate_per_sec";
    private static final String SINK_THREAD_NUM = "thread_num";
    private Integer logEveryNEvents;
    private long diskIORatePerSec;
    private RateLimiter diskRateLimiter;
    private AtomicLong currentSuccessSendCnt = new AtomicLong(0L);
    private AtomicLong lastSuccessSendCnt = new AtomicLong(0L);
    private long t1 = System.currentTimeMillis();
    private long t2 = 0L;
    private static AtomicLong totalPulsarSuccSendCnt = new AtomicLong(0L);
    private static AtomicLong totalPulsarSuccSendSize = new AtomicLong(0L);
    private boolean overflow = false;
    private LinkedBlockingQueue<EventStat> resendQueue;
    private long logCounter = 0L;
    private final AtomicLong currentInFlightCount = new AtomicLong(0L);
    private volatile boolean canSend = false;
    private volatile boolean canTake = false;
    private static int EVENT_QUEUE_SIZE = 1000;
    private int threadNum;
    private Thread[] sinkThreadPool;
    private LinkedBlockingQueue<Event> eventQueue;
    private SinkCounter sinkCounter;
    private PulsarClientService pulsarClientService;
    private static final Long PRINT_INTERVAL = 30L;
    private static final PulsarPerformanceTask pulsarPerformanceTask = new PulsarPerformanceTask();
    private static ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new HighPriorityThreadFactory("pulsarPerformance-Printer-thread"));
    private String topic;
    private Context context;

    public PulsarSink() {
        logger.debug("new instance of PulsarSink!");
    }

    public void configure(Context context) {
        logger.info("PulsarSink started and context = {}", (Object)context.toString());
        this.context = context;
        this.topic = context.getString(TOPIC);
        this.logEveryNEvents = context.getInteger(LOG_EVERY_N_EVENTS, Integer.valueOf(100000));
        logger.debug(this.getName() + " " + LOG_EVERY_N_EVENTS + " " + this.logEveryNEvents);
        Preconditions.checkArgument((this.logEveryNEvents > 0 ? 1 : 0) != 0, (Object)"logEveryNEvents must be > 0");
        this.resendQueue = new LinkedBlockingQueue(BAD_EVENT_QUEUE_SIZE);
        String sinkThreadNum = context.getString(SINK_THREAD_NUM, "4");
        this.threadNum = Integer.parseInt(sinkThreadNum);
        Preconditions.checkArgument((this.threadNum > 0 ? 1 : 0) != 0, (Object)"threadNum must be > 0");
        this.sinkThreadPool = new Thread[this.threadNum];
        this.eventQueue = new LinkedBlockingQueue(EVENT_QUEUE_SIZE);
        this.diskIORatePerSec = context.getLong(DISK_IO_RATE_PER_SEC, Long.valueOf(0L));
        if (this.diskIORatePerSec != 0L) {
            this.diskRateLimiter = RateLimiter.create((double)this.diskIORatePerSec);
        }
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
    }

    private void initTopic() throws Exception {
        long startTime = System.currentTimeMillis();
        if (this.topic != null) {
            this.pulsarClientService.initTopicProducer(this.topic);
        }
        logger.info(this.getName() + " initTopic cost: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    public void start() {
        logger.info("pulsar sink starting");
        this.sinkCounter.start();
        this.pulsarClientService = new PulsarClientService(this.context);
        this.pulsarClientService.initCreateConnection(this);
        super.start();
        this.canSend = true;
        this.canTake = true;
        try {
            this.initTopic();
        }
        catch (Exception e) {
            logger.info("meta sink start publish topic fail.", (Throwable)e);
        }
        for (int i = 0; i < this.sinkThreadPool.length; ++i) {
            this.sinkThreadPool[i] = new Thread((Runnable)new SinkTask(), this.getName() + "_pulsar_sink_sender-" + i);
            this.sinkThreadPool[i].start();
        }
        logger.debug("meta sink started");
    }

    public void stop() {
        logger.info("pulsar sink stopping");
        this.pulsarClientService.close();
        this.canTake = false;
        int waitCount = 0;
        while (this.eventQueue.size() != 0 && waitCount++ < 10) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.info("Stop thread has been interrupt!");
                break;
            }
        }
        this.canSend = false;
        if (this.sinkThreadPool != null) {
            for (Thread thread : this.sinkThreadPool) {
                if (thread == null) continue;
                thread.interrupt();
            }
            this.sinkThreadPool = null;
        }
        super.stop();
        if (!scheduledExecutorService.isShutdown()) {
            scheduledExecutorService.shutdown();
        }
        this.sinkCounter.stop();
        logger.debug("pulsar sink stopped. Metrics:{}", (Object)this.sinkCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink.Status process() throws EventDeliveryException {
        if (!this.canTake) {
            return Sink.Status.BACKOFF;
        }
        Sink.Status status = Sink.Status.READY;
        Channel channel = this.getChannel();
        tx.begin();
        try (Transaction tx = channel.getTransaction();){
            Event event = channel.take();
            if (event != null) {
                if (this.diskRateLimiter != null) {
                    this.diskRateLimiter.acquire(event.getBody().length);
                }
                if (!this.eventQueue.offer(event, 3000L, TimeUnit.MILLISECONDS)) {
                    logger.info("[{}] Channel --> Queue(has no enough space,current code point) --> pulsar,Check if pulsar server or network is ok.(if this situation last long time it will cause memoryChannel full and fileChannel write.)", (Object)this.getName());
                    tx.rollback();
                } else {
                    tx.commit();
                }
            } else {
                status = Sink.Status.BACKOFF;
                tx.commit();
            }
        }
        return status;
    }

    @Override
    public void handleCreateClientSuccess(String url) {
        logger.info("createConnection success for url = {}", (Object)url);
        this.sinkCounter.incrementConnectionCreatedCount();
    }

    @Override
    public void handleCreateClientException(String url) {
        logger.error("createConnection has exception for url = {}", (Object)url);
        this.sinkCounter.incrementConnectionFailedCount();
    }

    @Override
    public void handleMessageSendSuccess(Object result, EventStat eventStat) {
        totalPulsarSuccSendCnt.incrementAndGet();
        totalPulsarSuccSendSize.addAndGet(eventStat.getEvent().getBody().length);
        this.sinkCounter.incrementEventDrainSuccessCount();
        this.currentInFlightCount.decrementAndGet();
        this.currentSuccessSendCnt.incrementAndGet();
        long nowCnt = this.currentSuccessSendCnt.get();
        long oldCnt = this.lastSuccessSendCnt.get();
        if (nowCnt % (long)this.logEveryNEvents.intValue() == 0L && nowCnt != this.lastSuccessSendCnt.get()) {
            this.lastSuccessSendCnt.set(nowCnt);
            this.t2 = System.currentTimeMillis();
            logger.info("metasink {}, succ put {} events to pulsar, in the past {} millsec", new Object[]{this.getName(), nowCnt - oldCnt, this.t2 - this.t1});
            this.t1 = this.t2;
        }
    }

    @Override
    public void handleMessageSendException(EventStat eventStat, Object e) {
        if (e instanceof TooLongFrameException) {
            this.overflow = true;
        } else if (e instanceof PulsarClientException.ProducerQueueIsFullError) {
            this.overflow = true;
        } else if (!(e instanceof PulsarClientException.AlreadyClosedException || e instanceof PulsarClientException.NotConnectedException || e instanceof PulsarClientException.TopicTerminatedException)) {
            logger.error("handle message send exception ,msg will resend later, e = {}", e);
        }
        eventStat.incRetryCnt();
        this.resendEvent(eventStat, true);
    }

    private void resendEvent(EventStat es, boolean isDecrement) {
        try {
            if (isDecrement) {
                this.currentInFlightCount.decrementAndGet();
            }
            if (es == null || es.getEvent() == null) {
                return;
            }
            if (!this.resendQueue.offer(es)) {
                FailoverChannelProcessorHolder.getChannelProcessor().processEvent(es.getEvent());
            }
        }
        catch (Throwable throwable) {
            logger.error("resendEvent e = {}", throwable);
        }
    }

    static {
        logger.info("init pulsarPerformanceTask");
        scheduledExecutorService.scheduleWithFixedDelay(pulsarPerformanceTask, 0L, PRINT_INTERVAL, TimeUnit.SECONDS);
    }

    class SinkTask
    implements Runnable {
        SinkTask() {
        }

        @Override
        public void run() {
            logger.info("Sink task {} started.", (Object)Thread.currentThread().getName());
            while (PulsarSink.this.canSend) {
                boolean decrementFlag = false;
                Event event = null;
                EventStat eventStat = null;
                try {
                    if (PulsarSink.this.overflow) {
                        PulsarSink.this.overflow = false;
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    if (!PulsarSink.this.resendQueue.isEmpty()) {
                        eventStat = (EventStat)PulsarSink.this.resendQueue.poll();
                        if (eventStat != null) {
                            event = eventStat.getEvent();
                        }
                    } else {
                        if (PulsarSink.this.currentInFlightCount.get() > (long)BATCH_SIZE) {
                            PulsarSink.this.logCounter++;
                            if (PulsarSink.this.logCounter == 1L || PulsarSink.this.logCounter % 100000L == 0L) {
                                logger.info(PulsarSink.this.getName() + " currentInFlightCount={} resendQueue.size={}", (Object)PulsarSink.this.currentInFlightCount.get(), (Object)PulsarSink.this.resendQueue.size());
                            }
                            if (PulsarSink.this.logCounter > 0x7FFFFFFFFFFFFFF5L) {
                                PulsarSink.this.logCounter = 0L;
                            }
                        }
                        event = (Event)PulsarSink.this.eventQueue.take();
                        eventStat = new EventStat(event);
                        PulsarSink.this.sinkCounter.incrementEventDrainAttemptCount();
                    }
                    logger.debug("Event is {}, topic = {} ", (Object)event, (Object)PulsarSink.this.topic);
                    if (event == null) continue;
                    if (PulsarSink.this.topic == null || PulsarSink.this.topic.equals("")) {
                        logger.warn("no topic specified in event header, just skip this event");
                        continue;
                    }
                    EventStat es = eventStat;
                    boolean sendResult = PulsarSink.this.pulsarClientService.sendMessage(PulsarSink.this.topic, event, PulsarSink.this, es);
                    if (!sendResult) continue;
                    PulsarSink.this.currentInFlightCount.incrementAndGet();
                    decrementFlag = true;
                }
                catch (InterruptedException e) {
                    logger.info("Thread {} has been interrupted!", (Object)Thread.currentThread().getName());
                    return;
                }
                catch (Throwable t) {
                    if (t instanceof PulsarClientException) {
                        String message = t.getMessage();
                        if (message != null && (message.contains("No available queue for topic") || message.contains("The brokers of topic are all forbidden"))) {
                            logger.info("IllegalTopicMap.put " + PulsarSink.this.topic);
                            continue;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    PulsarSink.this.resendEvent(eventStat, decrementFlag);
                }
            }
        }
    }

    static class PulsarPerformanceTask
    implements Runnable {
        PulsarPerformanceTask() {
        }

        @Override
        public void run() {
            try {
                if (totalPulsarSuccSendSize.get() != 0L) {
                    logger.info("Total pulsar performance tps :" + totalPulsarSuccSendCnt.get() / PRINT_INTERVAL + "/s, avg msg size:" + totalPulsarSuccSendSize.get() / totalPulsarSuccSendCnt.get() + ",print every " + PRINT_INTERVAL + " seconds");
                    totalPulsarSuccSendCnt.set(0L);
                    totalPulsarSuccSendSize.set(0L);
                }
            }
            catch (Exception e) {
                logger.info("pulsarPerformanceTask error", (Throwable)e);
            }
        }
    }
}

