/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.sink;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.apache.inlong.audit.base.HighPriorityThreadFactory;
import org.apache.inlong.audit.file.ConfigManager;
import org.apache.inlong.audit.sink.EventStat;
import org.apache.inlong.audit.utils.FailoverChannelProcessorHolder;
import org.apache.inlong.common.util.NetworkUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaSink.class);
    private static Properties properties = new Properties();
    private String kafkaServerUrl;
    private static final String BOOTSTRAP_SERVER = "bootstrap_servers";
    private static final String TOPIC = "topic";
    private static final String TOPIC_REPLICATIONS = "topic_replications";
    private static final String TOPIC_PARTITIONS = "topic_partitions";
    private static final String RETRIES = "retries";
    private static final String BATCH_SIZE = "batch_size";
    private static final String LINGER_MS = "linger_ms";
    private static final String BUFFER_MEMORY = "buffer_memory";
    private static final String defaultRetries = "0";
    private static final String defaultBatchSize = "16384";
    private static final String defaultLingerMs = "0";
    private static final String defaultBufferMemory = "33554432";
    private static final String defaultAcks = "all";
    private static final Long PRINT_INTERVAL = 30L;
    private static final KafkaPerformanceTask kafkaPerformanceTask = new KafkaPerformanceTask();
    private static ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new HighPriorityThreadFactory("kafkaPerformance-Printer-thread"));
    private KafkaProducer<String, byte[]> producer;
    public Map<String, KafkaProducer<String, byte[]>> producerMap;
    private SinkCounter sinkCounter;
    private String topic;
    private int topicReplications;
    private int topicPartitions;
    private static final int DEFAULT_TOPIC_REPLICATIONS = 2;
    private static final int DEFAULT_TOPIC_PARTITIONS = 3;
    private volatile boolean canSend = false;
    private volatile boolean canTake = false;
    private int threadNum;
    private Thread[] sinkThreadPool;
    private static final int BAD_EVENT_QUEUE_SIZE = 10000;
    private static final int EVENT_QUEUE_SIZE = 1000;
    private static final int DEFAULT_LOG_EVERY_N_EVENTS = 100000;
    private LinkedBlockingQueue<EventStat> resendQueue;
    private LinkedBlockingQueue<Event> eventQueue;
    private Integer logEveryNEvents;
    private long diskIORatePerSec;
    private RateLimiter diskRateLimiter;
    private static final String LOG_EVERY_N_EVENTS = "log_every_n_events";
    private static final String DISK_IO_RATE_PER_SEC = "disk_io_rate_per_sec";
    private static final String SINK_THREAD_NUM = "thread-num";
    private AtomicLong currentSuccessSendCnt = new AtomicLong(0L);
    private AtomicLong lastSuccessSendCnt = new AtomicLong(0L);
    private long t1 = System.currentTimeMillis();
    private long t2 = 0L;
    private static AtomicLong totalKafkaSuccSendCnt = new AtomicLong(0L);
    private static AtomicLong totalKafkaSuccSendSize = new AtomicLong(0L);
    private boolean overflow = false;
    private String localIp = "127.0.0.1";

    public KafkaSink() {
        logger.debug("new instance of KafkaSink!");
    }

    public synchronized void start() {
        logger.info("kafka sink starting");
        this.sinkCounter.start();
        super.start();
        this.canSend = true;
        this.canTake = true;
        this.initTopicProducer(this.topic);
        for (int i = 0; i < this.sinkThreadPool.length; ++i) {
            this.sinkThreadPool[i] = new Thread((Runnable)new SinkTask(), this.getName() + "_tube_sink_sender-" + i);
            this.sinkThreadPool[i].start();
        }
        logger.debug("kafka sink started");
    }

    public synchronized void stop() {
        logger.info("kafka sink stopping");
        this.canTake = false;
        int waitCount = 0;
        while (this.eventQueue.size() != 0 && waitCount++ < 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.info("Stop thread has been interrupt!");
                break;
            }
        }
        this.canSend = false;
        if (this.sinkThreadPool != null) {
            for (Thread thread : this.sinkThreadPool) {
                if (thread == null) continue;
                thread.interrupt();
            }
            this.sinkThreadPool = null;
        }
        super.stop();
        if (!scheduledExecutorService.isShutdown()) {
            scheduledExecutorService.shutdown();
        }
        this.sinkCounter.stop();
        logger.debug("kafka sink stopped. Metrics:{}", (Object)this.sinkCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink.Status process() {
        logger.info("kafka sink processing");
        if (!this.canTake) {
            return Sink.Status.BACKOFF;
        }
        Sink.Status status = Sink.Status.READY;
        Channel channel = this.getChannel();
        tx.begin();
        try (Transaction tx = channel.getTransaction();){
            Event event = channel.take();
            if (event != null) {
                if (this.diskRateLimiter != null) {
                    this.diskRateLimiter.acquire(event.getBody().length);
                }
                if (!this.eventQueue.offer(event, 3000L, TimeUnit.MILLISECONDS)) {
                    logger.info("[{}] Channel --> Queue(not enough space, current code point) --> Kafka, check if Kafka server or network is ok. (If this situation last long time it will cause memoryChannel full and fileChannel write.)", (Object)this.getName());
                    tx.rollback();
                } else {
                    tx.commit();
                }
            } else {
                status = Sink.Status.BACKOFF;
                tx.commit();
            }
        }
        return status;
    }

    public void configure(Context context) {
        logger.info("KafkaSink started and context = {}", (Object)context.toString());
        this.topic = context.getString(TOPIC);
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)this.topic), (Object)"No topic specified");
        this.topicPartitions = context.getInteger(TOPIC_PARTITIONS, Integer.valueOf(3));
        this.topicReplications = context.getInteger(TOPIC_REPLICATIONS, Integer.valueOf(2));
        this.producerMap = new HashMap<String, KafkaProducer<String, byte[]>>();
        this.logEveryNEvents = context.getInteger(LOG_EVERY_N_EVENTS, Integer.valueOf(100000));
        logger.debug(this.getName() + " " + LOG_EVERY_N_EVENTS + " " + this.logEveryNEvents);
        Preconditions.checkArgument((this.logEveryNEvents > 0 ? 1 : 0) != 0, (Object)"logEveryNEvents must be > 0");
        this.resendQueue = new LinkedBlockingQueue(10000);
        String sinkThreadNum = context.getString(SINK_THREAD_NUM, "4");
        this.threadNum = Integer.parseInt(sinkThreadNum);
        Preconditions.checkArgument((this.threadNum > 0 ? 1 : 0) != 0, (Object)"threadNum must be > 0");
        this.sinkThreadPool = new Thread[this.threadNum];
        this.eventQueue = new LinkedBlockingQueue(1000);
        this.diskIORatePerSec = context.getLong(DISK_IO_RATE_PER_SEC, Long.valueOf(0L));
        if (this.diskIORatePerSec != 0L) {
            this.diskRateLimiter = RateLimiter.create((double)this.diskIORatePerSec);
        }
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
        this.localIp = NetworkUtils.getLocalIp();
        properties = new Properties();
        properties.put("acks", defaultAcks);
        properties.put(RETRIES, context.getString(RETRIES, "0"));
        properties.put("batch.size", context.getString(BATCH_SIZE, defaultBatchSize));
        properties.put("linger.ms", context.getString(LINGER_MS, "0"));
        properties.put("buffer.memory", context.getString(BUFFER_MEMORY, defaultBufferMemory));
    }

    private void initTopicProducer(String topic) {
        ConfigManager configManager = ConfigManager.getInstance();
        List mqInfoList = configManager.getMqInfoList();
        mqInfoList.forEach(mqClusterInfo -> {
            if ("KAFKA".equals(mqClusterInfo.getMqType())) {
                this.kafkaServerUrl = mqClusterInfo.getUrl();
            }
        });
        properties.put("bootstrap.servers", this.kafkaServerUrl);
        if (StringUtils.isEmpty((CharSequence)topic)) {
            logger.error("topic is empty");
        }
        this.createTopic();
        if (this.producer == null) {
            this.producer = new KafkaProducer(properties, (Serializer)new StringSerializer(), (Serializer)new ByteArraySerializer());
        }
        this.producerMap.put(topic, this.producer);
        logger.info(this.getName() + " success create producer");
    }

    private void createTopic() {
        try (AdminClient adminClient = AdminClient.create((Properties)properties);){
            ListTopicsResult topicList = adminClient.listTopics();
            KafkaFuture kafkaFuture = topicList.names();
            Set topicSet = (Set)kafkaFuture.get();
            if (topicSet.contains(this.topic)) {
                logger.info("The audit topic:{} already exists.", (Object)this.topic);
                return;
            }
            DescribeClusterResult describeClusterResult = adminClient.describeCluster();
            Collection nodes = (Collection)describeClusterResult.nodes().get();
            if (nodes.isEmpty()) {
                throw new IllegalArgumentException("kafka server not find");
            }
            int partition = Math.min(this.topicPartitions, nodes.size());
            int factor = Math.min(this.topicReplications, nodes.size());
            NewTopic needCreateTopic = new NewTopic(this.topic, partition, (short)factor);
            CreateTopicsResult createTopicsResult = adminClient.createTopics(Collections.singletonList(needCreateTopic));
            createTopicsResult.all().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(String.format("create audit topic:{} error with config:%s", properties));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KafkaProducer<String, byte[]> getProducer(String topic) {
        if (!this.producerMap.containsKey(topic)) {
            KafkaSink kafkaSink = this;
            synchronized (kafkaSink) {
                if (!this.producerMap.containsKey(topic)) {
                    if (this.producer == null) {
                        this.producer = new KafkaProducer(properties);
                    }
                    this.producerMap.put(topic, this.producer);
                }
            }
        }
        return this.producerMap.get(topic);
    }

    public void handleMessageSendSuccess(EventStat es) {
        totalKafkaSuccSendCnt.incrementAndGet();
        totalKafkaSuccSendSize.addAndGet(es.getEvent().getBody().length);
        this.sinkCounter.incrementEventDrainSuccessCount();
        this.currentSuccessSendCnt.incrementAndGet();
        long nowCnt = this.currentSuccessSendCnt.get();
        long oldCnt = this.lastSuccessSendCnt.get();
        if (nowCnt % (long)this.logEveryNEvents.intValue() == 0L && nowCnt != this.lastSuccessSendCnt.get()) {
            this.lastSuccessSendCnt.set(nowCnt);
            this.t2 = System.currentTimeMillis();
            logger.info("KafkaSink {}, succ put {} events to kafka, in the past {} millisecond", new Object[]{this.getName(), nowCnt - oldCnt, this.t2 - this.t1});
            this.t1 = this.t2;
        }
    }

    private void resendEvent(EventStat es, boolean isDecrement) {
        try {
            if (es == null || es.getEvent() == null) {
                return;
            }
            if (!this.resendQueue.offer(es)) {
                FailoverChannelProcessorHolder.getChannelProcessor().processEvent(es.getEvent());
            }
        }
        catch (Throwable throwable) {
            logger.error("resendEvent e = {}", throwable);
        }
    }

    static {
        logger.info("init kafkaPerformanceTask");
        scheduledExecutorService.scheduleWithFixedDelay(kafkaPerformanceTask, 0L, PRINT_INTERVAL, TimeUnit.SECONDS);
    }

    class SinkTask
    implements Runnable {
        SinkTask() {
        }

        @Override
        public void run() {
            logger.info("Sink task {} started.", (Object)Thread.currentThread().getName());
            while (KafkaSink.this.canSend) {
                boolean decrementFlag = false;
                Event event = null;
                EventStat eventStat = null;
                try {
                    if (KafkaSink.this.overflow) {
                        KafkaSink.this.overflow = false;
                        Thread.sleep(10L);
                    }
                    if (!KafkaSink.this.resendQueue.isEmpty()) {
                        eventStat = (EventStat)KafkaSink.this.resendQueue.poll();
                        if (eventStat != null) {
                            event = eventStat.getEvent();
                        }
                    } else {
                        event = (Event)KafkaSink.this.eventQueue.take();
                        eventStat = new EventStat(event);
                        KafkaSink.this.sinkCounter.incrementEventDrainAttemptCount();
                    }
                    if (event == null || StringUtils.isBlank((CharSequence)KafkaSink.this.topic)) {
                        logger.warn("event is null or no topic specified in event header, just skip");
                        continue;
                    }
                    EventStat es = eventStat;
                    boolean sendResult = this.sendMessage(event, KafkaSink.this.topic, es);
                    if (!sendResult) continue;
                    decrementFlag = true;
                }
                catch (InterruptedException e) {
                    logger.info("Thread {} has been interrupted!", (Object)Thread.currentThread().getName());
                    return;
                }
                catch (Throwable t) {
                    if (t instanceof PulsarClientException) {
                        String message = t.getMessage();
                        if (message != null && (message.contains("No available queue for topic") || message.contains("The brokers of topic are all forbidden"))) {
                            logger.info("IllegalTopicMap.put " + KafkaSink.this.topic);
                            continue;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    KafkaSink.this.resendEvent(eventStat, decrementFlag);
                }
            }
        }

        private boolean sendMessage(Event event, String topic, EventStat es) {
            KafkaProducer producer = KafkaSink.this.getProducer(topic);
            if (producer == null) {
                logger.error("Get producer is null, topic:{}", (Object)topic);
                return false;
            }
            logger.debug("producer start to send msg...");
            ProducerRecord record = new ProducerRecord(topic, (Object)event.getBody());
            producer.send(record, (recordMetadata, e) -> {
                if (e == null) {
                    KafkaSink.this.handleMessageSendSuccess(es);
                    return;
                }
                logger.warn("Send message failed, error message: {}, resendQueue size: {}, event:{}", new Object[]{e.getMessage(), KafkaSink.this.resendQueue.size(), es.getEvent().hashCode()});
                es.incRetryCnt();
                KafkaSink.this.resendEvent(es, true);
            });
            return true;
        }
    }

    static class KafkaPerformanceTask
    implements Runnable {
        KafkaPerformanceTask() {
        }

        @Override
        public void run() {
            try {
                if (totalKafkaSuccSendSize.get() != 0L) {
                    logger.info("Total kafka performance tps: " + totalKafkaSuccSendCnt.get() / PRINT_INTERVAL + "/s, avg msg size: " + totalKafkaSuccSendSize.get() / totalKafkaSuccSendCnt.get() + ", print every " + PRINT_INTERVAL + " seconds");
                    totalKafkaSuccSendSize.set(0L);
                    totalKafkaSuccSendCnt.set(0L);
                }
            }
            catch (Exception e) {
                logger.info("tubePerformanceTask error", (Throwable)e);
            }
        }
    }
}

