/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils.file;

import hirondelle.date4j.DateTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.agent.plugin.utils.file.MatchPoint;
import org.apache.inlong.agent.plugin.utils.file.NonRegexPatternPosition;
import org.apache.inlong.agent.plugin.utils.file.PathDateExpression;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewDateUtils {
    public static final String FULL_FORMAT = "yyyyMMddHHmmss";
    public static final String NULL_DATA_TIME = "000000000000";
    public static final String DEFAULT_FORMAT = "yyyyMMddHHmm";
    public static final String DEFAULT_TIME_ZONE = "Asia/Shanghai";
    private static final Logger logger = LoggerFactory.getLogger(NewDateUtils.class);
    private static final String TIME_REGEX = "YYYY(?:.MM|MM)?(?:.DD|DD)?(?:.hh|hh)?(?:.mm|mm)?(?:.ss|ss)?";
    private static final String LIMIT_SEP = "(?<=[a-zA-Z])";
    private static final String LETTER_STR = "\\D+";
    private static final String DIGIT_STR = "[0-9]+";
    private static final Pattern pattern = Pattern.compile("YYYY(?:.MM|MM)?(?:.DD|DD)?(?:.hh|hh)?(?:.mm|mm)?(?:.ss|ss)?", 42);
    private static final Pattern bracePatt = Pattern.compile("\\{(.*?)\\}");
    private static final int DEFAULT_LENGTH = "yyyyMMddHHmm".length();
    public static long DAY_TIMEOUT_INTERVAL = 172800000L;
    public static long HOUR_TIMEOUT_INTERVAL = 0x6DDD00L;
    public static final String DATA_SOURCE_CONFIG_ERROR = "ERROR-0-INLONG_AGENT|10001|ERROR|ERROR_DATA_SOURCE_CONFIG|";

    public static String getShouldStartTime(String dataTime, String cycleUnit, String offset) {
        if (dataTime == null || dataTime.length() > 12) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_FORMAT);
        TimeZone timeZone = TimeZone.getTimeZone(DEFAULT_TIME_ZONE);
        dateFormat.setTimeZone(timeZone);
        if (dataTime.length() < DEFAULT_LENGTH) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < DEFAULT_LENGTH - dataTime.length(); ++i) {
                sb.append("0");
            }
            dataTime = dataTime + sb.toString();
        }
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTimeInMillis(dateFormat.parse(dataTime).getTime());
        }
        catch (ParseException e) {
            return null;
        }
        offset = offset.startsWith("-") ? offset.substring(1, offset.length()) : "-" + offset;
        return dateFormat.format(new Date(NewDateUtils.getDateTime(calendar, cycleUnit, offset).getTimeInMillis()));
    }

    private static Calendar getCurDate(String cycleUnit, String offset) {
        if (cycleUnit == null || cycleUnit.length() == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return NewDateUtils.getDateTime(calendar, cycleUnit, offset);
    }

    public static String getDateTime(String dataTime, String cycleUnit, String offset) {
        String retTime = DateTransUtils.millSecConvertToTimeStr((long)System.currentTimeMillis(), (String)cycleUnit);
        try {
            long time = DateTransUtils.timeStrConvertToMillSec((String)dataTime, (String)cycleUnit);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(time);
            Calendar retCalendar = NewDateUtils.getDateTime(calendar, cycleUnit, offset);
            if (retCalendar == null) {
                return dataTime;
            }
            retTime = DateTransUtils.millSecConvertToTimeStr((long)retCalendar.getTime().getTime(), (String)cycleUnit);
        }
        catch (Exception e) {
            logger.error("getDateTime error: ", (Throwable)e);
        }
        return retTime;
    }

    public static String getDateTime(long time, String cycleUnit, String offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Calendar retCalendar = NewDateUtils.getDateTime(calendar, cycleUnit, offset);
        return DateTransUtils.millSecConvertToTimeStr((long)retCalendar.getTime().getTime(), (String)cycleUnit);
    }

    private static Calendar getDateTime(Calendar calendar, String cycleUnit, String offset) {
        int cycleNumber = cycleUnit.length() <= 1 ? 1 : Integer.parseInt(cycleUnit.substring(0, cycleUnit.length() - 1));
        String offsetUnit = offset.substring(offset.length() - 1, offset.length());
        int offsetNumber = Integer.parseInt(offset.substring(0, offset.length() - 1));
        if (cycleUnit.length() > 1 && StringUtils.endsWithIgnoreCase((String)cycleUnit, (String)"M")) {
            calendar.set(13, 0);
            int minTime = calendar.get(12);
            int leftMin = minTime % cycleNumber;
            calendar.set(12, minTime -= leftMin);
            if ("D".equalsIgnoreCase(offsetUnit)) {
                calendar.add(6, offsetNumber);
            }
            if ("H".equalsIgnoreCase(offsetUnit)) {
                calendar.add(11, offsetNumber);
            }
        } else if (cycleUnit.length() == 1) {
            if ("D".equalsIgnoreCase(cycleUnit)) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
            } else if ("h".equalsIgnoreCase(cycleUnit)) {
                calendar.set(12, 0);
                calendar.set(13, 0);
            }
        }
        if ("D".equalsIgnoreCase(offsetUnit)) {
            calendar.add(6, offsetNumber);
        }
        if ("h".equalsIgnoreCase(offsetUnit)) {
            calendar.add(11, offsetNumber);
        }
        if ("m".equals(offsetUnit)) {
            calendar.add(12, offsetNumber);
        }
        return calendar;
    }

    public static boolean isValidCreationTime(String dataTime, String cycleUnit, String timeOffset) {
        long timeInterval = 0L;
        if ("Y".equalsIgnoreCase(cycleUnit)) {
            timeInterval = DAY_TIMEOUT_INTERVAL;
        } else if ("M".equals(cycleUnit)) {
            timeInterval = HOUR_TIMEOUT_INTERVAL;
        } else if ("D".equalsIgnoreCase(cycleUnit)) {
            timeInterval = DAY_TIMEOUT_INTERVAL;
        } else if ("h".equalsIgnoreCase(cycleUnit)) {
            timeInterval = HOUR_TIMEOUT_INTERVAL;
        } else if (cycleUnit.contains("m")) {
            timeInterval = HOUR_TIMEOUT_INTERVAL;
        } else {
            logger.error("cycleUnit {} can't parse!", (Object)cycleUnit);
            timeInterval = DAY_TIMEOUT_INTERVAL;
        }
        timeInterval = timeOffset.startsWith("-") ? (timeInterval -= DateTransUtils.calcOffset((String)timeOffset)) : (timeInterval += DateTransUtils.calcOffset((String)timeOffset));
        return NewDateUtils.isValidCreationTime(dataTime, timeInterval);
    }

    public static boolean isValidCreationTime(String dataTime, long timeInterval) {
        long currentTime = System.currentTimeMillis();
        long minTime = currentTime - timeInterval;
        long maxTime = currentTime + timeInterval;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_FORMAT);
        if (dataTime.length() < DEFAULT_LENGTH) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < DEFAULT_LENGTH - dataTime.length(); ++i) {
                sb.append("0");
            }
            dataTime = dataTime + sb.toString();
        }
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTimeInMillis(dateFormat.parse(dataTime).getTime());
        }
        catch (ParseException e) {
            return false;
        }
        return calendar.getTimeInMillis() >= minTime && calendar.getTimeInMillis() <= maxTime;
    }

    public static boolean isBraceContain(String dataName) {
        Matcher matcher = bracePatt.matcher(dataName);
        return matcher.find();
    }

    public static String getDateTime(String fileName, String dataName, PathDateExpression dateExpression) {
        String dataTime = null;
        if (NewDateUtils.isBraceContain(dataName)) {
            String fullRegx = NewDateUtils.replaceDateExpressionWithRegex(dataName, "dataTime");
            Pattern fullPatt = Pattern.compile(fullRegx);
            Matcher matcher = fullPatt.matcher(fileName);
            if (matcher.find()) {
                dataTime = matcher.group("dataTime");
            }
        } else {
            dataTime = NewDateUtils.getDateTime(fileName, dateExpression);
        }
        return dataTime;
    }

    public static String getDateTime(String fileName, PathDateExpression dateExpression) {
        if (fileName == null || dateExpression == null || dateExpression.getLongestDatePattern() == null) {
            return null;
        }
        String longestDatePattern = NewDateUtils.replaceDateExpressionWithRegex(dateExpression.getLongestDatePattern());
        NonRegexPatternPosition patternPosition = dateExpression.getPatternPosition();
        Matcher mat = Pattern.compile(longestDatePattern).matcher(fileName);
        boolean find = mat.find();
        if (!find) {
            logger.error("Can't find the pattern {} for file name {}", (Object)longestDatePattern, (Object)fileName);
            return null;
        }
        String dateTime = fileName.substring(mat.start(), mat.end());
        if (patternPosition == NonRegexPatternPosition.PREFIX) {
            dateTime = dateTime.substring(1, dateTime.length());
        } else if (patternPosition == NonRegexPatternPosition.SUFFIX) {
            dateTime = dateTime.substring(0, dateTime.length() - 1);
        } else if (patternPosition == NonRegexPatternPosition.BOTH) {
            dateTime = dateTime.substring(1, dateTime.length() - 1);
        } else if (patternPosition == NonRegexPatternPosition.END) {
            dateTime = dateTime.substring(0, dateTime.length());
        } else if (patternPosition == NonRegexPatternPosition.ENDSUFFIX) {
            dateTime = dateTime.substring(1, dateTime.length());
        } else if (patternPosition == NonRegexPatternPosition.NONE) {
            logger.error("The data path configuration is invalid");
            dateTime = null;
        }
        return dateTime;
    }

    public static ArrayList<MatchPoint> extractAllTimeRegex(String src) {
        Matcher m = pattern.matcher(src);
        ArrayList<MatchPoint> arr = new ArrayList<MatchPoint>();
        while (m.find()) {
            String oneMatch = m.group(0);
            arr.add(new MatchPoint(oneMatch, m.start(), m.end()));
        }
        return arr;
    }

    public static String replaceDateExpressionWithRegex(String dataPath) {
        if (dataPath == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<MatchPoint> mp = NewDateUtils.extractAllTimeRegex(dataPath);
        if (mp == null || mp.size() == 0) {
            return dataPath;
        }
        int lastIndex = 0;
        for (MatchPoint m : mp) {
            sb.append(dataPath.substring(lastIndex, m.getStart()));
            String longestPattern = m.getStr();
            int hhIndex = longestPattern.indexOf("hh");
            int mmIndex = longestPattern.indexOf("mm");
            longestPattern = longestPattern.replace("YYYY", "\\d{4}");
            longestPattern = longestPattern.replace("MM", "\\d{2}");
            longestPattern = longestPattern.replace("DD", "\\d{2}");
            longestPattern = longestPattern.replace("hh", "\\d{2}");
            if (hhIndex != -1 && mmIndex != -1 && mmIndex >= hhIndex + 2 && mmIndex < hhIndex + 4) {
                longestPattern = longestPattern.replace("mm", "\\d{2}");
            }
            sb.append(longestPattern);
            lastIndex = m.getEnd();
        }
        sb.append(dataPath.substring(lastIndex));
        return sb.toString();
    }

    public static String replaceDateExpressionWithRegex(String dataPath, String dateTimeGroupName) {
        AbstractStringBuilder sb;
        if (dataPath == null) {
            return null;
        }
        if (NewDateUtils.isBraceContain(dataPath)) {
            sb = new StringBuilder();
            ((StringBuilder)sb).append(dataPath.substring(0, dataPath.indexOf(123)));
            ((StringBuilder)sb).append("(?<").append(dateTimeGroupName).append('>');
            ((StringBuilder)sb).append(dataPath.substring(dataPath.indexOf(123) + 1, dataPath.indexOf(125)));
            ((StringBuilder)sb).append(')').append(dataPath.substring(dataPath.indexOf(125) + 1));
            dataPath = ((StringBuilder)sb).toString();
        }
        sb = new StringBuffer();
        ArrayList<MatchPoint> mp = NewDateUtils.extractAllTimeRegex(dataPath);
        if (mp == null || mp.size() == 0) {
            return dataPath;
        }
        int lastIndex = 0;
        for (int i = 0; i < mp.size(); ++i) {
            MatchPoint m = mp.get(i);
            ((StringBuffer)sb).append(dataPath.substring(lastIndex, m.getStart()));
            String longestPattern = m.getStr();
            int hhIndex = longestPattern.indexOf("hh");
            int mmIndex = longestPattern.indexOf("mm");
            longestPattern = longestPattern.replace("YYYY", "\\d{4}");
            longestPattern = longestPattern.replace("MM", "\\d{2}");
            longestPattern = longestPattern.replace("DD", "\\d{2}");
            longestPattern = longestPattern.replace("hh", "\\d{2}");
            if (hhIndex != -1 && mmIndex != -1 && mmIndex >= hhIndex + 2 && mmIndex < hhIndex + 4) {
                longestPattern = longestPattern.replace("mm", "\\d{2}");
            }
            ((StringBuffer)sb).append(longestPattern);
            lastIndex = m.getEnd();
        }
        ((StringBuffer)sb).append(dataPath.substring(lastIndex));
        return ((StringBuffer)sb).toString();
    }

    public static String replaceDateExpression(Calendar dateTime, String dataPath) {
        if (dataPath == null) {
            return null;
        }
        String year = String.valueOf(dateTime.get(1));
        String month = String.valueOf(dateTime.get(2) + 1);
        String day = String.valueOf(dateTime.get(5));
        String hour = String.valueOf(dateTime.get(11));
        String minute = String.valueOf(dateTime.get(12));
        StringBuffer sb = new StringBuffer();
        ArrayList<MatchPoint> mp = NewDateUtils.extractAllTimeRegex(dataPath);
        if (mp == null || mp.size() == 0) {
            return dataPath;
        }
        int lastIndex = 0;
        for (MatchPoint m : mp) {
            sb.append(dataPath.substring(lastIndex, m.getStart()));
            String longestPattern = m.getStr();
            int hhIndex = longestPattern.indexOf("hh");
            int mmIndex = longestPattern.indexOf("mm");
            longestPattern = longestPattern.replaceAll("YYYY", year);
            longestPattern = longestPattern.replaceAll("MM", NewDateUtils.externDate(month));
            longestPattern = longestPattern.replaceAll("DD", NewDateUtils.externDate(day));
            longestPattern = longestPattern.replaceAll("hh", NewDateUtils.externDate(hour));
            if (hhIndex != -1 && mmIndex != -1 && mmIndex >= hhIndex + 2 && mmIndex < hhIndex + 4) {
                longestPattern = longestPattern.replaceAll("mm", NewDateUtils.externDate(minute));
            }
            sb.append(longestPattern);
            lastIndex = m.getEnd();
        }
        sb.append(dataPath.substring(lastIndex));
        return sb.toString();
    }

    public static String replaceDateExpression1(Calendar dateTime, String logFileName) {
        if (dateTime == null || logFileName == null) {
            return null;
        }
        String year = String.valueOf(dateTime.get(1));
        String month = String.valueOf(dateTime.get(2) + 1);
        String day = String.valueOf(dateTime.get(5));
        String hour = String.valueOf(dateTime.get(11));
        String minute = String.valueOf(dateTime.get(12));
        int hhIndex = logFileName.indexOf("hh");
        int mmIndex = logFileName.indexOf("mm");
        logFileName = logFileName.replaceAll("YYYY", year);
        logFileName = logFileName.replaceAll("MM", NewDateUtils.externDate(month));
        logFileName = logFileName.replaceAll("DD", NewDateUtils.externDate(day));
        logFileName = logFileName.replaceAll("hh", NewDateUtils.externDate(hour));
        if (hhIndex != -1 && mmIndex != -1 && mmIndex >= hhIndex + 2 && mmIndex < hhIndex + 4) {
            logFileName = logFileName.replaceAll("mm", NewDateUtils.externDate(minute));
        }
        return logFileName;
    }

    private static String externDate(String time) {
        if (time.length() == 1) {
            return "0" + time;
        }
        return time;
    }

    public static String parseCycleUnit(String scheduleTime) {
        String cycleUnit = "D";
        StringTokenizer st = new StringTokenizer(scheduleTime, " ");
        if (st.countTokens() <= 0) {
            return "D";
        }
        int index = 0;
        while (st.hasMoreElements()) {
            String currentString = st.nextToken();
            if (currentString.contains("/")) {
                if (index == 1) {
                    cycleUnit = "10m";
                    break;
                }
                if (index != 2) break;
                cycleUnit = "h";
                break;
            }
            if (currentString.equals("*")) {
                if (index != 3) break;
                cycleUnit = "D";
                break;
            }
            ++index;
        }
        logger.info("ScheduleTime: " + scheduleTime + ", cycleUnit: " + cycleUnit);
        return cycleUnit;
    }

    public static List<Long> getDateRegion(long startTime, long endTime, String cycleUnit) {
        ArrayList<Long> ret = new ArrayList<Long>();
        DateTime dtStart = DateTime.forInstant((long)startTime, (TimeZone)TimeZone.getDefault());
        DateTime dtEnd = DateTime.forInstant((long)endTime, (TimeZone)TimeZone.getDefault());
        if (cycleUnit.equals("M")) {
            dtEnd = dtEnd.getEndOfMonth();
        } else if (cycleUnit.equals("D")) {
            dtEnd = dtEnd.getEndOfDay();
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (cycleUnit.equalsIgnoreCase("Y")) {
            year = 1;
        } else if (cycleUnit.equals("M")) {
            month = 1;
        } else if (cycleUnit.equalsIgnoreCase("D")) {
            day = 1;
        } else if (cycleUnit.equalsIgnoreCase("h")) {
            hour = 1;
        } else if (cycleUnit.equals("10m")) {
            minute = 10;
        } else if (cycleUnit.equals("15m")) {
            minute = 15;
        } else if (cycleUnit.equals("30m")) {
            minute = 30;
        } else if (cycleUnit.equalsIgnoreCase("s")) {
            second = 1;
        } else {
            logger.error("cycleUnit {} is error: ", (Object)cycleUnit);
            return ret;
        }
        while (dtStart.lteq(dtEnd)) {
            ret.add(dtStart.getMilliseconds(TimeZone.getDefault()));
            dtStart = dtStart.plus(Integer.valueOf(year), Integer.valueOf(month), Integer.valueOf(day), Integer.valueOf(hour), Integer.valueOf(minute), Integer.valueOf(second), Integer.valueOf(0), DateTime.DayOverflow.LastDay);
        }
        return ret;
    }
}

