/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.inlong.agent.utils.file.FileFinder;

public class Files {
    public static FileFinder find(String baseDirectory) {
        return Files.find(new File(baseDirectory));
    }

    public static FileFinder find(File baseDirectory) {
        return new FileFinder(baseDirectory);
    }

    public static long getFileCreationTime(String fileName) {
        long createTime = 0L;
        try {
            createTime = java.nio.file.Files.readAttributes(Paths.get(fileName, new String[0]), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return createTime;
    }

    public static long getFileLastModifyTime(String fileName) {
        long lastModify = 0L;
        try {
            lastModify = java.nio.file.Files.getLastModifiedTime(Paths.get(fileName, new String[0]), new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lastModify;
    }
}

