/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils.file;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class FilePathUtil {
    private static final String YEAR = "YYYY";
    private static final String MONTH = "MM";
    private static final String DAY = "DD";
    private static final String HOUR = "hh";

    public static ArrayList<String> cutDirectory(String directory) {
        String regixDirecotry;
        String baseDirectory;
        char c;
        File file = new File(directory);
        String fileName = file.getName();
        int fileNameIndex = directory.length() - fileName.length() - 1;
        String sign = "\\^$*+?{(|[.";
        String range = "+?*{";
        int regixDirecotryIndex = StringUtils.indexOfAny((String)directory, (String)sign);
        if (regixDirecotryIndex != -1 && directory.charAt(regixDirecotryIndex) == '.' && regixDirecotryIndex != directory.length() - 1 && StringUtils.indexOf((String)range, (char)(c = directory.charAt(regixDirecotryIndex + 1))) == -1) {
            regixDirecotryIndex = StringUtils.indexOfAny((String)directory, (String)sign.substring(0, sign.length() - 1));
        }
        if (regixDirecotryIndex < fileNameIndex) {
            int regixDirecotryBeginIndex = directory.lastIndexOf(47, regixDirecotryIndex);
            if (regixDirecotryBeginIndex == -1) {
                baseDirectory = directory.substring(0, fileNameIndex);
                regixDirecotry = "";
            } else {
                regixDirecotry = directory.substring(regixDirecotryBeginIndex + 1, fileNameIndex);
                baseDirectory = regixDirecotryBeginIndex == 0 ? "/" : directory.substring(0, regixDirecotryBeginIndex);
            }
        } else {
            baseDirectory = directory.substring(0, fileNameIndex);
            regixDirecotry = "";
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(baseDirectory);
        ret.add(regixDirecotry);
        ret.add(fileName);
        return ret;
    }

    public static ArrayList<String> getDirectoryLayers(String directory) {
        String regixDirectory;
        String baseDirectory;
        char c;
        File file = new File(directory);
        String fileName = file.getName();
        int fileNameIndex = directory.length() - fileName.length() - 1;
        String sign = "\\^$*+?{(|[.";
        String range = "+?*{";
        int regixDirecotryIndex = StringUtils.indexOfAny((String)directory, (String)sign);
        if (regixDirecotryIndex != -1 && directory.charAt(regixDirecotryIndex) == '.' && regixDirecotryIndex != directory.length() - 1 && StringUtils.indexOf((String)range, (char)(c = directory.charAt(regixDirecotryIndex + 1))) == -1) {
            regixDirecotryIndex = StringUtils.indexOfAny((String)directory, (String)sign.substring(0, sign.length() - 1));
        }
        if (regixDirecotryIndex < fileNameIndex) {
            int regixDirecotryBeginIndex = directory.lastIndexOf(47, regixDirecotryIndex);
            if (regixDirecotryBeginIndex == -1) {
                baseDirectory = directory.substring(0, fileNameIndex);
                regixDirectory = "";
            } else {
                regixDirectory = directory.substring(regixDirecotryBeginIndex + 1, fileNameIndex);
                baseDirectory = regixDirecotryBeginIndex == 0 ? "/" : directory.substring(0, regixDirecotryBeginIndex);
            }
        } else {
            baseDirectory = directory.substring(0, fileNameIndex);
            regixDirectory = "";
        }
        int[] indexes = new int[]{baseDirectory.contains(YEAR) ? baseDirectory.indexOf(YEAR) : Integer.MAX_VALUE, baseDirectory.contains(MONTH) ? baseDirectory.indexOf(MONTH) : Integer.MAX_VALUE, baseDirectory.contains(DAY) ? baseDirectory.indexOf(DAY) : Integer.MAX_VALUE, baseDirectory.contains(HOUR) ? baseDirectory.indexOf(HOUR) : Integer.MAX_VALUE};
        int minIndex = Integer.MAX_VALUE;
        for (int i = 0; i < indexes.length; ++i) {
            if (minIndex <= indexes[i]) continue;
            minIndex = indexes[i];
        }
        if (minIndex != Integer.MAX_VALUE) {
            int lastIndex = baseDirectory.lastIndexOf(47, minIndex);
            regixDirectory = regixDirectory.length() > 0 ? baseDirectory.substring(lastIndex + 1, baseDirectory.length()) + File.separator + regixDirectory : baseDirectory.substring(lastIndex + 1, baseDirectory.length());
            baseDirectory = baseDirectory.substring(0, lastIndex);
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(baseDirectory);
        ret.add(regixDirectory);
        ret.add(fileName);
        return ret;
    }

    public static boolean isSameDir(String fileName1, String fileName2) {
        ArrayList<String> ret1 = FilePathUtil.cutDirectory(fileName1);
        ArrayList<String> ret2 = FilePathUtil.cutDirectory(fileName2);
        return ret1.get(0).equals(ret2.get(0));
    }
}

