/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils.file;

import hirondelle.date4j.DateTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.agent.plugin.utils.file.NonRegexPatternPosition;
import org.apache.inlong.agent.plugin.utils.file.PathDateExpression;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateUtils {
    private static final Logger logger = LogManager.getLogger(DateUtils.class);
    private static final String TIME_REGEX = "YYYY(?:.MM|MM)?(?:.DD|DD)?(?:.hh|hh)?(?:.mm|mm)?(?:.ss|ss)?";
    private static final String LIMIT_SEP = "(?<=[a-zA-Z])";
    private static final String LETTER_STR = "\\D+";
    private static final String DIGIT_STR = "[0-9]+";
    private static final Pattern pattern = Pattern.compile("YYYY(?:.MM|MM)?(?:.DD|DD)?(?:.hh|hh)?(?:.mm|mm)?(?:.ss|ss)?", 42);
    private String dateFormat = "YYYYMMDDhhmmss";

    public DateUtils() {
    }

    public DateUtils(String timeFormat) {
        if (timeFormat != null && !timeFormat.isEmpty()) {
            this.dateFormat = timeFormat;
        }
    }

    public static String getSubTimeFormat(String format, int length) {
        int formatLen = format.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < formatLen && length > 0; ++i) {
            if (Character.isLetter(format.charAt(i)) || Character.isDigit(format.charAt(i))) {
                --length;
            }
            sb.append(format.charAt(i));
        }
        return sb.toString();
    }

    public static String extractLongestTimeRegex(String src) throws IllegalArgumentException {
        Matcher m = pattern.matcher(src);
        String ret = "";
        while (m.find()) {
            String oneMatch = m.group(0);
            if (oneMatch.length() <= ret.length()) continue;
            ret = oneMatch;
        }
        return ret;
    }

    public static PathDateExpression extractLongestTimeRegexWithPrefixOrSuffix(String src) throws IllegalArgumentException {
        char c;
        if (src == null) {
            return null;
        }
        String longestPattern = DateUtils.extractLongestTimeRegex(src);
        if (longestPattern.isEmpty()) {
            return new PathDateExpression(longestPattern, NonRegexPatternPosition.NONE);
        }
        String regexSign = "\\^$*+?{(|[)]";
        String range = "+?*{";
        int beginIndex = src.indexOf(longestPattern);
        int endIndex = beginIndex + longestPattern.length();
        String prefix = src.substring(beginIndex - 1, beginIndex);
        NonRegexPatternPosition position = NonRegexPatternPosition.NONE;
        if (!regexSign.contains(prefix)) {
            longestPattern = prefix + longestPattern;
            position = NonRegexPatternPosition.PREFIX;
        }
        String suffix = "";
        if (src.length() > endIndex) {
            suffix = src.substring(endIndex, endIndex + 1);
        }
        boolean bFlag = false;
        if (Objects.equals(suffix, ".") && src.length() > endIndex + 1 && StringUtils.indexOf((String)range, (char)(c = src.charAt(endIndex + 1))) != -1) {
            bFlag = true;
        }
        if (!(Objects.equals(suffix, "") || regexSign.contains(suffix) || bFlag)) {
            longestPattern = longestPattern + suffix;
            position = position == NonRegexPatternPosition.PREFIX ? NonRegexPatternPosition.BOTH : NonRegexPatternPosition.SUFFIX;
        }
        if (Objects.equals(suffix, "")) {
            position = position == NonRegexPatternPosition.PREFIX ? NonRegexPatternPosition.ENDSUFFIX : NonRegexPatternPosition.END;
        }
        return position == NonRegexPatternPosition.NONE ? null : new PathDateExpression(longestPattern, position);
    }

    public static String formatTime(long time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        return df.format(new Date(time));
    }

    public static boolean compare(String time, int offset) throws ParseException {
        long from;
        long value = 86400000L;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        long to = System.currentTimeMillis();
        return (to - (from = df.parse(time.substring(0, 8)).getTime())) / value > (long)offset;
    }

    public static boolean compare(long time, int offset) {
        long value = 86400000L;
        long to = System.currentTimeMillis();
        return (to - time) / value > (long)offset;
    }

    public void init(String timeFormat) {
        if (timeFormat != null && !timeFormat.isEmpty()) {
            this.dateFormat = timeFormat;
        }
    }

    private String normalizeDateStr(String src) {
        src = src.replaceAll("[^a-zA-Z0-9]", "");
        int len = src.length();
        StringBuffer sb = new StringBuffer();
        sb.append(src.substring(0, 4));
        sb.append("-");
        if (len > 4) {
            sb.append(src.substring(4, 6));
            if (len > 6) {
                sb.append("-");
                sb.append(src.substring(6, 8));
                if (len > 8) {
                    sb.append(" ");
                    sb.append(src.substring(8, 10));
                    if (len > 10) {
                        sb.append(":");
                        sb.append(src.substring(10, 12));
                        if (len > 12) {
                            sb.append(":");
                            sb.append(src.substring(12, 14));
                        } else {
                            sb.append(":00");
                        }
                    } else {
                        sb.append(":00:00");
                    }
                } else {
                    sb.append(" 00:00:00");
                }
            } else {
                sb.append("-01 00:00:00");
            }
        } else {
            sb.append("-01-01 00:00:00");
        }
        return sb.toString();
    }

    public String getFormatSpecifiedTime(String specifiedTime) {
        if (specifiedTime == null || specifiedTime.length() == 0) {
            return specifiedTime;
        }
        int formatLen = this.dateFormat.length();
        if (specifiedTime.length() == formatLen && !specifiedTime.matches(DIGIT_STR)) {
            return specifiedTime;
        }
        StringBuilder retSb = new StringBuilder();
        int specifiedInx = 0;
        for (int i = 0; i < formatLen; ++i) {
            char tmpChar = this.dateFormat.charAt(i);
            if (tmpChar != 'Y' && tmpChar != 'M' && tmpChar != 'D' && tmpChar != 'h' && tmpChar != 'm') {
                retSb.append(tmpChar);
                continue;
            }
            retSb.append(specifiedTime.charAt(specifiedInx++));
        }
        logger.info("TimeRegex {} <> specifiedTime {} not match, format specifiedTime {}", new Object[]{this.dateFormat, specifiedTime, retSb.toString()});
        return retSb.toString();
    }

    public String getDate(String src, String limit) {
        String[] limitArr;
        if (src == null || src.trim().isEmpty()) {
            return "";
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        TimeZone tz = TimeZone.getTimeZone("GMT+8:00");
        DateTime dt = null;
        String outputFormat = null;
        if (src.matches(LETTER_STR)) {
            dt = DateTime.now((TimeZone)tz);
            outputFormat = src;
        } else {
            src = src.replaceAll("[^0-9]", "");
            outputFormat = DateUtils.getSubTimeFormat(this.dateFormat, src.length());
            if ((src = this.normalizeDateStr(src)).isEmpty()) {
                return "";
            }
            dt = new DateTime(src);
        }
        limit = limit.trim();
        for (String onelimit : limitArr = limit.split(LIMIT_SEP)) {
            year = 0;
            month = 0;
            day = 0;
            hour = 0;
            minute = 0;
            second = 0;
            int limitLen = onelimit.length();
            String type = onelimit.substring(limitLen - 1, limitLen);
            int offset = Integer.parseInt(onelimit.substring(0, limitLen - 1));
            int sign = 1;
            sign = offset < 0 ? -1 : 1;
            if (type.equalsIgnoreCase("Y")) {
                year = sign * offset;
            } else if (type.equals("M")) {
                month = sign * offset;
            } else if (type.equalsIgnoreCase("D")) {
                day = sign * offset;
            } else if (type.equalsIgnoreCase("h")) {
                hour = sign * offset;
            } else if (type.equals("m")) {
                minute = sign * offset;
            } else if (type.equalsIgnoreCase("s")) {
                second = sign * offset;
            }
            dt = sign < 0 ? dt.minus(Integer.valueOf(year), Integer.valueOf(month), Integer.valueOf(day), Integer.valueOf(hour), Integer.valueOf(minute), Integer.valueOf(second), Integer.valueOf(0), DateTime.DayOverflow.LastDay) : dt.plus(Integer.valueOf(year), Integer.valueOf(month), Integer.valueOf(day), Integer.valueOf(hour), Integer.valueOf(minute), Integer.valueOf(second), Integer.valueOf(0), DateTime.DayOverflow.LastDay);
        }
        return dt.format(outputFormat);
    }

    public String getAttrPunit(String attrs) {
        String punit = null;
        if (attrs != null && attrs.contains("&p=")) {
            for (String attr : attrs.split("&")) {
                if (!attr.startsWith("p=") || attr.split("=").length != 2) continue;
                punit = attr.split("=")[1];
                break;
            }
        }
        return punit;
    }

    public String getSpecifiedDate(String src, String limit, String punit) {
        String ret = this.getDate(src, limit);
        return this.formatCurrPeriod(ret, punit);
    }

    public String normalizeTimeRegex(String src) {
        return DateUtils.getSubTimeFormat(this.dateFormat, src.length());
    }

    public String getCurrentDir(String src, String timeOffset) {
        Matcher m = pattern.matcher(src);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String oneMatch = m.group(0);
            String currTimeStr = this.getDate(oneMatch, timeOffset);
            m.appendReplacement(sb, currTimeStr);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String getCurrentDirByPunit(String src, String timeOffset, String punit) {
        Matcher m = pattern.matcher(src);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String oneMatch = m.group(0);
            String currTimeStr = this.getSpecifiedDate(oneMatch, timeOffset, punit);
            m.appendReplacement(sb, currTimeStr);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String getSpecifiedDir(String src, String specifiedDate) {
        Matcher m = pattern.matcher(src);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String oneMatch = m.group(0);
            StringBuilder tmpSb = new StringBuilder();
            int specifiedDateIdx = 0;
            for (int i = 0; i < oneMatch.length(); ++i) {
                char matchChar = oneMatch.charAt(i);
                if (matchChar != 'Y' && matchChar != 'M' && matchChar != 'D' && matchChar != 'h' && matchChar != 'm') {
                    tmpSb.append(matchChar);
                    continue;
                }
                char dateChar = specifiedDate.charAt(specifiedDateIdx);
                while (String.valueOf(dateChar).matches("\\D")) {
                    dateChar = specifiedDate.charAt(++specifiedDateIdx);
                }
                tmpSb.append(dateChar);
                ++specifiedDateIdx;
            }
            m.appendReplacement(sb, tmpSb.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String formatCurrPeriod(String src, String punit) {
        if (src == null || punit == null || src.length() != 12) {
            return src;
        }
        String prefixMinuteStr = src.substring(0, src.length() - 2);
        String minuteStr = src.substring(src.length() - 2, src.length());
        if ("n".equals(punit)) {
            minuteStr = minuteStr.compareTo("30") < 0 ? "00" : "30";
        } else if ("q".equals(punit)) {
            minuteStr = minuteStr.compareTo("15") < 0 ? "00" : (minuteStr.compareTo("30") < 0 ? "15" : (minuteStr.compareTo("45") < 0 ? "30" : "45"));
        } else if ("t".equals(punit)) {
            minuteStr = minuteStr.charAt(0) + "0";
        } else if ("f".equals(punit)) {
            minuteStr = minuteStr.substring(1).compareTo("5") < 0 ? minuteStr.charAt(0) + "0" : minuteStr.charAt(0) + "5";
        }
        return prefixMinuteStr + minuteStr;
    }
}

