/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task.filecollect;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.inlong.agent.plugin.utils.file.DateUtils;
import org.apache.inlong.agent.plugin.utils.file.FilePathUtil;
import org.apache.inlong.agent.plugin.utils.file.NewDateUtils;
import org.apache.inlong.agent.plugin.utils.file.NonRegexPatternPosition;
import org.apache.inlong.agent.plugin.utils.file.PathDateExpression;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchEntity {
    private static final Logger logger = LoggerFactory.getLogger(WatchEntity.class);
    private WatchService watchService;
    private final String basicStaticPath;
    private final String originPattern;
    private final String regexPattern;
    private final Pattern pattern;
    private final PathDateExpression dateExpression;
    private final String originPatternWithoutFileName;
    private final Pattern patternWithoutFileName;
    private final boolean containRegexPattern;
    private final Map<WatchKey, Path> keys = new ConcurrentHashMap<WatchKey, Path>();
    private final Map<String, WatchKey> pathToKeys = new ConcurrentHashMap<String, WatchKey>();
    private final String dirSeparator = System.getProperty("file.separator");
    private String cycleUnit;

    public WatchEntity(WatchService watchService, String originPattern, String cycleUnit) {
        this.watchService = watchService;
        this.originPattern = originPattern;
        ArrayList<String> directoryLayers = FilePathUtil.getDirectoryLayers(originPattern);
        this.basicStaticPath = directoryLayers.get(0);
        this.regexPattern = NewDateUtils.replaceDateExpressionWithRegex(originPattern);
        this.pattern = Pattern.compile(this.regexPattern, 42);
        ArrayList<String> directories = FilePathUtil.cutDirectory(originPattern);
        this.originPatternWithoutFileName = directories.get(0);
        this.patternWithoutFileName = Pattern.compile(NewDateUtils.replaceDateExpressionWithRegex(this.originPatternWithoutFileName), 42);
        this.dateExpression = DateUtils.extractLongestTimeRegexWithPrefixOrSuffix(originPattern);
        this.containRegexPattern = this.isPathContainRegexPattern();
        this.cycleUnit = cycleUnit;
        logger.info("add a new watchEntity {}", (Object)this);
    }

    public String toString() {
        return "WatchEntity [parentPathName=" + this.basicStaticPath + ", readFilePattern=" + this.regexPattern + ", dateExpression=" + this.dateExpression + ", totalDirPattern=" + this.originPatternWithoutFileName + ", containRegexPattern=" + this.containRegexPattern + ", totalDirRegexPattern=" + this.patternWithoutFileName + ", keys=" + this.keys + ", pathToKeys=" + this.pathToKeys + ", watchService=" + this.watchService + "]";
    }

    private boolean isPathContainRegexPattern() {
        return this.originPatternWithoutFileName.contains("YYYY") || this.originPatternWithoutFileName.contains("MM") || this.originPatternWithoutFileName.contains("DD") || this.originPatternWithoutFileName.contains("hh");
    }

    public boolean isContainRegexPattern() {
        return this.containRegexPattern;
    }

    private int calcPathDepth(String rootDir, String dirName) {
        return 0;
    }

    private void register(Path dir) throws IOException {
        if (dir == null) {
            return;
        }
        String dirName = dir.toAbsolutePath().toString();
        logger.info(dirName);
        Matcher matcher = this.patternWithoutFileName.matcher(dirName);
        String rootDir = Paths.get(this.basicStaticPath, new String[0]).toAbsolutePath().toString();
        Paths.get(this.basicStaticPath, new String[0]).toAbsolutePath().getNameCount();
        if (!this.pathToKeys.containsKey(dirName) && (matcher.matches() || rootDir.equals(dirName))) {
            WatchKey key = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
            this.keys.put(key, dir);
            this.pathToKeys.put(dirName, key);
            logger.info("Register a new directory: " + dir.toAbsolutePath().toString());
        }
    }

    public void registerRecursively() throws IOException {
        Path rootPath = Paths.get(this.basicStaticPath, new String[0]);
        String rootDirName = rootPath.toAbsolutePath().toString();
        if (!this.pathToKeys.containsKey(rootDirName)) {
            WatchKey key = rootPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
            this.keys.put(key, rootPath);
            this.pathToKeys.put(rootDirName, key);
            logger.info("Register a new directory: " + rootDirName);
        }
        this.registerRecursively(rootPath.toFile(), rootPath.toAbsolutePath().toString().length() + 1);
    }

    public void registerRecursively(Path dir) throws IOException {
        Path rootPath = dir;
        String rootDirName = rootPath.toAbsolutePath().toString();
        int beginIndex = rootDirName.lastIndexOf(this.dirSeparator) + 1;
        if (beginIndex == 0) {
            return;
        }
        int index = this.originPatternWithoutFileName.indexOf(this.dirSeparator, beginIndex + 1);
        Pattern pattern = this.getPattern(index);
        logger.info("beginIndex {} ,index {} ,dirPattern {}", new Object[]{beginIndex, index, pattern.pattern()});
        if (this.pathToKeys.containsKey(rootDirName) || !this.match(pattern, rootDirName)) {
            return;
        }
        WatchKey key = rootPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
        this.keys.put(key, rootPath);
        this.pathToKeys.put(rootDirName, key);
        logger.info("Register a new directory: " + rootDirName);
        logger.info("rootPath len {}", (Object)rootPath.toAbsolutePath().toString().length());
        this.registerRecursively(rootPath.toFile(), rootPath.toAbsolutePath().toString().length() + 1);
    }

    public void registerRecursively(File dir, int beginIndex) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int index = this.originPatternWithoutFileName.indexOf(this.dirSeparator, beginIndex);
        Pattern pattern = this.getPattern(index);
        logger.info("beginIndex {} ,index {} ,dirPattern {}", new Object[]{beginIndex, index, pattern.pattern()});
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            String dirName = files[i].toString();
            Path dirPath = Paths.get(dirName, new String[0]);
            if (this.pathToKeys.containsKey(dirName) || !this.match(pattern, dirName)) continue;
            try {
                WatchKey key = dirPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
                this.keys.put(key, dirPath);
                this.pathToKeys.put(dirName, key);
                logger.info("Register a new directory: " + dirName);
            }
            catch (IOException e) {
                logger.error("Register directory {} error, skip it. ", (Object)dirName, (Object)e);
                continue;
            }
            this.registerRecursively(files[i].getAbsoluteFile(), files[i].getAbsolutePath().length() + 1);
        }
    }

    private Pattern getPattern(int index) {
        String dirPattern = "";
        dirPattern = index == -1 ? this.originPatternWithoutFileName : this.originPatternWithoutFileName.substring(0, index);
        Pattern pattern = Pattern.compile(NewDateUtils.replaceDateExpressionWithRegex(dirPattern), 42);
        return pattern;
    }

    private boolean match(Pattern pattern, String dirName) {
        Matcher matcher = pattern.matcher(dirName);
        return matcher.matches() || matcher.lookingAt();
    }

    public Path getPath(WatchKey key) {
        return this.keys.get(key);
    }

    public int getTotalPathSize() {
        return this.keys.size();
    }

    public String getWatchPath() {
        return this.basicStaticPath;
    }

    public WatchService getWatchService() {
        return this.watchService;
    }

    public void setWatchService(WatchService watchService) {
        this.watchService = watchService;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public PathDateExpression getDateExpression() {
        return this.dateExpression;
    }

    public String getLongestDatePattern() {
        return this.dateExpression.getLongestDatePattern();
    }

    public NonRegexPatternPosition getPatternPosition() {
        return this.dateExpression.getPatternPosition();
    }

    public void removeUselessWatchDirectories(String curDataTime) throws Exception {
        String minute;
        String hour;
        String day;
        logger.info("removeUselessWatchDirectories {}", (Object)curDataTime);
        long curDataTimeMillis = DateTransUtils.timeStrConvertToMillSec((String)curDataTime, (String)this.cycleUnit);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(curDataTimeMillis);
        if ("D".equalsIgnoreCase(this.cycleUnit)) {
            calendar.add(6, -3);
        } else if ("h".equalsIgnoreCase(this.cycleUnit)) {
            calendar.add(11, -3);
        } else if ("10m".equalsIgnoreCase(this.cycleUnit)) {
            calendar.add(12, -30);
        }
        String year = String.valueOf(calendar.get(1));
        String month = String.valueOf(calendar.get(2) + 1);
        if (month.length() < 2) {
            month = "0" + month;
        }
        if ((day = String.valueOf(calendar.get(5))).length() < 2) {
            day = "0" + day;
        }
        if ((hour = String.valueOf(calendar.get(11))).length() < 2) {
            hour = "0" + hour;
        }
        if ((minute = String.valueOf(calendar.get(12))).length() < 2) {
            minute = "0" + minute;
        }
        String copyDirPattern = new String(this.originPatternWithoutFileName);
        copyDirPattern = copyDirPattern.replace("YYYY", year);
        copyDirPattern = copyDirPattern.replace("MM", month);
        copyDirPattern = copyDirPattern.replace("DD", day);
        copyDirPattern = copyDirPattern.replace("hh", hour);
        copyDirPattern = copyDirPattern.replace("mm", minute);
        Set<String> keys = this.pathToKeys.keySet();
        HashSet<String> tmpKeys = new HashSet<String>();
        tmpKeys.addAll(keys);
        String rootDir = Paths.get(this.basicStaticPath, new String[0]).toAbsolutePath().toString();
        for (String path : tmpKeys) {
            logger.info("[Path]{}  {}", (Object)path, (Object)copyDirPattern);
            if (path.compareTo(copyDirPattern) >= 0 || copyDirPattern.contains(path)) continue;
            WatchKey key = this.pathToKeys.get(path);
            key.cancel();
            this.pathToKeys.remove(path);
            logger.info("Watch path: {} is too old for data time: {}, we should remove", (Object)path, (Object)curDataTime);
        }
    }

    public void clearPathToKeys() {
        this.pathToKeys.clear();
    }

    public void clearKeys() {
        this.keys.clear();
    }

    public String getCycleUnit() {
        return this.cycleUnit;
    }

    public String getOriginPattern() {
        return this.originPattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

