/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task.filecollect;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.core.instance.ActionType;
import org.apache.inlong.agent.core.instance.InstanceAction;
import org.apache.inlong.agent.core.instance.InstanceManager;
import org.apache.inlong.agent.core.task.TaskAction;
import org.apache.inlong.agent.core.task.file.TaskManager;
import org.apache.inlong.agent.db.Db;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.file.Task;
import org.apache.inlong.agent.plugin.task.filecollect.FileScanner;
import org.apache.inlong.agent.plugin.task.filecollect.WatchEntity;
import org.apache.inlong.agent.plugin.utils.file.FilePathUtil;
import org.apache.inlong.agent.plugin.utils.file.NewDateUtils;
import org.apache.inlong.agent.plugin.utils.file.PathDateExpression;
import org.apache.inlong.agent.state.State;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.apache.inlong.agent.utils.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileCollectTask
extends Task {
    public static final String DEFAULT_FILE_INSTANCE = "org.apache.inlong.agent.plugin.instance.FileInstance";
    private static final Logger LOGGER = LoggerFactory.getLogger(LogFileCollectTask.class);
    public static final String SCAN_CYCLE_RANCE = "-2";
    private TaskProfile taskProfile;
    private Db basicDb;
    private TaskManager taskManager;
    private InstanceManager instanceManager;
    private final Map<String, WatchEntity> watchers = new ConcurrentHashMap<String, WatchEntity>();
    private final Set<String> watchFailedDirs = new HashSet<String>();
    private final Map<String, Map<String, InstanceProfile>> eventMap = new ConcurrentHashMap<String, Map<String, InstanceProfile>>();
    public static final long DAY_TIMEOUT_INTERVAL = 172800000L;
    public static final int CORE_THREAD_SLEEP_TIME = 1000;
    public static final int CORE_THREAD_MAX_GAP_TIME_MS = 60000;
    public static final int CORE_THREAD_PRINT_TIME = 10000;
    private long lastPrintTime = 0L;
    private boolean retry;
    private long startTime;
    private long endTime;
    private boolean realTime = false;
    private boolean initOK = false;
    private Set<String> originPatterns;
    private long lastScanTime = 0L;
    public final long SCAN_INTERVAL = 60000L;
    private volatile boolean runAtLeastOneTime = false;
    private volatile long coreThreadUpdateTime = 0L;
    private volatile boolean running = false;

    public void init(Object srcManager, TaskProfile taskProfile, Db basicDb) throws IOException {
        this.taskManager = (TaskManager)srcManager;
        this.commonInit(taskProfile, basicDb);
        if (this.retry) {
            this.retryInit();
        } else {
            this.watchInit();
        }
        this.initOK = true;
    }

    private void commonInit(TaskProfile taskProfile, Db basicDb) {
        this.taskProfile = taskProfile;
        this.basicDb = basicDb;
        this.retry = taskProfile.getBoolean("task.fileTask.retry", false);
        this.originPatterns = Stream.of(taskProfile.get("task.fileTask.dir.patterns").split(",")).collect(Collectors.toSet());
        if (taskProfile.getCycleUnit().compareToIgnoreCase("R") == 0) {
            this.realTime = true;
        }
        this.instanceManager = new InstanceManager(taskProfile.getTaskId(), taskProfile.getInt("task.fileTask.maxFileCount"), basicDb, this.taskManager.getTaskDb());
        try {
            this.instanceManager.start();
        }
        catch (Exception e) {
            LOGGER.error("start instance manager error: ", (Throwable)e);
        }
    }

    public boolean isProfileValid(TaskProfile profile) {
        boolean ret;
        if (!profile.allRequiredKeyExist()) {
            LOGGER.error("task profile needs all required key");
            return false;
        }
        boolean bl = ret = profile.hasKey("task.fileTask.dir.patterns") && profile.hasKey("task.fileTask.maxFileCount");
        if (!ret) {
            LOGGER.error("task profile needs file keys");
            return false;
        }
        if (profile.getCycleUnit().compareToIgnoreCase("R") != 0 && !profile.hasKey("task.fileTask.timeOffset")) {
            LOGGER.error("task profile needs time offset");
            return false;
        }
        if (profile.getBoolean("task.fileTask.retry", false)) {
            long startTime = profile.getLong("task.fileTask.startTime", 0L);
            long endTime = profile.getLong("task.fileTask.endTime", 0L);
            if (startTime == 0L || endTime == 0L) {
                LOGGER.error("retry task time error start {} end {}", (Object)startTime, (Object)endTime);
                return false;
            }
        }
        return true;
    }

    private void retryInit() {
        this.startTime = this.taskProfile.getLong("task.fileTask.startTime", 0L);
        this.endTime = this.taskProfile.getLong("task.fileTask.endTime", 0L);
    }

    private void watchInit() {
        this.originPatterns.forEach(pathPattern -> this.addPathPattern((String)pathPattern));
    }

    public void addPathPattern(String originPattern) {
        ArrayList<String> directories = FilePathUtil.getDirectoryLayers(originPattern);
        String basicStaticPath = directories.get(0);
        LOGGER.info("dataName {} watchPath {}", new Object[]{originPattern, basicStaticPath});
        if (!new File(basicStaticPath).exists()) {
            LOGGER.warn("ERROR-0-INLONG_AGENT|11001|WARN|WARN_DIRECTORY_NOT_EXIST|" + basicStaticPath);
            this.watchFailedDirs.add(originPattern);
            return;
        }
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            WatchEntity entity = new WatchEntity(watchService, originPattern, this.taskProfile.getCycleUnit());
            entity.registerRecursively();
            this.watchers.put(originPattern, entity);
            this.watchFailedDirs.remove(originPattern);
        }
        catch (IOException e) {
            if (e.toString().contains("Too many open files") || e.toString().contains("\u6253\u5f00\u7684\u6587\u4ef6\u8fc7\u591a")) {
                LOGGER.error("ERROR-0-INLONG_AGENT|11002|ERROR|ERROR_WATCH_DIR_ERROR|" + e.toString());
            } else {
                LOGGER.error("ERROR-0-INLONG_AGENT|11002|ERROR|ERROR_WATCH_DIR_ERROR|" + e.toString(), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("addPathPattern:", (Throwable)e);
        }
    }

    public void destroy() {
        this.doChangeState(State.SUCCEEDED);
        if (this.instanceManager != null) {
            this.instanceManager.stop();
        }
        this.releaseWatchers(this.watchers);
    }

    private void releaseWatchers(Map<String, WatchEntity> watchers) {
        while (this.running) {
            if (AgentUtils.getCurrentTime() - this.coreThreadUpdateTime > 60000L) {
                LOGGER.error("core thread not update, maybe it has broken");
                break;
            }
            AgentUtils.silenceSleepInMs((long)1000L);
        }
        watchers.forEach((taskId, watcher) -> {
            try {
                watcher.getWatchService().close();
            }
            catch (IOException e) {
                LOGGER.error("close watch service failed taskId {}", (Object)e, taskId);
            }
        });
    }

    public TaskProfile getProfile() {
        return this.taskProfile;
    }

    public String getTaskId() {
        if (this.taskProfile == null) {
            return "";
        }
        return this.taskProfile.getTaskId();
    }

    public void addCallbacks() {
    }

    public void run() {
        Thread.currentThread().setName("directory-task-core-" + this.getTaskId());
        this.running = true;
        while (!this.isFinished()) {
            if (AgentUtils.getCurrentTime() - this.lastPrintTime > 10000L) {
                LOGGER.info("log file task running! taskId {}", (Object)this.getTaskId());
                this.lastPrintTime = AgentUtils.getCurrentTime();
            }
            this.coreThreadUpdateTime = AgentUtils.getCurrentTime();
            AgentUtils.silenceSleepInMs((long)1000L);
            if (!this.initOK) continue;
            if (this.retry) {
                this.runForRetry();
            } else {
                this.runForNormal();
            }
            String inlongGroupId = this.taskProfile.getInlongGroupId();
            String inlongStreamId = this.taskProfile.getInlongStreamId();
            AuditUtils.add((int)30008, (String)inlongGroupId, (String)inlongStreamId, (long)AgentUtils.getCurrentTime(), (int)1, (long)1L);
        }
        this.running = false;
    }

    private void runForRetry() {
        if (!this.runAtLeastOneTime) {
            this.scanExistingFile();
            this.dealWithEventMap();
            this.runAtLeastOneTime = true;
        }
        if (this.instanceManager.allInstanceFinished()) {
            LOGGER.info("retry task finished, send action to task manager, taskId {}", (Object)this.getTaskId());
            TaskAction action = new TaskAction(org.apache.inlong.agent.core.task.ActionType.FINISH, this.taskProfile);
            this.taskManager.submitAction(action);
            this.doChangeState(State.SUCCEEDED);
        }
    }

    private void runForNormal() {
        if (AgentUtils.getCurrentTime() - this.lastScanTime > 60000L) {
            this.scanExistingFile();
            this.lastScanTime = AgentUtils.getCurrentTime();
        }
        this.runForWatching();
        this.dealWithEventMap();
    }

    private void scanExistingFile() {
        this.originPatterns.forEach(originPattern -> {
            List<FileScanner.BasicFileInfo> fileInfos = this.scanExistingFileByPattern((String)originPattern);
            LOGGER.info("taskId {} scan {} get file count {}", new Object[]{this.getTaskId(), originPattern, fileInfos.size()});
            fileInfos.forEach(fileInfo -> this.addToEvenMap(fileInfo.fileName, fileInfo.dataTime));
        });
    }

    private boolean isInEventMap(String fileName, String dataTime) {
        Map<String, InstanceProfile> fileToProfile = this.eventMap.get(dataTime);
        if (fileToProfile == null) {
            return false;
        }
        return fileToProfile.get(fileName) != null;
    }

    private List<FileScanner.BasicFileInfo> scanExistingFileByPattern(String originPattern) {
        long startScanTime = this.startTime;
        long endScanTime = this.endTime;
        if (!this.retry) {
            long currentTime = System.currentTimeMillis();
            long offset = DateTransUtils.calcOffset((String)(SCAN_CYCLE_RANCE + this.taskProfile.getCycleUnit()));
            startScanTime = currentTime + offset;
            endScanTime = currentTime;
        }
        if (this.realTime) {
            return FileScanner.scanTaskBetweenTimes(originPattern, "h", this.taskProfile.getTimeOffset(), startScanTime, endScanTime, this.retry);
        }
        return FileScanner.scanTaskBetweenTimes(originPattern, this.taskProfile.getCycleUnit(), this.taskProfile.getTimeOffset(), startScanTime, endScanTime, this.retry);
    }

    private void runForWatching() {
        HashSet<String> tmpWatchFailedDirs = new HashSet<String>(this.watchFailedDirs);
        for (String string : tmpWatchFailedDirs) {
            this.addPathPattern(string);
        }
        for (Map.Entry entry : this.watchers.entrySet()) {
            this.dealWithWatchEntity((String)entry.getKey());
        }
    }

    private void dealWithEventMap() {
        this.removeTimeoutEvent(this.eventMap, this.retry);
        if (this.realTime) {
            this.dealWithEventMapRealTime();
        } else {
            this.dealWithEventMapWithCycle();
        }
    }

    private void dealWithEventMapWithCycle() {
        List<String> dataTimeList;
        long startScanTime = this.startTime;
        long endScanTime = this.endTime;
        if (!this.retry) {
            long currentTime = System.currentTimeMillis();
            long offset = DateTransUtils.calcOffset((String)(SCAN_CYCLE_RANCE + this.taskProfile.getCycleUnit()));
            startScanTime = currentTime + offset;
            endScanTime = currentTime;
        }
        if ((dataTimeList = FileScanner.getDataTimeList(startScanTime, endScanTime, this.taskProfile.getCycleUnit(), this.taskProfile.getTimeOffset(), this.retry)).isEmpty()) {
            LOGGER.error("getDataTimeList get empty list");
            return;
        }
        HashSet<String> dealtDataTime = new HashSet<String>();
        if (!this.retry) {
            String current = dataTimeList.remove(dataTimeList.size() - 1);
            this.dealEventMapByDataTime(current, true);
            dealtDataTime.add(current);
        }
        dataTimeList.forEach(dataTime -> {
            dealtDataTime.add((String)dataTime);
            this.dealEventMapByDataTime((String)dataTime, false);
        });
        for (String dataTime2 : this.eventMap.keySet()) {
            if (dealtDataTime.contains(dataTime2)) continue;
            this.dealEventMapByDataTime(dataTime2, false);
        }
    }

    private void dealWithEventMapRealTime() {
        for (String dataTime : this.eventMap.keySet()) {
            this.dealEventMapByDataTime(dataTime, true);
        }
    }

    private void dealEventMapByDataTime(String dataTime, boolean isCurrentDataTime) {
        Map<String, InstanceProfile> sameDataTimeEvents = this.eventMap.get(dataTime);
        if (sameDataTimeEvents == null || sameDataTimeEvents.isEmpty()) {
            return;
        }
        if (this.realTime || this.shouldStartNow(dataTime)) {
            TreeSet<InstanceProfile> sortedEvents = new TreeSet<InstanceProfile>(sameDataTimeEvents.values());
            for (InstanceProfile sortEvent : sortedEvents) {
                String fileName = sortEvent.getInstanceId();
                InstanceProfile profile = sameDataTimeEvents.get(fileName);
                InstanceAction action = new InstanceAction(ActionType.ADD, profile);
                if (!isCurrentDataTime && this.instanceManager.isFull()) {
                    return;
                }
                while (!this.isFinished() && !this.instanceManager.submitAction(action)) {
                    LOGGER.error("instance manager action queue is full: taskId {}", (Object)this.instanceManager.getTaskId());
                    AgentUtils.silenceSleepInMs((long)1000L);
                }
                sameDataTimeEvents.remove(fileName);
            }
        }
    }

    private boolean shouldStartNow(String dataTime) {
        String shouldStartTime = NewDateUtils.getShouldStartTime(dataTime, this.taskProfile.getCycleUnit(), this.taskProfile.getTimeOffset());
        String currentTime = this.getCurrentTime();
        return currentTime.compareTo(shouldStartTime) >= 0;
    }

    private void removeTimeoutEvent(Map<String, Map<String, InstanceProfile>> eventMap, boolean isRetry) {
        if (isRetry || this.realTime) {
            return;
        }
        for (Map.Entry<String, Map<String, InstanceProfile>> entry : eventMap.entrySet()) {
            String dataTime = entry.getKey();
            if (NewDateUtils.isValidCreationTime(dataTime, 172800000L)) continue;
            eventMap.remove(dataTime);
            LOGGER.warn("remove too old event from event map. dataTime {}", (Object)dataTime);
        }
    }

    private String getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        TimeZone timeZone = TimeZone.getTimeZone("Asia/Shanghai");
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(new Date(System.currentTimeMillis()));
    }

    public synchronized void dealWithWatchEntity(String originPattern) {
        WatchEntity entity = this.watchers.get(originPattern);
        if (entity == null) {
            LOGGER.error("Can't find the watch entity for originPattern: " + originPattern);
            return;
        }
        try {
            for (int i = 0; i < entity.getTotalPathSize(); ++i) {
                WatchKey key = entity.getWatchService().poll();
                if (key == null) {
                    return;
                }
                this.dealWithWatchKey(entity, key);
            }
        }
        catch (Exception e) {
            LOGGER.error("deal with creation event error: ", (Throwable)e);
        }
    }

    private void dealWithWatchKey(WatchEntity entity, WatchKey key) throws IOException {
        Path contextPath = entity.getPath(key);
        LOGGER.info("Find creation events in path: " + contextPath.toAbsolutePath());
        for (WatchEvent<?> watchEvent : key.pollEvents()) {
            Path child = this.resolvePathFromEvent(watchEvent, contextPath);
            if (child == null) continue;
            if (Files.isDirectory(child, new LinkOption[0])) {
                LOGGER.info("The find creation event is triggered by a directory: " + child.getFileName());
                entity.registerRecursively(child);
                continue;
            }
            this.handleFilePath(child, entity);
        }
        this.resetWatchKey(entity, key, contextPath);
    }

    private Path resolvePathFromEvent(WatchEvent<?> watchEvent, Path contextPath) {
        WatchEvent.Kind<?> kind = watchEvent.kind();
        if (kind == StandardWatchEventKinds.OVERFLOW) {
            LOGGER.error("An event is unclear and lost");
            return null;
        }
        WatchEvent<?> watchEventPath = watchEvent;
        Path eventPath = (Path)watchEventPath.context();
        return contextPath.resolve(eventPath);
    }

    private void handleFilePath(Path filePath, WatchEntity entity) {
        String newFileName = filePath.toFile().getAbsolutePath();
        LOGGER.info("new file {} {}", (Object)newFileName, (Object)entity.getOriginPattern());
        Matcher matcher = entity.getPattern().matcher(newFileName);
        if (matcher.matches() || matcher.lookingAt()) {
            LOGGER.info("matched file {} {}", (Object)newFileName, (Object)entity.getOriginPattern());
            String dataTime = this.getDataTimeFromFileName(newFileName, entity.getOriginPattern(), entity.getDateExpression());
            if (!this.checkFileNameForTime(newFileName, entity)) {
                LOGGER.error("ERROR-0-INLONG_AGENT|10002|ERROR|ERROR_SOURCE_FILE|File Timeout {} {}", (Object)newFileName, (Object)dataTime);
                return;
            }
            this.addToEvenMap(newFileName, dataTime);
        }
    }

    private void addToEvenMap(String fileName, String dataTime) {
        if (this.isInEventMap(fileName, dataTime)) {
            LOGGER.info("addToEvenMap isInEventMap returns true skip taskId {} dataTime {} fileName {}", new Object[]{this.taskProfile.getTaskId(), dataTime, fileName});
            return;
        }
        Long fileUpdateTime = FileUtils.getFileLastModifyTime((String)fileName);
        if (!this.instanceManager.shouldAddAgain(fileName, fileUpdateTime.longValue())) {
            LOGGER.info("addToEvenMap shouldAddAgain returns false skip taskId {} dataTime {} fileName {}", new Object[]{this.taskProfile.getTaskId(), dataTime, fileName});
            return;
        }
        Map sameDataTimeEvents = this.eventMap.computeIfAbsent(dataTime, mapKey -> new ConcurrentHashMap());
        boolean containsInMemory = sameDataTimeEvents.containsKey(fileName);
        if (containsInMemory) {
            LOGGER.error("should not happen! may be {} has been deleted and add again", (Object)fileName);
            return;
        }
        String cycleUnit = "";
        cycleUnit = this.realTime ? "h" : this.taskProfile.getCycleUnit();
        InstanceProfile instanceProfile = this.taskProfile.createInstanceProfile(DEFAULT_FILE_INSTANCE, fileName, cycleUnit, dataTime, fileUpdateTime.longValue());
        sameDataTimeEvents.put(fileName, instanceProfile);
        LOGGER.info("add to eventMap taskId {} dataTime {} fileName {}", new Object[]{this.taskProfile.getTaskId(), dataTime, fileName});
    }

    private boolean checkFileNameForTime(String newFileName, WatchEntity entity) {
        PathDateExpression dateExpression = entity.getDateExpression();
        if (dateExpression.getLongestDatePattern().length() != 0) {
            String dataTime = this.getDataTimeFromFileName(newFileName, entity.getOriginPattern(), dateExpression);
            LOGGER.info("file {} ,fileTime {}", (Object)newFileName, (Object)dataTime);
            if (!NewDateUtils.isValidCreationTime(dataTime, entity.getCycleUnit(), this.taskProfile.getTimeOffset())) {
                return false;
            }
        }
        return true;
    }

    private String getDataTimeFromFileName(String fileName, String originPattern, PathDateExpression dateExpression) {
        String fileTime = NewDateUtils.getDateTime(fileName, originPattern, dateExpression);
        return fileTime.replaceAll("\\D", "");
    }

    private void resetWatchKey(WatchEntity entity, WatchKey key, Path contextPath) {
        key.reset();
        if (!key.isValid()) {
            LOGGER.warn("ERROR-1-INLONG_AGENT|40001|WARN|WARN_INVALID_WATCHER|Invalid Watcher {}", (Object)contextPath.getFileName());
            try {
                WatchService oldService = entity.getWatchService();
                oldService.close();
                WatchService watchService = FileSystems.getDefault().newWatchService();
                entity.clearKeys();
                entity.clearPathToKeys();
                entity.setWatchService(watchService);
                entity.registerRecursively();
            }
            catch (IOException e) {
                LOGGER.error("Restart a new watcher runs into error: ", (Throwable)e);
            }
        }
    }
}

