/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task.filecollect;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.inlong.agent.plugin.utils.file.FilePathUtil;
import org.apache.inlong.agent.plugin.utils.file.FileTimeComparator;
import org.apache.inlong.agent.plugin.utils.file.Files;
import org.apache.inlong.agent.plugin.utils.file.NewDateUtils;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileScanner {
    private static final Logger logger = LoggerFactory.getLogger(FileScanner.class);

    public static List<String> getDataTimeList(long startTime, long endTime, String cycleUnit, String timeOffset, boolean isRetry) {
        if (!isRetry) {
            startTime += DateTransUtils.calcOffset((String)timeOffset);
            endTime += DateTransUtils.calcOffset((String)timeOffset);
        }
        ArrayList<String> dataTimeList = new ArrayList<String>();
        List<Long> dateRegion = NewDateUtils.getDateRegion(startTime, endTime, cycleUnit);
        for (Long time : dateRegion) {
            String dataTime = DateTransUtils.millSecConvertToTimeStr((long)time, (String)cycleUnit);
            dataTimeList.add(dataTime);
        }
        return dataTimeList;
    }

    public static List<BasicFileInfo> scanTaskBetweenTimes(String originPattern, String cycleUnit, String timeOffset, long startTime, long endTime, boolean isRetry) {
        if (!isRetry) {
            startTime += DateTransUtils.calcOffset((String)timeOffset);
            endTime += DateTransUtils.calcOffset((String)timeOffset);
        }
        String strStartTime = DateTransUtils.millSecConvertToTimeStr((long)startTime, (String)cycleUnit);
        String strEndTime = DateTransUtils.millSecConvertToTimeStr((long)endTime, (String)cycleUnit);
        logger.info("{} scan time is between {} and {}", new Object[]{originPattern, strStartTime, strEndTime});
        return FileScanner.scanTaskBetweenTimes(cycleUnit, originPattern, startTime, endTime);
    }

    public static List<BasicFileInfo> scanTaskBetweenTimes(String cycleUnit, String originPattern, long startTime, long endTime) {
        List<Long> dateRegion = NewDateUtils.getDateRegion(startTime, endTime, cycleUnit);
        ArrayList<BasicFileInfo> infos = new ArrayList<BasicFileInfo>();
        for (Long time : dateRegion) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(time);
            String filename = NewDateUtils.replaceDateExpression(calendar, originPattern);
            ArrayList<String> allPaths = FilePathUtil.cutDirectory(filename);
            String firstDir = allPaths.get(0);
            String secondDir = allPaths.get(0) + File.separator + allPaths.get(1);
            ArrayList<String> fileList = FileScanner.getUpdatedOrNewFiles(firstDir, secondDir, filename, 3L, 4096);
            for (String file : fileList) {
                String dataTime = DateTransUtils.millSecConvertToTimeStr((long)time, (String)cycleUnit);
                BasicFileInfo info = new BasicFileInfo(file, dataTime);
                logger.info("scan new task fileName {} ,dataTime {}", (Object)file, (Object)dataTime);
                infos.add(info);
            }
        }
        return infos;
    }

    public static ArrayList<String> scanFile(int maxFileNum, String originPattern, long dataTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dataTime);
        String filename = NewDateUtils.replaceDateExpression(calendar, originPattern);
        ArrayList<String> allPaths = FilePathUtil.cutDirectory(filename);
        String firstDir = allPaths.get(0);
        String secondDir = allPaths.get(0) + File.separator + allPaths.get(1);
        return FileScanner.getUpdatedOrNewFiles(firstDir, secondDir, filename, 3L, maxFileNum);
    }

    private static ArrayList<String> getUpdatedOrNewFiles(String firstDir, String secondDir, String fileName, long depth, int maxFileNum) {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<File> readyFiles = new ArrayList<File>();
        if (!new File(firstDir).isDirectory()) {
            return ret;
        }
        for (File pathname : Files.find(firstDir).yieldFilesAndDirectories().recursive().withDepth((int)depth).withDirNameRegex(secondDir).withFileNameRegex(fileName)) {
            if (readyFiles.size() >= maxFileNum) break;
            readyFiles.add(pathname);
        }
        Collections.sort(readyFiles, new FileTimeComparator());
        for (File f : readyFiles) {
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }

    private static ArrayList<String> getUpdatedOrNewFiles(String logFileName, int maxFileNum) {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> directories = FilePathUtil.getDirectoryLayers(logFileName);
        String parentDir = directories.get(0) + File.separator + directories.get(1);
        Pattern pattern = Pattern.compile(directories.get(2), 2);
        for (File file : new File(parentDir).listFiles()) {
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.matches() || ret.size() >= maxFileNum) continue;
            ret.add(file.getAbsolutePath());
        }
        return ret;
    }

    public static void main(String[] args) {
        ArrayList<String> fileList = FileScanner.getUpdatedOrNewFiles("f:\\\\abc", "f:\\\\abc\\\\", "f:\\\\abc\\\\1.txt", 3L, 100);
        for (String fileName : fileList) {
            System.out.println(fileName);
        }
    }

    public static class BasicFileInfo {
        public String fileName;
        public String dataTime;

        public BasicFileInfo(String fileName, String dataTime) {
            this.fileName = fileName;
            this.dataTime = dataTime;
        }
    }
}

