/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.moilioncircle.redis.replicator.RedisReplicator;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.cmd.CommandName;
import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.impl.DefaultCommand;
import com.moilioncircle.redis.replicator.cmd.parser.DefaultCommandParser;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.event.EventListener;
import com.moilioncircle.redis.replicator.event.PostRdbSyncEvent;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueHash;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueList;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueSet;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueString;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueZSet;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sources.reader.file.AbstractReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisReader
extends AbstractReader {
    public static final String REDIS_READER_TAG_NAME = "AgentRedisMetric";
    public static final String JOB_REDIS_PORT = "job.redisJob.port";
    public static final String JOB_REDIS_HOSTNAME = "job.redisJob.hostname";
    public static final String JOB_REDIS_SSL = "job.redisJob.ssl";
    public static final String JOB_REDIS_AUTHUSER = "job.redisJob.authUser";
    public static final String JOB_REDIS_AUTHPASSWORD = "job.redisJob.authPassword";
    public static final String JOB_REDIS_READTIMEOUT = "job.redisJob.readTimeout";
    public static final String JOB_REDIS_QUEUE_SIZE = "job.redisJob.queueSize";
    public static final String JOB_REDIS_REPLID = "job.redisJob.replId";
    public static final String JOB_REDIS_OFFSET = "job.redisJob.offset";
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisReader.class);
    private String port;
    private String hostName;
    private boolean ssl;
    private String authUser;
    private String authPassword;
    private String readTimeout;
    private String instanceId;
    private String replId;
    private String snapShot;
    private boolean destroyed;
    private Replicator redisReplicator;
    private LinkedBlockingQueue<String> redisMessageQueue;
    private boolean finished = false;
    private ExecutorService executor;
    private Gson gson;

    @Override
    public void init(InstanceProfile jobConf) {
        LOGGER.info("Init redis reader with jobConf {}", (Object)jobConf.toJsonStr());
        this.port = jobConf.get(JOB_REDIS_PORT);
        this.hostName = jobConf.get(JOB_REDIS_HOSTNAME);
        this.ssl = jobConf.getBoolean(JOB_REDIS_SSL, false);
        this.authUser = jobConf.get(JOB_REDIS_AUTHUSER, "");
        this.authPassword = jobConf.get(JOB_REDIS_AUTHPASSWORD, "");
        this.readTimeout = jobConf.get(JOB_REDIS_READTIMEOUT, "");
        this.replId = jobConf.get(JOB_REDIS_REPLID, "");
        this.snapShot = jobConf.get(JOB_REDIS_OFFSET, "-1");
        this.instanceId = jobConf.getInstanceId();
        this.finished = false;
        this.redisMessageQueue = new LinkedBlockingQueue(jobConf.getInt(JOB_REDIS_QUEUE_SIZE, 10000));
        this.initGson();
        String uri = this.getRedisUri();
        try {
            this.redisReplicator = new RedisReplicator(uri);
            this.initReplicator();
            this.redisReplicator.addEventListener(new EventListener(){

                public void onEvent(Replicator replicator, Event event) {
                    try {
                        if (event instanceof DefaultCommand || event instanceof KeyValuePair) {
                            String eventJson = RedisReader.this.gson.toJson((Object)event);
                            RedisReader.this.redisMessageQueue.put(eventJson);
                            AuditUtils.add((int)3, (String)RedisReader.this.inlongGroupId, (String)RedisReader.this.inlongStreamId, (long)System.currentTimeMillis(), (int)1, (long)eventJson.length());
                            ((RedisReader)RedisReader.this).readerMetric.pluginReadCount.incrementAndGet();
                        }
                        if (event instanceof PostRdbSyncEvent) {
                            RedisReader.this.snapShot = String.valueOf(replicator.getConfiguration().getReplOffset());
                            LOGGER.info("after rdb snapShot is: {}", (Object)RedisReader.this.snapShot);
                        }
                    }
                    catch (InterruptedException e) {
                        ((RedisReader)RedisReader.this).readerMetric.pluginReadFailCount.incrementAndGet();
                        LOGGER.error("Read redis data error", (Throwable)e);
                    }
                }
            });
            this.executor = Executors.newSingleThreadExecutor();
            this.executor.execute(new Thread(() -> {
                try {
                    this.redisReplicator.open();
                }
                catch (IOException e) {
                    LOGGER.error("Redis source error", (Throwable)e);
                }
            }));
        }
        catch (IOException | URISyntaxException e) {
            this.readerMetric.pluginReadFailCount.addAndGet(1L);
            LOGGER.error("Connect to redis {}:{} failed.", (Object)this.hostName, (Object)this.port);
        }
    }

    private String getRedisUri() {
        StringBuffer sb = new StringBuffer("redis://");
        sb.append(this.hostName).append(":").append(this.port);
        sb.append("?");
        if (!StringUtils.isEmpty((String)this.authPassword)) {
            sb.append("authPassword=").append(this.authPassword).append("&");
        }
        if (!StringUtils.isEmpty((String)this.authUser)) {
            sb.append("authUser=").append(this.authUser).append("&");
        }
        if (!StringUtils.isEmpty((String)this.readTimeout)) {
            sb.append("readTimeout=").append(this.readTimeout).append("&");
        }
        if (this.ssl) {
            sb.append("ssl=").append("yes").append("&");
        }
        if (!StringUtils.isEmpty((String)this.snapShot)) {
            sb.append("replOffset=").append(this.snapShot).append("&");
        }
        if (!StringUtils.isEmpty((String)this.replId)) {
            sb.append("replId=").append(this.replId).append("&");
        }
        if (sb.charAt(sb.length() - 1) == '?' || sb.charAt(sb.length() - 1) == '&') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        RedisReader redisReader = this;
        synchronized (redisReader) {
            if (!this.destroyed) {
                try {
                    this.executor.shutdown();
                    this.redisReplicator.close();
                }
                catch (IOException e) {
                    LOGGER.error("Redis reader close failed.");
                }
                this.destroyed = true;
            }
        }
    }

    public Message read() {
        if (!this.redisMessageQueue.isEmpty()) {
            this.readerMetric.pluginReadCount.incrementAndGet();
            return new DefaultMessage(this.redisMessageQueue.poll().getBytes());
        }
        return null;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getReadSource() {
        return this.instanceId;
    }

    public void setReadSource(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setReadTimeout(long mill) {
    }

    public void setWaitMillisecond(long millis) {
    }

    public String getSnapshot() {
        return this.snapShot;
    }

    public void finishRead() {
        this.finished = true;
    }

    public boolean isSourceExist() {
        return true;
    }

    private void initGson() {
        this.gson = new GsonBuilder().registerTypeAdapter(KeyStringValueHash.class, (Object)new TypeAdapter<KeyStringValueHash>(){

            public void write(JsonWriter out, KeyStringValueHash kv) throws IOException {
                out.beginObject();
                out.name("DB").beginObject();
                out.name("dbNumber").value(kv.getDb().getDbNumber());
                out.name("dbSize").value((Number)kv.getDb().getDbsize());
                out.name("expires").value((Number)kv.getDb().getExpires());
                out.endObject();
                out.name("valueRdbType").value((long)kv.getValueRdbType());
                out.name("key").value(new String((byte[])kv.getKey()));
                out.name("value").beginObject();
                for (byte[] b : ((Map)kv.getValue()).keySet()) {
                    out.name(new String(b)).value(new String((byte[])((Map)kv.getValue()).get(b)));
                }
                out.endObject();
                out.endObject();
            }

            public KeyStringValueHash read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(DefaultCommand.class, (Object)new TypeAdapter<DefaultCommand>(){

            public void write(JsonWriter out, DefaultCommand dc) throws IOException {
                out.beginObject();
                out.name("key").value(new String(dc.getCommand()));
                out.name("value").beginArray();
                for (byte[] bytes : dc.getArgs()) {
                    out.value(new String(bytes));
                }
                out.endArray();
                out.endObject();
            }

            public DefaultCommand read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(KeyStringValueList.class, (Object)new TypeAdapter<KeyStringValueList>(){

            public void write(JsonWriter out, KeyStringValueList kv) throws IOException {
                out.beginObject();
                out.name("key").value(new String((byte[])kv.getKey()));
                out.name("value").beginArray();
                for (byte[] bytes : (List)kv.getValue()) {
                    out.value(new String(bytes));
                }
                out.endArray();
                out.endObject();
            }

            public KeyStringValueList read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(KeyStringValueSet.class, (Object)new TypeAdapter<KeyStringValueSet>(){

            public void write(JsonWriter out, KeyStringValueSet kv) throws IOException {
                out.beginObject();
                out.name("key").value(new String((byte[])kv.getKey()));
                out.name("value").beginArray();
                for (byte[] bytes : (Set)kv.getValue()) {
                    out.value(new String(bytes));
                }
                out.endArray();
                out.endObject();
            }

            public KeyStringValueSet read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(KeyStringValueString.class, (Object)new TypeAdapter<KeyStringValueString>(){

            public void write(JsonWriter out, KeyStringValueString kv) throws IOException {
                out.beginObject();
                out.name("key").value(new String((byte[])kv.getKey()));
                out.name("value").value(new String((byte[])kv.getValue()));
                out.endObject();
            }

            public KeyStringValueString read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(KeyStringValueZSet.class, (Object)new TypeAdapter<KeyStringValueZSet>(){

            public void write(JsonWriter out, KeyStringValueZSet kv) throws IOException {
                out.beginObject();
                out.name("key").value(new String((byte[])kv.getKey()));
                out.name("value").beginArray();
                for (ZSetEntry entry : (Set)kv.getValue()) {
                    out.beginObject();
                    out.name("element").value(new String(entry.getElement()));
                    out.name("score").value(entry.getScore());
                    out.endObject();
                }
                out.endArray();
                out.endObject();
            }

            public KeyStringValueZSet read(JsonReader in) throws IOException {
                return null;
            }
        }).create();
    }

    private void initReplicator() {
        DefaultCommandParser defaultCommandParser = new DefaultCommandParser();
        this.redisReplicator.addCommandParser(CommandName.name((String)"APPEND"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SETEX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"MSET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"DEL"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SADD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"HMSET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"HSET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LSET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"EXPIRE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"EXPIREAT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"GETSET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"HSETNX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"MSETNX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PSETEX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SETNX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SETRANGE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"HDEL"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LPOP"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LPUSH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LPUSHX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LRem"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RPOP"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RPUSH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RPUSHX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZREM"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RENAME"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"INCR"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"DECR"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"INCRBY"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"DECRBY"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PERSIST"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SELECT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"FLUSHALL"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"FLUSHDB"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"HINCRBY"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZINCRBY"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"MOVE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SMOVE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PFADD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PFCOUNT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PFMERGE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SDIFFSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SINTERSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SUNIONSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZADD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZINTERSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZUNIONSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"BRPOPLPUSH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LINSERT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RENAMENX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RESTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PEXPIRE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PEXPIREAT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"GEOADD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"EVAL"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"EVALSHA"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SCRIPT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PUBLISH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"BITOP"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"BITFIELD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SETBIT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SREM"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"UNLINK"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SWAPDB"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"MULTI"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"EXEC"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZREMRANGEBYSCORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZREMRANGEBYRANK"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZREMRANGEBYLEX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LTRIM"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SORT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RPOPLPUSH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZPOPMIN"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZPOPMAX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"REPLCONF"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XACK"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XADD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XCLAIM"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XDEL"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XGROUP"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XTRIM"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XSETID"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"COPY"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LMOVE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"BLMOVE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZDIFFSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"GEOSEARCHSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SPUBLISH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"FUNCTION"), (CommandParser)defaultCommandParser);
    }
}

