/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sources.reader.file.AbstractReader;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttReader
extends AbstractReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttReader.class);
    public static final String JOB_MQTT_USERNAME = "job.mqttJob.userName";
    public static final String JOB_MQTT_PASSWORD = "job.mqttJob.password";
    public static final String JOB_MQTT_SERVER_URI = "job.mqttJob.serverURI";
    public static final String JOB_MQTT_TOPIC = "job.mqttJob.topic";
    public static final String JOB_MQTT_CONNECTION_TIMEOUT = "job.mqttJob.connectionTimeOut";
    public static final String JOB_MQTT_KEEPALIVE_INTERVAL = "job.mqttJob.keepAliveInterval";
    public static final String JOB_MQTT_QOS = "job.mqttJob.qos";
    public static final String JOB_MQTT_CLEAN_SESSION = "job.mqttJob.cleanSession";
    public static final String JOB_MQTT_CLIENT_ID_PREFIX = "job.mqttJob.clientIdPrefix";
    public static final String JOB_MQTT_QUEUE_SIZE = "job.mqttJob.queueSize";
    public static final String JOB_MQTT_AUTOMATIC_RECONNECT = "job.mqttJob.automaticReconnect";
    public static final String JOB_MQTT_VERSION = "job.mqttJob.mqttVersion";
    private boolean finished = false;
    private boolean destroyed = false;
    private MqttClient client;
    private MqttConnectOptions options;
    private String serverURI;
    private String userName;
    private String password;
    private String topic;
    private int qos;
    private boolean cleanSession = false;
    private boolean automaticReconnect = true;
    private InstanceProfile jobProfile;
    private String instanceId;
    private String clientId;
    private int mqttVersion = 0;
    private LinkedBlockingQueue<DefaultMessage> mqttMessagesQueue;

    public MqttReader(String topic) {
        this.topic = topic;
    }

    private void setGlobalParamsValue(InstanceProfile jobConf) {
        this.mqttMessagesQueue = new LinkedBlockingQueue(jobConf.getInt(JOB_MQTT_QUEUE_SIZE, 1000));
        this.instanceId = jobConf.getInstanceId();
        this.userName = jobConf.get(JOB_MQTT_USERNAME);
        this.password = jobConf.get(JOB_MQTT_PASSWORD);
        this.serverURI = jobConf.get(JOB_MQTT_SERVER_URI);
        this.topic = jobConf.get(JOB_MQTT_TOPIC);
        this.clientId = jobConf.get(JOB_MQTT_CLIENT_ID_PREFIX, "mqtt_client") + "_" + UUID.randomUUID();
        this.cleanSession = jobConf.getBoolean(JOB_MQTT_CLEAN_SESSION, false);
        this.automaticReconnect = jobConf.getBoolean(JOB_MQTT_AUTOMATIC_RECONNECT, true);
        this.qos = jobConf.getInt(JOB_MQTT_QOS, 1);
        this.mqttVersion = jobConf.getInt(JOB_MQTT_VERSION, 0);
        this.options = new MqttConnectOptions();
        this.options.setCleanSession(this.cleanSession);
        this.options.setConnectionTimeout(jobConf.getInt(JOB_MQTT_CONNECTION_TIMEOUT, 10));
        this.options.setKeepAliveInterval(jobConf.getInt(JOB_MQTT_KEEPALIVE_INTERVAL, 20));
        this.options.setUserName(this.userName);
        this.options.setPassword(this.password.toCharArray());
        this.options.setAutomaticReconnect(this.automaticReconnect);
        this.options.setMqttVersion(this.mqttVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        try {
            Class<MqttReader> clazz = MqttReader.class;
            synchronized (MqttReader.class) {
                this.client = new MqttClient(this.serverURI, this.clientId, (MqttClientPersistence)new MemoryPersistence());
                this.client.setCallback(new MqttCallback(){

                    public void connectionLost(Throwable cause) {
                        LOGGER.error("the mqtt jobId:{}, serverURI:{}, connection lost, {} ", new Object[]{MqttReader.this.instanceId, MqttReader.this.serverURI, cause});
                        MqttReader.this.reconnect();
                    }

                    public void messageArrived(String topic, MqttMessage message) throws Exception {
                        HashMap<String, String> headerMap = new HashMap<String, String>();
                        headerMap.put("record.topic", topic);
                        headerMap.put("record.messageId", String.valueOf(message.getId()));
                        headerMap.put("record.qos", String.valueOf(message.getQos()));
                        byte[] recordValue = message.getPayload();
                        MqttReader.this.mqttMessagesQueue.put(new DefaultMessage(recordValue, headerMap));
                        AuditUtils.add((int)3, (String)MqttReader.this.inlongGroupId, (String)MqttReader.this.inlongStreamId, (long)System.currentTimeMillis(), (int)1, (long)recordValue.length);
                        ((MqttReader)MqttReader.this).readerMetric.pluginReadSuccessCount.incrementAndGet();
                        ((MqttReader)MqttReader.this).readerMetric.pluginReadCount.incrementAndGet();
                    }

                    public void deliveryComplete(IMqttDeliveryToken token) {
                    }
                });
                this.client.connect(this.options);
                this.client.subscribe(this.topic, this.qos);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                LOGGER.info("the mqtt subscribe topic is [{}], qos is [{}]", (Object)this.topic, (Object)this.qos);
            }
        }
        catch (Exception e) {
            LOGGER.error("init mqtt client error {}. jobId:{},serverURI:{},clientId:{}", new Object[]{e, this.instanceId, this.serverURI, this.clientId});
        }
    }

    @Override
    public void init(InstanceProfile jobConf) {
        super.init(jobConf);
        this.jobProfile = jobConf;
        LOGGER.info("init mqtt reader with jobConf {}", (Object)jobConf.toJsonStr());
        this.setGlobalParamsValue(jobConf);
        this.connect();
    }

    private void reconnect() {
        if (!this.client.isConnected()) {
            try {
                this.client.connect(this.options);
                LOGGER.info("the mqtt client reconnect success. jobId:{}, serverURI:{}, clientId:{}", new Object[]{this.instanceId, this.serverURI, this.clientId});
            }
            catch (Exception e) {
                LOGGER.error("reconnect mqtt client error {}. jobId:{}, serverURI:{}, clientId:{}", new Object[]{e, this.instanceId, this.serverURI, this.clientId});
            }
        }
    }

    public Message read() {
        if (!this.mqttMessagesQueue.isEmpty()) {
            return this.getMqttMessage();
        }
        return null;
    }

    private DefaultMessage getMqttMessage() {
        return this.mqttMessagesQueue.poll();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getReadSource() {
        return this.instanceId;
    }

    public void setReadTimeout(long mill) {
    }

    public void setWaitMillisecond(long millis) {
    }

    public String getSnapshot() {
        return "";
    }

    public void finishRead() {
        this.finished = true;
    }

    public boolean isSourceExist() {
        return true;
    }

    private void disconnect() {
        try {
            this.client.disconnect();
        }
        catch (MqttException e) {
            LOGGER.error("disconnect mqtt client error {}. jobId:{},serverURI:{},clientId:{}", new Object[]{e, this.instanceId, this.serverURI, this.clientId});
        }
    }

    public void setReadSource(String instanceId) {
        this.instanceId = instanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        MqttReader mqttReader = this;
        synchronized (mqttReader) {
            if (!this.destroyed) {
                this.disconnect();
                this.destroyed = true;
            }
        }
    }
}

