/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.Validator;
import org.apache.inlong.agent.plugin.sources.reader.file.AbstractReader;
import org.apache.inlong.agent.plugin.validator.PatternValidator;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaReader<K, V>
extends AbstractReader {
    public static final int NEVER_STOP_SIGN = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaReader.class);
    private static final String KAFKA_READER_TAG_NAME = "AgentKafkaMetric";
    private static final String KAFKA_SOURCE_READ_RECORD_SPEED = "job.kafkaJob.record.speed.limit";
    private static final String KAFKA_SOURCE_READ_BYTE_SPEED = "job.kafkaJob.byte.speed.limit";
    private static final String KAFKA_SOURCE_READ_MIN_INTERVAL = "kafka.min.interval.limit";
    private static final String JOB_KAFKAJOB_READ_TIMEOUT = "job.kafkaJob.read.timeout";
    private static AtomicLong currentTotalReadRecords = new AtomicLong(0L);
    private static AtomicLong lastTotalReadRecords = new AtomicLong(0L);
    private static AtomicLong currentTotalReadBytes = new AtomicLong(0L);
    private static AtomicLong lastTotalReadBytes = new AtomicLong(0L);
    KafkaConsumer<K, V> consumer;
    long lastTimestamp;
    long recordSpeed;
    long byteSpeed;
    long flowControlInterval;
    private Iterator<ConsumerRecord<K, V>> iterator;
    private List<Validator> validators = new ArrayList<Validator>();
    private long timeout;
    private long waitTimeout = 1000L;
    private long lastTime = 0L;
    private String inlongGroupId;
    private String inlongStreamId;
    private String snapshot;
    private boolean isFinished = false;
    private boolean destroyed = false;
    private String topic;

    public KafkaReader(KafkaConsumer<K, V> consumer, Map<String, String> paraMap) {
        this.consumer = consumer;
        this.recordSpeed = Long.parseLong(paraMap.getOrDefault("job.kafkaJob.recordSpeed.limit", "10000"));
        this.byteSpeed = Long.parseLong(paraMap.getOrDefault("job.kafkaJob.byteSpeed.limit", String.valueOf(0x100000)));
        this.flowControlInterval = Long.parseLong(paraMap.getOrDefault(KAFKA_SOURCE_READ_MIN_INTERVAL, "1000"));
        this.lastTimestamp = System.currentTimeMillis();
        this.topic = paraMap.get("job.kafkaJob.topic");
        LOGGER.info("KAFKA_SOURCE_READ_RECORD_SPEED = {}", (Object)this.recordSpeed);
        LOGGER.info("KAFKA_SOURCE_READ_BYTE_SPEED = {}", (Object)this.byteSpeed);
    }

    public Message read() {
        if (this.iterator != null && this.iterator.hasNext()) {
            ConsumerRecord<K, V> record = this.iterator.next();
            byte[] recordValue = (byte[])record.value();
            if (this.validateMessage(recordValue)) {
                AuditUtils.add((int)3, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)System.currentTimeMillis(), (int)1, (long)recordValue.length);
                HashMap<String, String> headerMap = new HashMap<String, String>();
                headerMap.put("record.offset", String.valueOf(record.offset()));
                headerMap.put("record.key", String.valueOf(record.key()));
                LOGGER.debug("partition:" + record.partition() + ", value:" + new String(recordValue) + ", offset:" + record.offset());
                this.readerMetric.pluginReadSuccessCount.incrementAndGet();
                this.readerMetric.pluginReadCount.incrementAndGet();
                this.snapshot = record.partition() + "#" + record.offset();
                DefaultMessage message = new DefaultMessage(recordValue, headerMap);
                this.recordReadLimit(1L, message.getBody().length);
                return message;
            }
        } else {
            if (this.isSourceExist()) {
                this.consumer.commitAsync();
            }
            this.fetchData(5000L);
        }
        AgentUtils.silenceSleepInMs((long)this.waitTimeout);
        return null;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public String getReadSource() {
        Set assignment = this.consumer.assignment();
        Iterator iterator = assignment.iterator();
        if (iterator.hasNext()) {
            TopicPartition topicPartition = (TopicPartition)iterator.next();
            return topicPartition.topic() + "_" + topicPartition.partition();
        }
        return "";
    }

    public void setReadTimeout(long millis) {
        this.timeout = millis;
    }

    public void setWaitMillisecond(long millis) {
        this.waitTimeout = millis;
    }

    @Override
    public void init(InstanceProfile jobConf) {
        super.init(jobConf);
        this.snapshot = jobConf.get("job.kafkaJob.partition.offset", null);
        this.initReadTimeout(jobConf);
        this.fetchData(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        KafkaReader kafkaReader = this;
        synchronized (kafkaReader) {
            if (!this.destroyed) {
                this.consumer.close();
                this.destroyed = true;
            }
        }
    }

    private void initReadTimeout(InstanceProfile jobConf) {
        int waitTime = jobConf.getInt(JOB_KAFKAJOB_READ_TIMEOUT, -1);
        this.timeout = waitTime == -1 ? -1L : TimeUnit.MINUTES.toMillis(waitTime);
    }

    private boolean validateMessage(byte[] message) {
        if (this.validators.isEmpty()) {
            return true;
        }
        return this.validators.stream().allMatch(v -> v.validate(new String(message)));
    }

    public void addPatternValidator(String pattern) {
        if (pattern.isEmpty()) {
            return;
        }
        this.validators.add(new PatternValidator(pattern));
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public void finishRead() {
        this.isFinished = true;
    }

    public boolean isSourceExist() {
        return !CollectionUtils.isEmpty((Collection)this.consumer.partitionsFor(this.topic));
    }

    private boolean fetchData(long fetchDataTimeout) {
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(fetchDataTimeout));
        this.iterator = records.iterator();
        return this.iterator != null;
    }

    private void recordReadLimit(long recordSize, long byteSize) {
        boolean isChannelRecordSpeedLimit;
        boolean isChannelByteSpeedLimit = this.byteSpeed > 0L;
        boolean bl = isChannelRecordSpeedLimit = this.recordSpeed > 0L;
        if (!isChannelByteSpeedLimit && !isChannelRecordSpeedLimit) {
            return;
        }
        currentTotalReadRecords.accumulateAndGet(recordSize, (x, y) -> x + y);
        currentTotalReadBytes.accumulateAndGet(byteSize, (x, y) -> x + y);
        long nowTimestamp = System.currentTimeMillis();
        long interval = nowTimestamp - this.lastTimestamp;
        if (interval - this.flowControlInterval >= 0L) {
            long sleepTime;
            long byteLimitSleepTime = 0L;
            long recordLimitSleepTime = 0L;
            if (isChannelByteSpeedLimit) {
                long currentByteSpeed = (currentTotalReadBytes.get() - lastTotalReadBytes.get()) * 1000L / interval;
                LOGGER.info("current produce byte speed bytes/s:{}", (Object)currentByteSpeed);
                if (currentByteSpeed > this.byteSpeed) {
                    byteLimitSleepTime = currentByteSpeed * interval / this.byteSpeed - interval;
                }
            }
            if (isChannelRecordSpeedLimit) {
                long currentRecordSpeed = (currentTotalReadRecords.get() - lastTotalReadRecords.get()) * 1000L / interval;
                LOGGER.info("current read speed records/s:{}", (Object)currentRecordSpeed);
                if (currentRecordSpeed > this.recordSpeed) {
                    recordLimitSleepTime = currentRecordSpeed * interval / this.recordSpeed - interval;
                }
            }
            long l = sleepTime = byteLimitSleepTime < recordLimitSleepTime ? recordLimitSleepTime : byteLimitSleepTime;
            if (sleepTime > 0L) {
                LOGGER.info("sleep seconds:{}", (Object)(sleepTime / 1000L));
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.lastTimestamp = nowTimestamp;
        lastTotalReadRecords = currentTotalReadRecords;
    }
}

