/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.core.task.file.MemoryManager;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.file.Reader;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.apache.inlong.agent.plugin.sources.file.extend.ExtendedHandler;
import org.apache.inlong.agent.plugin.sources.reader.file.KubernetesMetadataProvider;
import org.apache.inlong.agent.plugin.utils.file.FileDataUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogFileSource.class);
    private static final ThreadPoolExecutor EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("log-file-source"));
    private final Integer BATCH_READ_LINE_COUNT = 10000;
    private final Integer BATCH_READ_LINE_TOTAL_LEN = 0x100000;
    private final Integer CORE_THREAD_PRINT_INTERVAL_MS = 1000;
    private final Integer CACHE_QUEUE_SIZE = 10 * this.BATCH_READ_LINE_COUNT;
    private final Integer SIZE_OF_BUFFER_TO_READ_FILE = 65536;
    private final Integer EMPTY_CHECK_COUNT_AT_LEAST = 30;
    private final Long INODE_UPDATE_INTERVAL_MS = 1000L;
    private final Integer READ_WAIT_TIMEOUT_MS = 10;
    private final SimpleDateFormat RECORD_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public InstanceProfile profile;
    private String taskId;
    private String instanceId;
    private int maxPackSize;
    private String fileName;
    private File file;
    private byte[] bufferToReadFile;
    public volatile long linePosition = 0L;
    public volatile long bytePosition = 0L;
    private boolean needMetadata = false;
    public Map<String, String> metadata;
    private boolean isIncrement = false;
    private BlockingQueue<SourceData> queue;
    private final Gson GSON = new Gson();
    private volatile boolean runnable = true;
    private volatile boolean fileExist = true;
    private String inodeInfo;
    private volatile long lastInodeUpdateTime = 0L;
    private volatile boolean running = false;
    private long dataTime = 0L;
    private volatile long emptyCount = 0L;
    private ExtendedHandler extendedHandler;
    private boolean isRealTime = false;

    @Override
    public void init(InstanceProfile profile) {
        try {
            LOGGER.info("LogFileSource init: {}", (Object)profile.toJsonStr());
            this.profile = profile;
            super.init(profile);
            String cycleUnit = profile.get("task.fileTask.cycleUnit");
            if (cycleUnit.compareToIgnoreCase("R") == 0) {
                this.isRealTime = true;
                cycleUnit = "h";
            }
            this.taskId = profile.getTaskId();
            this.instanceId = profile.getInstanceId();
            this.fileName = profile.getInstanceId();
            this.maxPackSize = profile.getInt("proxy.package.maxSize", 512000);
            this.bufferToReadFile = new byte[this.SIZE_OF_BUFFER_TO_READ_FILE.intValue()];
            this.isIncrement = this.isIncrement(profile);
            this.file = new File(this.fileName);
            this.inodeInfo = profile.get("inodeInfo");
            this.lastInodeUpdateTime = AgentUtils.getCurrentTime();
            this.linePosition = this.getInitLineOffset(this.isIncrement, this.taskId, this.instanceId, this.inodeInfo);
            this.bytePosition = this.getBytePositionByLine(this.linePosition);
            this.queue = new LinkedBlockingQueue<SourceData>(this.CACHE_QUEUE_SIZE);
            this.dataTime = DateTransUtils.timeStrConvertToMillSec((String)profile.getSourceDataTime(), (String)cycleUnit);
            if ("org.apache.inlong.agent.plugin.sources.file.extend.ExtendedHandler".compareTo(ExtendedHandler.class.getCanonicalName()) != 0) {
                Constructor<?> constructor = Class.forName(profile.get("task.fileTask.extendedClass", "org.apache.inlong.agent.plugin.sources.file.extend.ExtendedHandler")).getDeclaredConstructor(InstanceProfile.class);
                constructor.setAccessible(true);
                this.extendedHandler = (ExtendedHandler)constructor.newInstance(profile);
            }
            try {
                this.registerMeta(profile);
            }
            catch (Exception ex) {
                LOGGER.error("init metadata error", (Throwable)ex);
            }
            EXECUTOR_SERVICE.execute(this.coreThread());
        }
        catch (Exception ex) {
            this.stopRunning();
            throw new FileException("error init stream for " + this.file.getPath(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getRealLineCount(String fileName) {
        try (LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.instanceId));){
            lineNumberReader.skip(Long.MAX_VALUE);
            int n = lineNumberReader.getLineNumber();
            return n;
        }
        catch (IOException ex) {
            LOGGER.error("getRealLineCount error {} file {}", (Object)ex.getMessage(), (Object)fileName);
            return 0;
        }
    }

    private long getInitLineOffset(boolean isIncrement, String taskId, String instanceId, String inodeInfo) {
        OffsetProfile offsetProfile = OffsetManager.getInstance().getOffset(taskId, instanceId);
        int fileLineCount = this.getRealLineCount(instanceId);
        long offset = 0L;
        if (offsetProfile != null && offsetProfile.getInodeInfo().compareTo(inodeInfo) == 0) {
            offset = offsetProfile.getOffset();
            if ((long)fileLineCount < offset) {
                LOGGER.info("getInitLineOffset inode no change taskId {} file rotate, offset set to 0, file {}", (Object)taskId, (Object)this.fileName);
                offset = 0L;
            } else {
                LOGGER.info("getInitLineOffset inode no change taskId {} from db {}, file {}", new Object[]{taskId, offset, this.fileName});
            }
        } else if (isIncrement) {
            offset = this.getRealLineCount(instanceId);
            LOGGER.info("getInitLineOffset taskId {} for new increment read from {} file {}", new Object[]{taskId, offset, this.fileName});
        } else {
            offset = 0L;
            LOGGER.info("getInitLineOffset taskId {} for new all read from 0 file {}", (Object)taskId, (Object)this.fileName);
        }
        return offset;
    }

    public File getFile() {
        return this.file;
    }

    public void registerMeta(InstanceProfile jobConf) {
        if (!jobConf.hasKey("job.fileTask.envList")) {
            return;
        }
        String[] env = jobConf.get("job.fileTask.envList").split(",");
        Arrays.stream(env).forEach(data -> {
            if (data.equalsIgnoreCase("kubernetes")) {
                this.needMetadata = true;
                new KubernetesMetadataProvider(this).getData();
            } else if (data.equalsIgnoreCase("cvm")) {
                this.needMetadata = true;
                this.metadata.put("__HostName__", AgentUtils.getLocalHost());
                this.metadata.put("__SourceIP__", AgentUtils.fetchLocalIp());
                this.metadata.put("__FileName__", this.file.getName());
            }
        });
    }

    private boolean isIncrement(InstanceProfile profile) {
        return profile.hasKey("job.fileTask.contentCollectType") && "INCREMENT".equalsIgnoreCase(profile.get("job.fileTask.contentCollectType"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getBytePositionByLine(long linePosition) throws IOException {
        long pos = 0L;
        try (RandomAccessFile input = null;){
            ArrayList<String> lines;
            input = new RandomAccessFile(this.file, "r");
            for (long readCount = 0L; readCount < linePosition; readCount += (long)lines.size()) {
                lines = new ArrayList<String>();
                pos = this.readLines(input, pos, lines, Math.min((int)(linePosition - readCount), this.BATCH_READ_LINE_COUNT), this.BATCH_READ_LINE_TOTAL_LEN, true);
                if (lines.size() != 0) continue;
                LOGGER.error("getBytePositionByLine LineNum {} larger than the real file");
                break;
            }
        }
        LOGGER.info("getBytePositionByLine {} LineNum {} position {}", new Object[]{this.fileName, linePosition, pos});
        return pos;
    }

    private long readLines(RandomAccessFile reader, long pos, List<String> lines, int maxLineCount, int maxLineTotalLen, boolean isCounting) throws IOException {
        int num;
        if (maxLineCount == 0) {
            return pos;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        reader.seek(pos);
        long rePos = pos;
        int lineTotalLen = 0;
        boolean overLen = false;
        while ((num = reader.read(this.bufferToReadFile)) != -1) {
            int i;
            LOGGER.debug("read size {}", (Object)num);
            for (i = 0; i < num; ++i) {
                byte ch = this.bufferToReadFile[i];
                switch (ch) {
                    case 10: {
                        if (isCounting) {
                            lines.add(new String(""));
                        } else {
                            String temp = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                            lines.add(temp);
                            lineTotalLen += temp.length();
                        }
                        rePos = pos + (long)i + 1L;
                        if (overLen) {
                            LOGGER.warn("readLines over len finally string len {}", (Object)new String(baos.toByteArray()).length());
                            AuditUtils.add((int)30001, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)AgentUtils.getCurrentTime(), (int)1, (long)this.maxPackSize);
                        }
                        baos.reset();
                        overLen = false;
                        break;
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        if (baos.size() < this.maxPackSize) {
                            baos.write(ch);
                            break;
                        }
                        overLen = true;
                    }
                }
                if (lines.size() >= maxLineCount || lineTotalLen >= maxLineTotalLen) break;
            }
            if (lines.size() >= maxLineCount || lineTotalLen >= maxLineTotalLen) break;
            if (i != num) continue;
            pos = reader.getFilePointer();
        }
        baos.close();
        reader.seek(rePos);
        return rePos;
    }

    public Message read() {
        SourceData sourceData = null;
        try {
            sourceData = this.queue.poll(this.READ_WAIT_TIMEOUT_MS.intValue(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("poll {} data get interrupted.", (Object)this.file.getPath(), (Object)e);
        }
        if (sourceData == null) {
            return null;
        }
        MemoryManager.getInstance().release("agent.global.reader.queue.permit", sourceData.data.length());
        Message finalMsg = this.createMessage(sourceData);
        return finalMsg;
    }

    private Message createMessage(SourceData sourceData) {
        String msgWithMetaData = this.fillMetaData(sourceData.data);
        String proxyPartitionKey = this.profile.get("proxy.partitionKey", DigestUtils.md5Hex((String)this.inlongGroupId));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("dataKey", proxyPartitionKey);
        header.put("offset", sourceData.offset.toString());
        header.put("inlongStreamId", this.inlongStreamId);
        if (this.extendedHandler != null) {
            this.extendedHandler.dealWithHeader(header, sourceData.getData().getBytes(StandardCharsets.UTF_8));
        }
        long auditTime = 0L;
        auditTime = this.isRealTime ? AgentUtils.getCurrentTime() : this.profile.getSinkDataTime();
        AuditUtils.add((int)3, (String)this.inlongGroupId, (String)((String)header.get("inlongStreamId")), (long)auditTime, (int)1, (long)msgWithMetaData.length());
        AuditUtils.add((int)30001, (String)this.inlongGroupId, (String)((String)header.get("inlongStreamId")), (long)AgentUtils.getCurrentTime(), (int)1, (long)msgWithMetaData.length());
        DefaultMessage finalMsg = new DefaultMessage(msgWithMetaData.getBytes(StandardCharsets.UTF_8), header);
        if (finalMsg.getBody().length > this.maxPackSize) {
            LOGGER.warn("message size is {}, greater than max pack size {}, drop it!", (Object)finalMsg.getBody().length, (Object)this.maxPackSize);
            return null;
        }
        return finalMsg;
    }

    public String fillMetaData(String message) {
        if (!this.needMetadata) {
            return message;
        }
        long timestamp = System.currentTimeMillis();
        boolean isJson = FileDataUtils.isJSON(message);
        HashMap<String, String> mergeData = new HashMap<String, String>(this.metadata);
        mergeData.put("__content__", FileDataUtils.getK8sJsonLog(message, isJson));
        mergeData.put("__LogTime__", this.RECORD_TIME_FORMAT.format(new Date(timestamp)));
        return this.GSON.toJson(mergeData);
    }

    private boolean waitForPermit(String permitName, int permitLen) {
        boolean suc = false;
        while (!suc) {
            suc = MemoryManager.getInstance().tryAcquire(permitName, permitLen);
            if (suc) continue;
            MemoryManager.getInstance().printDetail(permitName, "log file source");
            if (this.isInodeChanged() || !this.isRunnable()) {
                return false;
            }
            AgentUtils.silenceSleepInSeconds((long)1L);
        }
        return true;
    }

    private boolean isInodeChanged() {
        if (AgentUtils.getCurrentTime() - this.lastInodeUpdateTime > this.INODE_UPDATE_INTERVAL_MS) {
            try {
                return FileDataUtils.getInodeInfo(this.fileName).compareTo(this.inodeInfo) != 0;
            }
            catch (IOException e) {
                LOGGER.error("check inode change file {} error {}", (Object)this.fileName, (Object)e.getMessage());
                return true;
            }
        }
        return false;
    }

    public Runnable coreThread() {
        return () -> {
            AgentThreadFactory.nameThread((String)("log-file-source-" + this.taskId + "-" + this.file));
            this.running = true;
            long lastPrintTime = 0L;
            while (this.isRunnable() && this.fileExist) {
                boolean suc4Queue;
                if (this.isInodeChanged()) {
                    this.fileExist = false;
                    LOGGER.info("inode changed, instance will restart and offset will be clean, file {}", (Object)this.fileName);
                    break;
                }
                if (this.file.length() < this.bytePosition) {
                    this.fileExist = false;
                    LOGGER.info("file rotate, instance will restart and offset will be clean, file {}", (Object)this.fileName);
                    break;
                }
                boolean suc = this.waitForPermit("agent.global.reader.source.permit", this.BATCH_READ_LINE_TOTAL_LEN);
                if (!suc) break;
                List<SourceData> lines = null;
                try {
                    lines = this.readFromPos(this.bytePosition);
                }
                catch (FileNotFoundException e) {
                    this.fileExist = false;
                    LOGGER.error("readFromPos file deleted {}", (Object)e.getMessage());
                }
                catch (IOException e) {
                    LOGGER.error("readFromPos error {}", (Object)e.getMessage());
                }
                MemoryManager.getInstance().release("agent.global.reader.source.permit", this.BATCH_READ_LINE_TOTAL_LEN.intValue());
                if (lines.isEmpty()) {
                    this.emptyCount = this.queue.isEmpty() ? ++this.emptyCount : 0L;
                    AgentUtils.silenceSleepInSeconds((long)1L);
                    continue;
                }
                this.emptyCount = 0L;
                for (int i = 0; i < lines.size() && (suc4Queue = this.waitForPermit("agent.global.reader.queue.permit", lines.get(i).data.length())); ++i) {
                    this.putIntoQueue(lines.get(i));
                }
                if (AgentUtils.getCurrentTime() - lastPrintTime <= (long)this.CORE_THREAD_PRINT_INTERVAL_MS.intValue()) continue;
                lastPrintTime = AgentUtils.getCurrentTime();
                LOGGER.info("path is {}, linePosition {}, bytePosition is {} file len {}, reads lines size {}", new Object[]{this.file.getName(), this.linePosition, this.bytePosition, this.file.length(), lines.size()});
            }
            this.running = false;
        };
    }

    private void putIntoQueue(SourceData sourceData) {
        if (sourceData == null) {
            return;
        }
        try {
            boolean offerSuc = false;
            while (this.isRunnable() && !offerSuc) {
                offerSuc = this.queue.offer(sourceData, 1L, TimeUnit.SECONDS);
            }
            if (!offerSuc) {
                MemoryManager.getInstance().release("agent.global.reader.queue.permit", sourceData.data.length());
            }
            LOGGER.debug("Read {} from file {}", (Object)sourceData.getData(), (Object)this.fileName);
        }
        catch (InterruptedException e) {
            MemoryManager.getInstance().release("agent.global.reader.queue.permit", sourceData.data.length());
            LOGGER.error("fetchData offer failed {}", (Object)e.getMessage());
        }
    }

    public boolean isRunnable() {
        return this.runnable;
    }

    public void stopRunning() {
        this.runnable = false;
    }

    private List<SourceData> readFromPos(long pos) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<SourceData> dataList = new ArrayList<SourceData>();
        RandomAccessFile input = new RandomAccessFile(this.file, "r");
        this.bytePosition = this.readLines(input, pos, lines, this.BATCH_READ_LINE_COUNT, this.BATCH_READ_LINE_TOTAL_LEN, false);
        for (int i = 0; i < lines.size(); ++i) {
            ++this.linePosition;
            dataList.add(new SourceData((String)lines.get(i), this.linePosition));
        }
        if (input != null) {
            input.close();
        }
        return dataList;
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy read source name {}", (Object)this.fileName);
        this.stopRunning();
        while (this.running) {
            AgentUtils.silenceSleepInMs((long)1L);
        }
        this.clearQueue(this.queue);
        LOGGER.info("destroy read source name {} end", (Object)this.fileName);
    }

    private void clearQueue(BlockingQueue<SourceData> queue) {
        if (queue == null) {
            return;
        }
        while (queue != null && !queue.isEmpty()) {
            SourceData sourceData = null;
            try {
                sourceData = queue.poll(this.READ_WAIT_TIMEOUT_MS.intValue(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.warn("poll {} data get interrupted.", (Object)this.file.getPath(), (Object)e);
            }
            if (sourceData == null) continue;
            MemoryManager.getInstance().release("agent.global.reader.queue.permit", sourceData.data.length());
        }
        queue.clear();
    }

    public boolean sourceFinish() {
        if (this.isRealTime) {
            return false;
        }
        return this.emptyCount > (long)this.EMPTY_CHECK_COUNT_AT_LEAST.intValue();
    }

    public boolean sourceExist() {
        return this.fileExist;
    }

    public List<Reader> split(TaskProfile jobConf) {
        return null;
    }

    private class SourceData {
        private String data;
        private Long offset;

        public String getData() {
            return this.data;
        }

        public Long getOffset() {
            return this.offset;
        }

        public void setData(String data) {
            this.data = data;
        }

        public void setOffset(Long offset) {
            this.offset = offset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceData)) {
                return false;
            }
            SourceData other = (SourceData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$offset = this.getOffset();
            Long other$offset = other.getOffset();
            if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SourceData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "LogFileSource.SourceData(data=" + this.getData() + ", offset=" + this.getOffset() + ")";
        }

        public SourceData(String data, Long offset) {
            this.data = data;
            this.offset = offset;
        }

        public SourceData() {
        }
    }
}

