/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sinks.filecollect;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.constant.CommonConstants;
import org.apache.inlong.agent.message.filecollect.SenderMessage;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.agent.metrics.AgentMetricItemSet;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.message.SequentialID;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.apache.inlong.sdk.dataproxy.DefaultMessageSender;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.common.SendMessageCallback;
import org.apache.inlong.sdk.dataproxy.common.SendResult;
import org.apache.inlong.sdk.dataproxy.network.ProxysdkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderManager.class);
    private static final SequentialID SEQUENTIAL_ID = SequentialID.getInstance();
    private DefaultMessageSender sender;
    private LinkedBlockingQueue<AgentSenderCallback> resendQueue;
    private static final ThreadPoolExecutor EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("sender-manager"));
    private ThreadFactory SHARED_FACTORY;
    private static final AtomicLong METRIC_INDEX = new AtomicLong(0L);
    private final String managerHost;
    private final int managerPort;
    private final String netTag;
    private final String localhost;
    private final boolean isLocalVisit;
    private final int totalAsyncBufSize;
    private final int aliveConnectionNum;
    private final boolean isCompress;
    private final int msgType;
    private final boolean isFile;
    private final long maxSenderTimeout;
    private final int maxSenderRetry;
    private final long retrySleepTime;
    private final String inlongGroupId;
    private final int maxSenderPerGroup;
    private final String sourcePath;
    private final boolean proxySend;
    private volatile boolean shutdown = false;
    private AgentMetricItemSet metricItemSet;
    private Map<String, String> dimensions;
    private int ioThreadNum;
    private boolean enableBusyWait;
    private String authSecretId;
    private String authSecretKey;
    protected int batchFlushInterval;
    protected InstanceProfile profile;
    private volatile boolean resendRunning = false;
    private volatile boolean started = false;

    public SenderManager(InstanceProfile profile, String inlongGroupId, String sourcePath) {
        AgentConfiguration conf = AgentConfiguration.getAgentConf();
        this.profile = profile;
        this.managerHost = conf.get("agent.manager.vip.http.host");
        this.managerPort = conf.getInt("agent.manager.vip.http.port");
        this.proxySend = profile.getBoolean("job.proxySend", false);
        this.localhost = profile.get("proxy.localHost", CommonConstants.DEFAULT_PROXY_LOCALHOST);
        this.netTag = profile.get("proxy.net.tag", "");
        this.isLocalVisit = profile.getBoolean("proxy.isLocalVisit", true);
        this.totalAsyncBufSize = profile.getInt("proxy.total.async.proxy.size", 0xC800000);
        this.aliveConnectionNum = profile.getInt("proxy.alive.connection.num", 10);
        this.isCompress = profile.getBoolean("proxy.is.compress", true);
        this.maxSenderPerGroup = profile.getInt("proxy.max.sender.per.group", 10);
        this.msgType = profile.getInt("proxy.msgType", 7);
        this.maxSenderTimeout = profile.getInt("proxy.sender.maxTimeout", 20);
        this.maxSenderRetry = profile.getInt("proxy.sender.maxRetry", 5);
        this.retrySleepTime = profile.getLong("proxy.retry.sleep", 500L);
        this.isFile = profile.getBoolean("proxy.isFile", false);
        this.ioThreadNum = profile.getInt("client.iothread.num", CommonConstants.DEFAULT_PROXY_CLIENT_IO_THREAD_NUM);
        this.enableBusyWait = profile.getBoolean("client.enable.busy.wait", false);
        this.batchFlushInterval = profile.getInt("proxy.batch.flush.interval", 100);
        this.authSecretId = conf.get("agent.manager.auth.secretId");
        this.authSecretKey = conf.get("agent.manager.auth.secretKey");
        this.sourcePath = sourcePath;
        this.inlongGroupId = inlongGroupId;
        this.dimensions = new HashMap<String, String>();
        this.dimensions.put("pluginId", this.getClass().getSimpleName());
        String metricName = String.join((CharSequence)"-", this.getClass().getSimpleName(), String.valueOf(METRIC_INDEX.incrementAndGet()));
        this.metricItemSet = new AgentMetricItemSet(metricName);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
        this.resendQueue = new LinkedBlockingQueue();
    }

    public void Start() throws Exception {
        this.createMessageSender(this.inlongGroupId);
        EXECUTOR_SERVICE.execute(this.flushResendQueue());
        this.started = true;
    }

    public void Stop() {
        LOGGER.info("stop send manager");
        this.shutdown = true;
        if (!this.started) {
            return;
        }
        while (this.resendRunning) {
            AgentUtils.silenceSleepInMs((long)1L);
        }
        this.closeMessageSender();
        LOGGER.info("stop send manager end");
    }

    private void closeMessageSender() {
        if (this.sender != null) {
            this.sender.close();
        }
    }

    private AgentMetricItem getMetricItem(Map<String, String> otherDimensions) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("pluginId", this.getClass().getSimpleName());
        dimensions.putAll(otherDimensions);
        return (AgentMetricItem)this.metricItemSet.findMetricItem(dimensions);
    }

    private AgentMetricItem getMetricItem(String groupId, String streamId) {
        HashMap<String, String> dims = new HashMap<String, String>();
        dims.put("inlongGroupId", groupId);
        dims.put("inlongStreamId", streamId);
        return this.getMetricItem(dims);
    }

    private void createMessageSender(String tagName) throws Exception {
        ProxyClientConfig proxyClientConfig = new ProxyClientConfig(this.localhost, this.isLocalVisit, this.managerHost, this.managerPort, tagName, this.authSecretId, this.authSecretKey);
        proxyClientConfig.setTotalAsyncCallbackSize(this.totalAsyncBufSize);
        proxyClientConfig.setFile(this.isFile);
        proxyClientConfig.setAliveConnections(this.aliveConnectionNum);
        proxyClientConfig.setIoThreadNum(this.ioThreadNum);
        proxyClientConfig.setEnableBusyWait(this.enableBusyWait);
        proxyClientConfig.setProtocolType("TCP");
        this.SHARED_FACTORY = new DefaultThreadFactory("agent-sender-manager-" + this.sourcePath, Thread.currentThread().isDaemon());
        DefaultMessageSender sender = new DefaultMessageSender(proxyClientConfig, this.SHARED_FACTORY);
        sender.setMsgtype(this.msgType);
        sender.setCompress(this.isCompress);
        this.sender = sender;
    }

    public void sendBatch(SenderMessage message) {
        while (!this.shutdown && !this.resendQueue.isEmpty()) {
            AgentUtils.silenceSleepInMs((long)this.retrySleepTime);
        }
        if (!this.shutdown) {
            this.sendBatchWithRetryCount(message, 0);
        }
    }

    private void sendBatchWithRetryCount(SenderMessage message, int retry) {
        boolean suc = false;
        while (!suc) {
            try {
                AgentSenderCallback cb = new AgentSenderCallback(message, retry);
                this.asyncSendByMessageSender(cb, message.getDataList(), message.getGroupId(), message.getStreamId(), message.getDataTime(), SEQUENTIAL_ID.getNextUuid(), this.maxSenderTimeout, TimeUnit.SECONDS, message.getExtraMap(), this.proxySend);
                this.getMetricItem((String)message.getGroupId(), (String)message.getStreamId()).pluginSendCount.addAndGet(message.getMsgCnt());
                suc = true;
            }
            catch (Exception exception) {
                suc = false;
                if (retry > this.maxSenderRetry) {
                    if (retry % 10 == 0) {
                        LOGGER.error("max retry reached, sample log Exception caught", (Throwable)exception);
                    }
                } else {
                    LOGGER.error("Exception caught", (Throwable)exception);
                }
                ++retry;
                AgentUtils.silenceSleepInMs((long)this.retrySleepTime);
            }
        }
    }

    private void asyncSendByMessageSender(SendMessageCallback cb, List<byte[]> bodyList, String groupId, String streamId, long dataTime, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap, boolean isProxySend) throws ProxysdkException {
        this.sender.asyncSendMessage(cb, bodyList, groupId, streamId, dataTime, msgUUID, timeout, timeUnit, extraAttrMap, isProxySend);
    }

    private Runnable flushResendQueue() {
        return () -> {
            AgentThreadFactory.nameThread((String)("flushResendQueue-" + this.profile.getTaskId() + "-" + this.profile.getInstanceId()));
            LOGGER.info("start flush resend queue {}:{}", (Object)this.inlongGroupId, (Object)this.sourcePath);
            this.resendRunning = true;
            while (!this.shutdown) {
                try {
                    AgentSenderCallback callback = this.resendQueue.poll(1L, TimeUnit.SECONDS);
                    if (callback == null) continue;
                    this.sendBatchWithRetryCount(callback.message, callback.retry + 1);
                }
                catch (Exception ex) {
                    LOGGER.error("error caught", (Throwable)ex);
                }
                catch (Throwable t) {
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)t);
                }
                finally {
                    AgentUtils.silenceSleepInMs((long)this.batchFlushInterval);
                }
            }
            LOGGER.info("stop flush resend queue {}:{}", (Object)this.inlongGroupId, (Object)this.sourcePath);
            this.resendRunning = false;
        };
    }

    private void putInResendQueue(AgentSenderCallback batchMessageCallBack) {
        try {
            this.resendQueue.put(batchMessageCallBack);
        }
        catch (Throwable throwable) {
            LOGGER.error("putInResendQueue e = {}", throwable);
        }
    }

    public boolean sendFinished() {
        return true;
    }

    private class AgentSenderCallback
    implements SendMessageCallback {
        private final int retry;
        private final SenderMessage message;
        private final int msgCnt;

        AgentSenderCallback(SenderMessage message, int retry) {
            this.message = message;
            this.retry = retry;
            this.msgCnt = message.getDataList().size();
        }

        public void onMessageAck(SendResult result) {
            String groupId = this.message.getGroupId();
            String streamId = this.message.getStreamId();
            String taskId = this.message.getTaskId();
            String instanceId = this.message.getInstanceId();
            long dataTime = this.message.getDataTime();
            if (result != null && result.equals((Object)SendResult.OK)) {
                this.message.getOffsetAckList().forEach(ack -> ack.setHasAck(Boolean.valueOf(true)));
                ((SenderManager)SenderManager.this).getMetricItem((String)groupId, (String)streamId).pluginSendSuccessCount.addAndGet(this.msgCnt);
                AuditUtils.add((int)4, (String)groupId, (String)streamId, (long)dataTime, (int)this.message.getMsgCnt(), (long)this.message.getTotalSize());
                AuditUtils.add((int)30002, (String)groupId, (String)streamId, (long)AgentUtils.getCurrentTime(), (int)this.message.getMsgCnt(), (long)this.message.getTotalSize());
            } else {
                LOGGER.warn("send groupId {}, streamId {}, taskId {}, instanceId {}, dataTime {} fail with times {}, error {}", new Object[]{groupId, streamId, taskId, instanceId, dataTime, this.retry, result});
                ((SenderManager)SenderManager.this).getMetricItem((String)groupId, (String)streamId).pluginSendFailCount.addAndGet(this.msgCnt);
                SenderManager.this.putInResendQueue(new AgentSenderCallback(this.message, this.retry));
                AuditUtils.add((int)10004, (String)groupId, (String)streamId, (long)dataTime, (int)this.message.getMsgCnt(), (long)this.message.getTotalSize());
                AuditUtils.add((int)30011, (String)groupId, (String)streamId, (long)AgentUtils.getCurrentTime(), (int)this.message.getMsgCnt(), (long)this.message.getTotalSize());
            }
        }

        public void onException(Throwable e) {
            ((SenderManager)SenderManager.this).getMetricItem((String)this.message.getGroupId(), (String)this.message.getStreamId()).pluginSendFailCount.addAndGet(this.msgCnt);
            LOGGER.error("exception caught", e);
        }
    }
}

