/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sinks.filecollect;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.core.task.file.MemoryManager;
import org.apache.inlong.agent.message.EndMessage;
import org.apache.inlong.agent.message.filecollect.OffsetAckInfo;
import org.apache.inlong.agent.message.filecollect.ProxyMessage;
import org.apache.inlong.agent.message.filecollect.SenderMessage;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.MessageFilter;
import org.apache.inlong.agent.plugin.sinks.filecollect.AbstractSink;
import org.apache.inlong.agent.plugin.sinks.filecollect.SenderManager;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySink
extends AbstractSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxySink.class);
    private final int WRITE_FAILED_WAIT_TIME_MS = 10;
    private final int DESTROY_LOOP_WAIT_TIME_MS = 10;
    public final int SAVE_OFFSET_INTERVAL_MS = 1000;
    private static final ThreadPoolExecutor EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("proxy-sink"));
    private MessageFilter messageFilter;
    private SenderManager senderManager;
    private byte[] fieldSplitter;
    private volatile boolean shutdown = false;
    private volatile boolean running = false;
    private volatile boolean inited = false;
    private long lastPrintTime = 0L;
    private List<OffsetAckInfo> ackInfoList = new ArrayList<OffsetAckInfo>();
    private final ReentrantReadWriteLock packageAckInfoLock = new ReentrantReadWriteLock(true);
    private volatile boolean offsetRunning = false;
    private OffsetManager offsetManager;

    public void write(Message message) {
        boolean suc = false;
        while (!this.shutdown && !suc) {
            suc = this.putInCache(message);
            if (suc) continue;
            AgentUtils.silenceSleepInMs((long)10L);
        }
    }

    private boolean putInCache(Message message) {
        try {
            if (message == null) {
                return true;
            }
            this.extractStreamFromMessage(message, this.fieldSplitter);
            if (message instanceof EndMessage) {
                this.sinkMetric.sinkFailCount.incrementAndGet();
                return true;
            }
            ProxyMessage proxyMessage = new ProxyMessage(message);
            boolean writerPermitSuc = MemoryManager.getInstance().tryAcquire("agent.global.writer.permit", message.getBody().length);
            if (!writerPermitSuc) {
                MemoryManager.getInstance().printDetail("agent.global.writer.permit", "proxy sink");
                return false;
            }
            this.cache.generateExtraMap(proxyMessage.getDataKey());
            boolean suc = this.cache.add(proxyMessage);
            if (suc) {
                this.addAckInfo(proxyMessage.getAckInfo());
            } else {
                MemoryManager.getInstance().release("agent.global.writer.permit", message.getBody().length);
                this.sinkMetric.sinkFailCount.incrementAndGet();
            }
            return suc;
        }
        catch (Exception e) {
            LOGGER.error("write message to Proxy sink error", (Throwable)e);
        }
        catch (Throwable t) {
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)t);
        }
        return false;
    }

    private void extractStreamFromMessage(Message message, byte[] fieldSplitter) {
        if (this.messageFilter != null) {
            message.getHeader().put("inlongStreamId", this.messageFilter.filterStreamId(message, fieldSplitter));
        }
    }

    private Runnable coreThread() {
        return () -> {
            AgentThreadFactory.nameThread((String)("flushCache-" + this.profile.getTaskId() + "-" + this.profile.getInstanceId()));
            LOGGER.info("start flush cache {}:{}", (Object)this.inlongGroupId, (Object)this.sourceName);
            this.running = true;
            while (!this.shutdown) {
                this.sendMessageFromCache();
                AgentUtils.silenceSleepInMs((long)this.batchFlushInterval);
            }
            LOGGER.info("stop flush cache {}:{}", (Object)this.inlongGroupId, (Object)this.sourceName);
            this.running = false;
        };
    }

    public void sendMessageFromCache() {
        ConcurrentHashMap messageQueueMap = this.cache.getMessageQueueMap();
        for (Map.Entry entry : messageQueueMap.entrySet()) {
            SenderMessage senderMessage = this.cache.fetchSenderMessage((String)entry.getKey(), (LinkedBlockingQueue)entry.getValue());
            if (senderMessage == null) continue;
            this.senderManager.sendBatch(senderMessage);
            if (AgentUtils.getCurrentTime() - this.lastPrintTime <= TimeUnit.SECONDS.toMillis(1L)) continue;
            this.lastPrintTime = AgentUtils.getCurrentTime();
            LOGGER.info("send groupId {}, streamId {}, message size {}, taskId {}, instanceId {} sendTime is {}", new Object[]{this.inlongGroupId, this.inlongStreamId, senderMessage.getDataList().size(), this.profile.getTaskId(), this.profile.getInstanceId(), senderMessage.getDataTime()});
        }
    }

    @Override
    public void init(InstanceProfile profile) {
        super.init(profile);
        this.fieldSplitter = profile.get("proxy.field.splitter", "|").getBytes(StandardCharsets.UTF_8);
        this.sourceName = profile.getInstanceId();
        this.offsetManager = OffsetManager.getInstance();
        this.senderManager = new SenderManager(profile, this.inlongGroupId, this.sourceName);
        try {
            this.senderManager.Start();
            EXECUTOR_SERVICE.execute(this.coreThread());
            EXECUTOR_SERVICE.execute(this.flushOffset());
            this.inited = true;
        }
        catch (Throwable ex) {
            this.shutdown = true;
            LOGGER.error("error while init sender for group id {}", (Object)this.inlongGroupId);
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    public void destroy() {
        LOGGER.info("destroy sink {}", (Object)this.sourceName);
        if (!this.inited) {
            return;
        }
        this.shutdown = true;
        while (this.running || this.offsetRunning) {
            AgentUtils.silenceSleepInMs((long)10L);
        }
        this.senderManager.Stop();
        this.clearOffset();
        LOGGER.info("destroy sink {} end", (Object)this.sourceName);
    }

    public boolean sinkFinish() {
        boolean finished = false;
        this.packageAckInfoLock.writeLock().lock();
        if (this.ackInfoList.isEmpty()) {
            finished = true;
        }
        this.packageAckInfoLock.writeLock().unlock();
        return finished;
    }

    private void addAckInfo(OffsetAckInfo info) {
        this.packageAckInfoLock.writeLock().lock();
        this.ackInfoList.add(info);
        this.packageAckInfoLock.writeLock().unlock();
    }

    private Runnable flushOffset() {
        return () -> {
            AgentThreadFactory.nameThread((String)("flushOffset-" + this.profile.getTaskId() + "-" + this.profile.getInstanceId()));
            LOGGER.info("start flush offset {}:{}", (Object)this.inlongGroupId, (Object)this.sourceName);
            this.offsetRunning = true;
            while (!this.shutdown) {
                this.doFlushOffset();
                AgentUtils.silenceSleepInMs((long)1000L);
            }
            LOGGER.info("stop flush offset {}:{}", (Object)this.inlongGroupId, (Object)this.sourceName);
            this.offsetRunning = false;
        };
    }

    private void doFlushOffset() {
        this.packageAckInfoLock.writeLock().lock();
        OffsetAckInfo info = null;
        int i = 0;
        while (i < this.ackInfoList.size() && this.ackInfoList.get(i).getHasAck().booleanValue()) {
            info = this.ackInfoList.remove(i);
            MemoryManager.getInstance().release("agent.global.writer.permit", info.getLen());
        }
        if (info != null) {
            LOGGER.info("save offset {} taskId {} instanceId {}", new Object[]{info.getOffset(), this.profile.getTaskId(), this.profile.getInstanceId()});
            OffsetProfile offsetProfile = new OffsetProfile(this.profile.getTaskId(), this.profile.getInstanceId(), info.getOffset().longValue(), this.profile.get("inodeInfo"));
            this.offsetManager.setOffset(offsetProfile);
        }
        this.packageAckInfoLock.writeLock().unlock();
    }

    private void clearOffset() {
        this.packageAckInfoLock.writeLock().lock();
        int i = 0;
        while (i < this.ackInfoList.size()) {
            MemoryManager.getInstance().release("agent.global.writer.permit", this.ackInfoList.remove(i).getLen());
        }
        this.packageAckInfoLock.writeLock().unlock();
    }
}

