/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sinks;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.constant.CommonConstants;
import org.apache.inlong.agent.core.task.PositionManager;
import org.apache.inlong.agent.message.BatchProxyMessage;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.agent.metrics.AgentMetricItemSet;
import org.apache.inlong.agent.plugin.message.SequentialID;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.apache.inlong.sdk.dataproxy.DefaultMessageSender;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.common.SendMessageCallback;
import org.apache.inlong.sdk.dataproxy.common.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderManager.class);
    private static final SequentialID SEQUENTIAL_ID = SequentialID.getInstance();
    private final AtomicInteger SENDER_INDEX = new AtomicInteger(0);
    private DefaultMessageSender sender;
    private LinkedBlockingQueue<AgentSenderCallback> resendQueue;
    private final ExecutorService resendExecutorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("SendManager-Resend"));
    private ThreadFactory SHARED_FACTORY;
    private static final AtomicLong METRIC_INDEX = new AtomicLong(0L);
    private final String managerHost;
    private final int managerPort;
    private final String netTag;
    private final String localhost;
    private final boolean isLocalVisit;
    private final int totalAsyncBufSize;
    private final int aliveConnectionNum;
    private final boolean isCompress;
    private final int msgType;
    private final boolean isFile;
    private final long maxSenderTimeout;
    private final int maxSenderRetry;
    private final long retrySleepTime;
    private final String inlongGroupId;
    private final int maxSenderPerGroup;
    private final String sourcePath;
    private final boolean proxySend;
    private volatile boolean shutdown = false;
    private AgentMetricItemSet metricItemSet;
    private Map<String, String> dimensions;
    private PositionManager positionManager;
    private int ioThreadNum;
    private boolean enableBusyWait;
    private String authSecretId;
    private String authSecretKey;
    protected int batchFlushInterval;

    public SenderManager(JobProfile jobConf, String inlongGroupId, String sourcePath) {
        AgentConfiguration conf = AgentConfiguration.getAgentConf();
        this.managerHost = conf.get("agent.manager.vip.http.host");
        this.managerPort = conf.getInt("agent.manager.vip.http.port");
        this.proxySend = jobConf.getBoolean("job.proxySend", false);
        this.localhost = jobConf.get("proxy.localHost", CommonConstants.DEFAULT_PROXY_LOCALHOST);
        this.netTag = jobConf.get("proxy.net.tag", "");
        this.isLocalVisit = jobConf.getBoolean("proxy.isLocalVisit", true);
        this.totalAsyncBufSize = jobConf.getInt("proxy.total.async.proxy.size", 0xC800000);
        this.aliveConnectionNum = jobConf.getInt("proxy.alive.connection.num", 10);
        this.isCompress = jobConf.getBoolean("proxy.is.compress", true);
        this.maxSenderPerGroup = jobConf.getInt("proxy.max.sender.per.group", 10);
        this.msgType = jobConf.getInt("proxy.msgType", 7);
        this.maxSenderTimeout = jobConf.getInt("proxy.sender.maxTimeout", 20);
        this.maxSenderRetry = jobConf.getInt("proxy.sender.maxRetry", 5);
        this.retrySleepTime = jobConf.getLong("proxy.retry.sleep", 500L);
        this.isFile = jobConf.getBoolean("proxy.isFile", false);
        this.positionManager = PositionManager.getInstance();
        this.ioThreadNum = jobConf.getInt("client.iothread.num", CommonConstants.DEFAULT_PROXY_CLIENT_IO_THREAD_NUM);
        this.enableBusyWait = jobConf.getBoolean("client.enable.busy.wait", false);
        this.batchFlushInterval = jobConf.getInt("proxy.batch.flush.interval", 100);
        this.authSecretId = conf.get("agent.manager.auth.secretId");
        this.authSecretKey = conf.get("agent.manager.auth.secretKey");
        this.sourcePath = sourcePath;
        this.inlongGroupId = inlongGroupId;
        this.dimensions = new HashMap<String, String>();
        this.dimensions.put("pluginId", this.getClass().getSimpleName());
        String metricName = String.join((CharSequence)"-", this.getClass().getSimpleName(), String.valueOf(METRIC_INDEX.incrementAndGet()));
        this.metricItemSet = new AgentMetricItemSet(metricName);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
        this.resendQueue = new LinkedBlockingQueue();
    }

    public void Start() throws Exception {
        this.sender = this.createMessageSender(this.inlongGroupId);
        this.resendExecutorService.execute(this.flushResendQueue());
    }

    public void Stop() {
        this.shutdown = true;
        this.resendExecutorService.shutdown();
        this.sender.close();
        this.cleanResendQueue();
    }

    private void cleanResendQueue() {
        while (!this.resendQueue.isEmpty()) {
            try {
                AgentSenderCallback agentSenderCallback = this.resendQueue.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("clean resend queue error{}", (Object)e.getMessage());
            }
        }
    }

    private AgentMetricItem getMetricItem(Map<String, String> otherDimensions) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("pluginId", this.getClass().getSimpleName());
        dimensions.putAll(otherDimensions);
        return (AgentMetricItem)this.metricItemSet.findMetricItem(dimensions);
    }

    private AgentMetricItem getMetricItem(String groupId, String streamId) {
        HashMap<String, String> dims = new HashMap<String, String>();
        dims.put("inlongGroupId", groupId);
        dims.put("inlongStreamId", streamId);
        return this.getMetricItem(dims);
    }

    private DefaultMessageSender createMessageSender(String tagName) throws Exception {
        ProxyClientConfig proxyClientConfig = new ProxyClientConfig(this.localhost, this.isLocalVisit, this.managerHost, this.managerPort, tagName, this.authSecretId, this.authSecretKey);
        proxyClientConfig.setTotalAsyncCallbackSize(this.totalAsyncBufSize);
        proxyClientConfig.setFile(this.isFile);
        proxyClientConfig.setAliveConnections(this.aliveConnectionNum);
        proxyClientConfig.setIoThreadNum(this.ioThreadNum);
        proxyClientConfig.setEnableBusyWait(this.enableBusyWait);
        proxyClientConfig.setProtocolType("TCP");
        this.SHARED_FACTORY = new DefaultThreadFactory("agent-client-" + this.sourcePath, Thread.currentThread().isDaemon());
        DefaultMessageSender sender = new DefaultMessageSender(proxyClientConfig, this.SHARED_FACTORY);
        sender.setMsgtype(this.msgType);
        sender.setCompress(this.isCompress);
        return sender;
    }

    public void sendBatch(BatchProxyMessage batchMessage) {
        this.sendBatchWithRetryCount(batchMessage, 0);
    }

    private void sendBatchWithRetryCount(BatchProxyMessage batchMessage, int retry) {
        boolean suc = false;
        while (!suc) {
            try {
                if (!this.resendQueue.isEmpty()) {
                    AgentUtils.silenceSleepInMs((long)this.retrySleepTime);
                    continue;
                }
                this.sender.asyncSendMessage((SendMessageCallback)new AgentSenderCallback(batchMessage, retry), batchMessage.getDataList(), batchMessage.getGroupId(), batchMessage.getStreamId(), batchMessage.getDataTime(), SEQUENTIAL_ID.getNextUuid(), this.maxSenderTimeout, TimeUnit.SECONDS, batchMessage.getExtraMap(), this.proxySend);
                this.getMetricItem((String)batchMessage.getGroupId(), (String)batchMessage.getStreamId()).pluginSendCount.addAndGet(batchMessage.getMsgCnt());
                suc = true;
            }
            catch (Exception exception) {
                suc = false;
                if (retry > this.maxSenderRetry) {
                    if (retry % 10 == 0) {
                        LOGGER.error("max retry reached, sample log Exception caught", (Throwable)exception);
                    }
                } else {
                    LOGGER.error("Exception caught", (Throwable)exception);
                }
                ++retry;
                AgentUtils.silenceSleepInMs((long)this.retrySleepTime);
            }
        }
    }

    private Runnable flushResendQueue() {
        return () -> {
            LOGGER.info("start flush resend queue {}:{}", (Object)this.inlongGroupId, (Object)this.sourcePath);
            while (!this.shutdown) {
                try {
                    AgentSenderCallback callback = this.resendQueue.poll(1L, TimeUnit.SECONDS);
                    if (callback == null) continue;
                    this.sendBatchWithRetryCount(callback.batchMessage, callback.retry + 1);
                }
                catch (Exception ex) {
                    LOGGER.error("error caught", (Throwable)ex);
                }
                catch (Throwable t) {
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)t);
                }
                finally {
                    AgentUtils.silenceSleepInMs((long)this.batchFlushInterval);
                }
            }
            LOGGER.info("stop flush resend queue {}:{}", (Object)this.inlongGroupId, (Object)this.sourcePath);
        };
    }

    private void putInResendQueue(AgentSenderCallback batchMessageCallBack) {
        try {
            this.resendQueue.put(batchMessageCallBack);
        }
        catch (Throwable throwable) {
            LOGGER.error("putInResendQueue e = {}", throwable);
        }
    }

    private class AgentSenderCallback
    implements SendMessageCallback {
        private final int retry;
        private final BatchProxyMessage batchMessage;
        private final int msgCnt;

        AgentSenderCallback(BatchProxyMessage batchMessage, int retry) {
            this.batchMessage = batchMessage;
            this.retry = retry;
            this.msgCnt = batchMessage.getDataList().size();
        }

        public void onMessageAck(SendResult result) {
            String groupId = this.batchMessage.getGroupId();
            String streamId = this.batchMessage.getStreamId();
            String jobId = this.batchMessage.getJobId();
            long dataTime = this.batchMessage.getDataTime();
            if (result != null && result.equals((Object)SendResult.OK)) {
                ((SenderManager)SenderManager.this).getMetricItem((String)groupId, (String)streamId).pluginSendSuccessCount.addAndGet(this.msgCnt);
                PositionManager.getInstance().updateSinkPosition(this.batchMessage.getJobId(), SenderManager.this.sourcePath, (long)this.msgCnt, false);
            } else {
                LOGGER.warn("send groupId {}, streamId {}, jobId {}, dataTime {} fail with times {}, error {}", new Object[]{groupId, streamId, jobId, dataTime, this.retry, result});
                ((SenderManager)SenderManager.this).getMetricItem((String)groupId, (String)streamId).pluginSendFailCount.addAndGet(this.msgCnt);
                SenderManager.this.putInResendQueue(new AgentSenderCallback(this.batchMessage, this.retry));
            }
        }

        public void onException(Throwable e) {
            ((SenderManager)SenderManager.this).getMetricItem((String)this.batchMessage.getGroupId(), (String)this.batchMessage.getStreamId()).pluginSendFailCount.addAndGet(this.msgCnt);
            LOGGER.error("exception caught", e);
        }
    }
}

