/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.instance;

import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.core.instance.ActionType;
import org.apache.inlong.agent.core.instance.InstanceAction;
import org.apache.inlong.agent.core.instance.InstanceManager;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Instance;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.file.Sink;
import org.apache.inlong.agent.plugin.file.Source;
import org.apache.inlong.agent.plugin.utils.file.FileDataUtils;
import org.apache.inlong.agent.state.State;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.enums.InstanceStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInstance
extends Instance {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileInstance.class);
    private Source source;
    private Sink sink;
    private InstanceProfile profile;
    public static final int CORE_THREAD_SLEEP_TIME = 1;
    private static final int DESTROY_LOOP_WAIT_TIME_MS = 10;
    private static final int CHECK_FINISH_AT_LEAST_COUNT = 5;
    private InstanceManager instanceManager;
    private volatile boolean running = false;
    private volatile boolean inited = false;
    private volatile int checkFinishCount = 0;

    public void init(Object srcManager, InstanceProfile srcProfile) {
        try {
            this.instanceManager = (InstanceManager)srcManager;
            this.profile = srcProfile;
            this.profile.set("inodeInfo", FileDataUtils.getInodeInfo(this.profile.getInstanceId()));
            LOGGER.info("task id: {} submit new instance {} profile detail {}.", new Object[]{this.profile.getTaskId(), this.profile.getInstanceId(), this.profile.toJsonStr()});
            this.source = (Source)Class.forName(this.profile.getSourceClass()).newInstance();
            this.source.init(this.profile);
            this.sink = (Sink)Class.forName(this.profile.getSinkClass()).newInstance();
            this.sink.init(this.profile);
            this.inited = true;
        }
        catch (Throwable ex) {
            this.doChangeState(State.FATAL);
            LOGGER.error("init instance {} for task {} failed", new Object[]{this.profile.getInstanceId(), this.profile.getInstanceId(), ex});
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
        }
    }

    public void destroy() {
        if (!this.inited) {
            return;
        }
        this.doChangeState(State.SUCCEEDED);
        while (this.running) {
            AgentUtils.silenceSleepInMs((long)10L);
        }
        this.source.destroy();
        this.sink.destroy();
    }

    public void run() {
        Thread.currentThread().setName("file-instance-core-" + this.getTaskId() + "-" + this.getInstanceId());
        this.running = true;
        while (!this.isFinished()) {
            if (!this.source.sourceExist()) {
                this.handleSourceDeleted();
                break;
            }
            Message msg = this.source.read();
            if (msg == null) {
                if (this.source.sourceFinish() && this.sink.sinkFinish()) {
                    ++this.checkFinishCount;
                    if (this.checkFinishCount > 5) {
                        this.handleReadEnd();
                        break;
                    }
                } else {
                    this.checkFinishCount = 0;
                }
                AgentUtils.silenceSleepInSeconds((long)1L);
                String inlongGroupId = this.profile.getInlongGroupId();
                String inlongStreamId = this.profile.getInlongStreamId();
                AuditUtils.add((int)30010, (String)inlongGroupId, (String)inlongStreamId, (long)AgentUtils.getCurrentTime(), (int)1, (long)1L);
                continue;
            }
            this.sink.write(msg);
        }
        this.running = false;
    }

    private void handleReadEnd() {
        InstanceAction action = new InstanceAction(ActionType.FINISH, this.profile);
        while (!this.isFinished() && !this.instanceManager.submitAction(action)) {
            LOGGER.error("instance manager action queue is full: taskId {}", (Object)this.instanceManager.getTaskId());
            AgentUtils.silenceSleepInSeconds((long)1L);
        }
    }

    private void handleSourceDeleted() {
        OffsetManager.getInstance().deleteOffset(this.getTaskId(), this.getInstanceId());
        this.profile.setState(InstanceStateEnum.DELETE);
        this.profile.setModifyTime(Long.valueOf(AgentUtils.getCurrentTime()));
        InstanceAction action = new InstanceAction(ActionType.DELETE, this.profile);
        while (!this.isFinished() && !this.instanceManager.submitAction(action)) {
            LOGGER.error("instance manager action queue is full: taskId {}", (Object)this.instanceManager.getTaskId());
            AgentUtils.silenceSleepInSeconds((long)1L);
        }
    }

    public void addCallbacks() {
    }

    public String getTaskId() {
        return this.profile.getTaskId();
    }

    public String getInstanceId() {
        return this.profile.getInstanceId();
    }

    public Sink getSink() {
        return this.sink;
    }

    public InstanceProfile getProfile() {
        return this.profile;
    }
}

