/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.fetcher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.ProfileFetcher;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.plugin.fetcher.ManagerResultFormatter;
import org.apache.inlong.agent.pojo.FileTask;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.HttpManager;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.db.CommandEntity;
import org.apache.inlong.common.enums.PullJobTypeEnum;
import org.apache.inlong.common.pojo.agent.DataConfig;
import org.apache.inlong.common.pojo.agent.TaskRequest;
import org.apache.inlong.common.pojo.agent.TaskResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerFetcher
extends AbstractDaemon
implements ProfileFetcher {
    public static final String AGENT = "agent";
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerFetcher.class);
    private static final GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Gson GSON = gsonBuilder.create();
    private final String baseManagerUrl;
    private final String taskConfigUrl;
    private final String staticConfigUrl;
    private final AgentConfiguration conf;
    private final String uniqId;
    private final AgentManager agentManager;
    private final HttpManager httpManager;
    private String localIp;
    private String uuid;
    private String clusterName;

    public ManagerFetcher(AgentManager agentManager) {
        this.agentManager = agentManager;
        this.conf = AgentConfiguration.getAgentConf();
        if (!this.requiredKeys(this.conf)) {
            throw new RuntimeException("init manager error, cannot find required key");
        }
        this.httpManager = new HttpManager(this.conf);
        this.baseManagerUrl = HttpManager.buildBaseUrl();
        this.taskConfigUrl = this.buildTaskConfigUrl(this.baseManagerUrl);
        this.staticConfigUrl = this.buildStaticConfigUrl(this.baseManagerUrl);
        this.uniqId = this.conf.get("agent.uniq.id", AgentConstants.DEFAULT_AGENT_UNIQ_ID);
        this.clusterName = this.conf.get("agent.cluster.name");
    }

    private boolean requiredKeys(AgentConfiguration conf) {
        return conf.hasKey("agent.manager.vip.http.host") && conf.hasKey("agent.manager.vip.http.port");
    }

    private String buildTaskConfigUrl(String baseUrl) {
        return baseUrl + this.conf.get("agent.manager.task.http.path", "/agent/reportAndGetTask");
    }

    private String buildStaticConfigUrl(String baseUrl) {
        return baseUrl + this.conf.get("agent.manager.task.http.path", "/agent/getExistTaskConfig");
    }

    public TaskResult fetchTaskConfig() {
        LOGGER.info("fetchTaskConfig start");
        String resultStr = this.httpManager.doSentPost(this.taskConfigUrl, (Object)this.getFetchRequest(null));
        JsonObject resultData = ManagerResultFormatter.getResultData(resultStr);
        JsonElement element = resultData.get("data");
        LOGGER.info("fetchTaskConfig end");
        if (element != null) {
            LOGGER.info("fetchTaskConfig not null {}", (Object)resultData);
            return (TaskResult)GSON.fromJson((JsonElement)element.getAsJsonObject(), TaskResult.class);
        }
        LOGGER.info("fetchTaskConfig nothing to do");
        return null;
    }

    public TaskResult getStaticConfig() {
        LOGGER.info("getStaticConfig start");
        String resultStr = this.httpManager.doSentPost(this.staticConfigUrl, (Object)this.getFetchRequest(null));
        LOGGER.info("test123 staticConfigUrl {}", (Object)this.staticConfigUrl);
        JsonObject resultData = ManagerResultFormatter.getResultData(resultStr);
        JsonElement element = resultData.get("data");
        LOGGER.info("getStaticConfig end");
        if (element != null) {
            LOGGER.info("test123 getStaticConfig not null {}", (Object)resultData);
            return (TaskResult)GSON.fromJson((JsonElement)element.getAsJsonObject(), TaskResult.class);
        }
        LOGGER.info("getStaticConfig nothing to do");
        return null;
    }

    public TaskRequest getFetchRequest(List<CommandEntity> unackedCommands) {
        TaskRequest request = new TaskRequest();
        request.setAgentIp(this.localIp);
        request.setUuid(this.uuid);
        request.setClusterName(this.clusterName);
        request.setPullJobType(PullJobTypeEnum.NEW.getType());
        request.setCommandInfo(unackedCommands);
        return request;
    }

    private Runnable taskConfigFetchThread() {
        return () -> {
            Thread.currentThread().setName("ManagerFetcher");
            int normalTaskId = 100;
            int testState = 0;
            int retryTaskId = 800;
            long count = 1L;
            while (this.isRunnable()) {
                try {
                    TaskResult taskresult;
                    String testDir = this.conf.get("test.dir", "");
                    LOGGER.info("test123 test.dir {}", (Object)testDir);
                    if (testDir == "") {
                        taskresult = this.getStaticConfig();
                    } else {
                        if (count % 10L == 0L) {
                            ++normalTaskId;
                            ++retryTaskId;
                        }
                        testState = testState == 1 ? 2 : 1;
                        taskresult = this.getTestConfig(testDir, normalTaskId, retryTaskId, testState);
                    }
                    if (taskresult == null) continue;
                    ArrayList taskProfiles = new ArrayList();
                    taskresult.getDataConfigs().forEach(config -> {
                        TaskProfile profile = TaskProfile.convertToTaskProfile((DataConfig)config);
                        taskProfiles.add(profile);
                    });
                    this.agentManager.getTaskManager().submitTaskProfiles(taskProfiles);
                    ++count;
                    AgentUtils.silenceSleepInSeconds((long)60L);
                }
                catch (Throwable ex) {
                    LOGGER.warn("exception caught", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
            }
        };
    }

    private TaskResult getTestConfig(String testDir, int normalTaskId, int retryTaskId, int state) {
        ArrayList<DataConfig> configs = new ArrayList<DataConfig>();
        String startStr = "2023-07-10 00:00:00";
        String endStr = "2023-07-22 00:00:00";
        Long start = 0L;
        Long end = 0L;
        String normalPattern = testDir + "YYYY/YYYYMMDD_2.log_[0-9]+";
        String retryPattern = testDir + "YYYY/YYYYMMDD_1.log_[0-9]+";
        try {
            Date parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startStr);
            start = parse.getTime();
            parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endStr);
            end = parse.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        configs.add(this.getTestDataConfig(normalTaskId, normalPattern, false, start, end, state));
        configs.add(this.getTestDataConfig(retryTaskId, retryPattern, true, start, end, state));
        return TaskResult.builder().dataConfigs(configs).build();
    }

    private DataConfig getTestDataConfig(int taskId, String pattern, boolean retry, Long startTime, Long endTime, int state) {
        DataConfig dataConfig = new DataConfig();
        dataConfig.setInlongGroupId("testGroupId");
        dataConfig.setInlongStreamId("testStreamId");
        dataConfig.setDataReportType(Integer.valueOf(1));
        dataConfig.setTaskType(Integer.valueOf(3));
        dataConfig.setTaskId(Integer.valueOf(taskId));
        dataConfig.setState(Integer.valueOf(state));
        FileTask.FileTaskConfig fileTaskConfig = new FileTask.FileTaskConfig();
        fileTaskConfig.setPattern(pattern);
        fileTaskConfig.setTimeOffset("0d");
        fileTaskConfig.setMaxFileCount(Integer.valueOf(100));
        fileTaskConfig.setCycleUnit("D");
        fileTaskConfig.setRetry(Boolean.valueOf(retry));
        fileTaskConfig.setStartTime(startTime);
        fileTaskConfig.setEndTime(endTime);
        dataConfig.setExtParams(GSON.toJson((Object)fileTaskConfig));
        return dataConfig;
    }

    public void start() throws Exception {
        this.localIp = AgentUtils.fetchLocalIp();
        this.uuid = AgentUtils.fetchLocalUuid();
        this.submitWorker(this.taskConfigFetchThread());
    }

    public void stop() {
        this.waitForTerminate();
    }
}

