/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.utils.InputRefVisitor;
import org.apache.flink.util.Preconditions;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TemporalJoinUtil$ {
    public static final TemporalJoinUtil$ MODULE$;
    private final SqlFunction TEMPORAL_JOIN_CONDITION;
    private final SqlFunction INITIAL_TEMPORAL_JOIN_CONDITION;
    private final SqlFunction TEMPORAL_JOIN_LEFT_KEY;
    private final SqlFunction TEMPORAL_JOIN_RIGHT_KEY;
    private final SqlFunction TEMPORAL_JOIN_CONDITION_PRIMARY_KEY;

    static {
        new TemporalJoinUtil$();
    }

    public SqlFunction TEMPORAL_JOIN_CONDITION() {
        return this.TEMPORAL_JOIN_CONDITION;
    }

    public SqlFunction INITIAL_TEMPORAL_JOIN_CONDITION() {
        return this.INITIAL_TEMPORAL_JOIN_CONDITION;
    }

    public SqlFunction TEMPORAL_JOIN_LEFT_KEY() {
        return this.TEMPORAL_JOIN_LEFT_KEY;
    }

    public SqlFunction TEMPORAL_JOIN_RIGHT_KEY() {
        return this.TEMPORAL_JOIN_RIGHT_KEY;
    }

    public SqlFunction TEMPORAL_JOIN_CONDITION_PRIMARY_KEY() {
        return this.TEMPORAL_JOIN_CONDITION_PRIMARY_KEY;
    }

    private RexNode makePrimaryKeyCall(RexBuilder rexBuilder, Seq<RexNode> rightPrimaryKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION_PRIMARY_KEY(), JavaConversions$.MODULE$.seqAsJavaList(rightPrimaryKeyExpression));
    }

    private RexNode makeLeftJoinKeyCall(RexBuilder rexBuilder, Seq<RexNode> keyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_LEFT_KEY(), JavaConversions$.MODULE$.seqAsJavaList(keyExpression));
    }

    private RexNode makeRightJoinKeyCall(RexBuilder rexBuilder, Seq<RexNode> keyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_RIGHT_KEY(), JavaConversions$.MODULE$.seqAsJavaList(keyExpression));
    }

    public RexNode makeProcTimeTemporalFunctionJoinConCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, RexNode rightPrimaryKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, this.makePrimaryKeyCall(rexBuilder, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{rightPrimaryKeyExpression})));
    }

    public RexNode makeRowTimeTemporalFunctionJoinConCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, RexNode rightTimeAttribute, RexNode rightPrimaryKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, rightTimeAttribute, this.makePrimaryKeyCall(rexBuilder, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{rightPrimaryKeyExpression})));
    }

    public RexNode makeInitialRowTimeTemporalTableJoinCondCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, RexNode rightTimeAttribute, Seq<RexNode> leftJoinKeyExpression, Seq<RexNode> rightJoinKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.INITIAL_TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, rightTimeAttribute, this.makeLeftJoinKeyCall(rexBuilder, leftJoinKeyExpression), this.makeRightJoinKeyCall(rexBuilder, rightJoinKeyExpression));
    }

    public RexNode makeRowTimeTemporalTableJoinConCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, RexNode rightTimeAttribute, Seq<RexNode> rightPrimaryKeyExpression, Seq<RexNode> leftJoinKeyExpression, Seq<RexNode> rightJoinKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, rightTimeAttribute, this.makePrimaryKeyCall(rexBuilder, rightPrimaryKeyExpression), this.makeLeftJoinKeyCall(rexBuilder, leftJoinKeyExpression), this.makeRightJoinKeyCall(rexBuilder, rightJoinKeyExpression));
    }

    public RexNode makeInitialProcTimeTemporalTableJoinConCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, Seq<RexNode> leftJoinKeyExpression, Seq<RexNode> rightJoinKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.INITIAL_TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, this.makeLeftJoinKeyCall(rexBuilder, leftJoinKeyExpression), this.makeRightJoinKeyCall(rexBuilder, rightJoinKeyExpression));
    }

    public RexNode makeProcTimeTemporalTableJoinConCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, Seq<RexNode> rightPrimaryKeyExpression, Seq<RexNode> leftJoinKeyExpression, Seq<RexNode> rightJoinKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, this.makePrimaryKeyCall(rexBuilder, rightPrimaryKeyExpression), this.makeLeftJoinKeyCall(rexBuilder, leftJoinKeyExpression), this.makeRightJoinKeyCall(rexBuilder, rightJoinKeyExpression));
    }

    public boolean isInitialRowTimeTemporalTableJoin(RexCall rexCall) {
        SqlOperator sqlOperator = rexCall.getOperator();
        SqlFunction sqlFunction = this.INITIAL_TEMPORAL_JOIN_CONDITION();
        return !(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null) && JavaConversions$.MODULE$.asScalaBuffer(rexCall.operands).length() == 4;
    }

    public boolean isInitialProcTimeTemporalTableJoin(RexCall rexCall) {
        SqlOperator sqlOperator = rexCall.getOperator();
        SqlFunction sqlFunction = this.INITIAL_TEMPORAL_JOIN_CONDITION();
        return !(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null) && JavaConversions$.MODULE$.asScalaBuffer(rexCall.operands).length() == 3;
    }

    public boolean containsTemporalJoinCondition(RexNode condition) {
        BooleanRef hasTemporalJoinCondition = BooleanRef.create((boolean)false);
        condition.accept(new RexVisitorImpl<Void>(hasTemporalJoinCondition){
            private final BooleanRef hasTemporalJoinCondition$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Void visitCall(RexCall call) {
                block3: {
                    block2: {
                        SqlOperator sqlOperator = call.getOperator();
                        SqlFunction sqlFunction = TemporalJoinUtil$.MODULE$.TEMPORAL_JOIN_CONDITION();
                        if (!(sqlOperator == null ? sqlFunction != null : !((Object)sqlOperator).equals(sqlFunction))) break block2;
                        SqlOperator sqlOperator2 = call.getOperator();
                        SqlFunction sqlFunction2 = TemporalJoinUtil$.MODULE$.INITIAL_TEMPORAL_JOIN_CONDITION();
                        if (sqlOperator2 != null ? !((Object)sqlOperator2).equals(sqlFunction2) : sqlFunction2 != null) break block3;
                    }
                    this.hasTemporalJoinCondition$1.elem = true;
                    return null;
                }
                Void void_ = (Void)super.visitCall(call);
                return void_;
            }
            {
                this.hasTemporalJoinCondition$1 = hasTemporalJoinCondition$1;
                super(true);
            }
        });
        return hasTemporalJoinCondition.elem;
    }

    public boolean containsInitialTemporalJoinCondition(RexNode condition) {
        BooleanRef hasTemporalJoinCondition = BooleanRef.create((boolean)false);
        condition.accept(new RexVisitorImpl<Void>(hasTemporalJoinCondition){
            private final BooleanRef hasTemporalJoinCondition$2;

            public Void visitCall(RexCall call) {
                Void void_;
                SqlOperator sqlOperator = call.getOperator();
                SqlFunction sqlFunction = TemporalJoinUtil$.MODULE$.INITIAL_TEMPORAL_JOIN_CONDITION();
                if (!(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null)) {
                    this.hasTemporalJoinCondition$2.elem = true;
                    void_ = null;
                } else {
                    void_ = (Void)super.visitCall(call);
                }
                return void_;
            }
            {
                this.hasTemporalJoinCondition$2 = hasTemporalJoinCondition$2;
                super(true);
            }
        });
        return hasTemporalJoinCondition.elem;
    }

    public boolean isRowTimeJoin(JoinSpec joinSpec) {
        RexNode nonEquiJoinRex = joinSpec.getNonEquiCondition().orElse(null);
        BooleanRef rowtimeJoin = BooleanRef.create((boolean)false);
        RexVisitorImpl<BoxedUnit> visitor = new RexVisitorImpl<BoxedUnit>(rowtimeJoin){
            private final BooleanRef rowtimeJoin$1;

            public void visitCall(RexCall call) {
                if (TemporalJoinUtil$.MODULE$.isRowTimeTemporalTableJoinCon(call) || TemporalJoinUtil$.MODULE$.isRowTimeTemporalFunctionJoinCon(call)) {
                    this.rowtimeJoin$1.elem = true;
                } else {
                    super.visitCall(call);
                }
            }
            {
                this.rowtimeJoin$1 = rowtimeJoin$1;
                super(true);
            }
        };
        nonEquiJoinRex.accept(visitor);
        return rowtimeJoin.elem;
    }

    public boolean isRowTimeTemporalTableJoinCon(RexCall rexCall) {
        SqlOperator sqlOperator = rexCall.getOperator();
        SqlFunction sqlFunction = this.TEMPORAL_JOIN_CONDITION();
        return !(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null) && JavaConversions$.MODULE$.asScalaBuffer(rexCall.operands).length() == 5;
    }

    public boolean isRowTimeTemporalFunctionJoinCon(RexCall rexCall) {
        SqlOperator sqlOperator = rexCall.getOperator();
        SqlFunction sqlFunction = this.TEMPORAL_JOIN_CONDITION();
        return !(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null) && JavaConversions$.MODULE$.asScalaBuffer(rexCall.operands).length() == 3;
    }

    public boolean isTemporalFunctionJoin(RexBuilder rexBuilder, JoinInfo joinInfo) {
        RexNode nonEquiJoinRex = joinInfo.getRemaining(rexBuilder);
        BooleanRef isTemporalFunctionJoin = BooleanRef.create((boolean)false);
        RexVisitorImpl<BoxedUnit> visitor = new RexVisitorImpl<BoxedUnit>(isTemporalFunctionJoin){
            private final BooleanRef isTemporalFunctionJoin$1;

            public void visitCall(RexCall call) {
                if (TemporalJoinUtil$.MODULE$.isTemporalFunctionCon(call)) {
                    this.isTemporalFunctionJoin$1.elem = true;
                } else {
                    super.visitCall(call);
                }
            }
            {
                this.isTemporalFunctionJoin$1 = isTemporalFunctionJoin$1;
                super(true);
            }
        };
        nonEquiJoinRex.accept(visitor);
        return isTemporalFunctionJoin.elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTemporalFunctionCon(RexCall rexCall) {
        SqlOperator sqlOperator = rexCall.getOperator();
        SqlFunction sqlFunction = this.TEMPORAL_JOIN_CONDITION();
        if (sqlOperator == null) {
            if (sqlFunction != null) {
                return false;
            }
        } else if (!((Object)sqlOperator).equals(sqlFunction)) return false;
        if (JavaConversions$.MODULE$.asScalaBuffer(rexCall.operands).length() == 2) return true;
        if (JavaConversions$.MODULE$.asScalaBuffer(rexCall.operands).length() != 3) return false;
        return true;
    }

    public void validateTemporalFunctionCondition(RexCall call, RexNode leftTimeAttribute, Option<RexNode> rightTimeAttribute, Option<RexNode[]> rightPrimaryKey, int rightKeysStartingOffset, JoinSpec joinSpec, String textualRepresentation) {
        block8: {
            block7: {
                block5: {
                    block6: {
                        if (!this.isRowTimeTemporalFunctionJoinCon(call)) break block5;
                        this.validateTemporalFunctionPrimaryKey(rightKeysStartingOffset, rightPrimaryKey, joinSpec, textualRepresentation);
                        if (!FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(((RexNode)rightTimeAttribute.get()).getType())) break block6;
                        if (!FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(leftTimeAttribute.getType())) {
                            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non rowtime timeAttribute [", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTimeAttribute.getType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"passed as the argument to TemporalTableFunction"})).s((Seq)Nil$.MODULE$)).toString());
                        }
                        break block7;
                    }
                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non rowtime timeAttribute [", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((RexNode)rightTimeAttribute.get()).getType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"used to create TemporalTableFunction"})).s((Seq)Nil$.MODULE$)).toString());
                }
                this.validateTemporalFunctionPrimaryKey(rightKeysStartingOffset, rightPrimaryKey, joinSpec, textualRepresentation);
                if (!FlinkTypeFactory$.MODULE$.isProctimeIndicatorType(leftTimeAttribute.getType())) break block8;
            }
            return;
        }
        throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non processing timeAttribute [", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftTimeAttribute.getType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"passed as the argument to TemporalTableFunction"})).s((Seq)Nil$.MODULE$)).toString());
    }

    private void validateTemporalFunctionPrimaryKey(int rightKeysStartingOffset, Option<RexNode[]> rightPrimaryKey, JoinSpec joinInfo, String textualRepresentation) {
        if (joinInfo.getRightKeys().length != 1) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only single column join key is supported. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " in [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{joinInfo.getRightKeys(), textualRepresentation}))).toString());
        }
        if (rightPrimaryKey.isEmpty() || ((RexNode[])rightPrimaryKey.get()).length != 1) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only single primary key is supported. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " in [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightPrimaryKey, textualRepresentation}))).toString());
        }
        RexNode pk = ((RexNode[])rightPrimaryKey.get())[0];
        int rightJoinKeyInputReference = joinInfo.getRightKeys()[0] + rightKeysStartingOffset;
        int rightPrimaryKeyInputReference = this.extractInputRef(pk, textualRepresentation);
        if (rightPrimaryKeyInputReference != rightJoinKeyInputReference) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Join key [", "] must be the same as "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rightJoinKeyInputReference)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"temporal table's primary key [", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pk}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{textualRepresentation}))).toString());
        }
    }

    public int extractInputRef(RexNode rexNode, String textualRepresentation) {
        InputRefVisitor inputReferenceVisitor = new InputRefVisitor();
        rexNode.accept(inputReferenceVisitor);
        Preconditions.checkState((inputReferenceVisitor.getFields().length == 1 ? 1 : 0) != 0, (String)"Failed to find input reference in [%s]", (Object[])new Object[]{textualRepresentation});
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(inputReferenceVisitor.getFields()).head());
    }

    private TemporalJoinUtil$() {
        MODULE$ = this;
        this.TEMPORAL_JOIN_CONDITION = new SqlFunction("__TEMPORAL_JOIN_CONDITION", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.or(OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, RIGHT_TIME_ATTRIBUTE, PRIMARY_KEY, LEFT_KEY, RIGHT_KEY)'", OperandTypes.DATETIME, OperandTypes.DATETIME, OperandTypes.ANY, OperandTypes.ANY, OperandTypes.ANY), OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, PRIMARY_KEY, LEFT_KEY, RIGHT_KEY)'", OperandTypes.DATETIME, OperandTypes.ANY, OperandTypes.ANY, OperandTypes.ANY), OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, RIGHT_TIME_ATTRIBUTE, PRIMARY_KEY)'", OperandTypes.DATETIME, OperandTypes.DATETIME, OperandTypes.ANY), OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, PRIMARY_KEY)'", OperandTypes.DATETIME, OperandTypes.ANY)), SqlFunctionCategory.SYSTEM);
        this.INITIAL_TEMPORAL_JOIN_CONDITION = new SqlFunction("__INITIAL_TEMPORAL_JOIN_CONDITION", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.or(OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, RIGHT_TIME_ATTRIBUTE, LEFT_KEY, RIGHT_KEY)'", OperandTypes.DATETIME, OperandTypes.DATETIME, OperandTypes.ANY, OperandTypes.ANY), OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, LEFT_KEY, RIGHT_KEY)'", OperandTypes.DATETIME, OperandTypes.ANY, OperandTypes.ANY)), SqlFunctionCategory.SYSTEM);
        this.TEMPORAL_JOIN_LEFT_KEY = new SqlFunction("__TEMPORAL_JOIN_LEFT_KEY", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
        this.TEMPORAL_JOIN_RIGHT_KEY = new SqlFunction("__TEMPORAL_JOIN_RIGHT_KEY", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
        this.TEMPORAL_JOIN_CONDITION_PRIMARY_KEY = new SqlFunction("__TEMPORAL_JOIN_CONDITION_PRIMARY_KEY", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
    }
}

