/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.OperatorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.utils.ScanUtil;
import org.apache.flink.table.planner.sources.TableSourceUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.wmstrategies.PeriodicWatermarkAssigner;
import org.apache.flink.table.sources.wmstrategies.PunctuatedWatermarkAssigner;
import org.apache.flink.table.sources.wmstrategies.WatermarkStrategy;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;

public class StreamExecLegacyTableSourceScan
extends CommonExecLegacyTableSourceScan
implements StreamExecNode<RowData> {
    public StreamExecLegacyTableSourceScan(TableSource<?> tableSource, List<String> qualifiedName, RowType outputType, String description) {
        super(tableSource, qualifiedName, outputType, description);
    }

    @Override
    protected Transformation<RowData> createConversionTransformationIfNeeded(PlannerBase planner, Transformation<?> sourceTransform, @Nullable RexNode rowtimeExpression) {
        Object transformation;
        RowType outputType = (RowType)this.getOutputType();
        int[] fieldIndexes = this.computeIndexMapping(true);
        if (this.needInternalConversion(fieldIndexes)) {
            String resetElement;
            String extractElement;
            if (ScanUtil.hasTimeAttributeField(fieldIndexes)) {
                String elementTerm = OperatorCodeGenerator.ELEMENT();
                extractElement = String.format("ctx.%s = %s;", elementTerm, elementTerm);
                resetElement = String.format("ctx.%s = null;", elementTerm);
            } else {
                extractElement = "";
                resetElement = "";
            }
            CodeGeneratorContext ctx = new CodeGeneratorContext(planner.getTableConfig()).setOperatorBaseClass(TableStreamOperator.class);
            DataType fixedProducedDataType = TableSourceUtil.fixPrecisionForProducedDataType(this.tableSource, outputType);
            transformation = ScanUtil.convertToInternalRow(ctx, sourceTransform, fieldIndexes, fixedProducedDataType, outputType, this.qualifiedName, JavaScalaConversionUtil.toScala(Optional.ofNullable(rowtimeExpression)), extractElement, resetElement);
        } else {
            transformation = sourceTransform;
        }
        RelDataType relDataType = FlinkTypeFactory.INSTANCE().buildRelNodeRowType(outputType);
        DataStream ingestedTable = new DataStream(planner.getExecEnv(), transformation);
        Optional<RowtimeAttributeDescriptor> rowtimeDesc = JavaScalaConversionUtil.toJava(TableSourceUtil.getRowtimeAttributeDescriptor(this.tableSource, relDataType));
        DataStream withWatermarks = rowtimeDesc.map(desc -> {
            int rowtimeFieldIdx = relDataType.getFieldNames().indexOf(desc.getAttributeName());
            WatermarkStrategy strategy = desc.getWatermarkStrategy();
            if (strategy instanceof PeriodicWatermarkAssigner) {
                PeriodicWatermarkAssignerWrapper watermarkGenerator = new PeriodicWatermarkAssignerWrapper((PeriodicWatermarkAssigner)strategy, rowtimeFieldIdx);
                return ingestedTable.assignTimestampsAndWatermarks((AssignerWithPeriodicWatermarks)watermarkGenerator);
            }
            if (strategy instanceof PunctuatedWatermarkAssigner) {
                PunctuatedWatermarkAssignerWrapper watermarkGenerator = new PunctuatedWatermarkAssignerWrapper((PunctuatedWatermarkAssigner)strategy, rowtimeFieldIdx, this.tableSource.getProducedDataType());
                return ingestedTable.assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)watermarkGenerator);
            }
            return ingestedTable;
        }).orElse(ingestedTable);
        return withWatermarks.getTransformation();
    }

    @Override
    protected <IN> Transformation<IN> createInput(StreamExecutionEnvironment env, InputFormat<IN, ? extends InputSplit> format, TypeInformation<IN> typeInfo) {
        return env.createInput(format, typeInfo).name(this.tableSource.explainSource()).getTransformation();
    }

    private static class PunctuatedWatermarkAssignerWrapper
    implements AssignerWithPunctuatedWatermarks<RowData> {
        private static final long serialVersionUID = 1L;
        private final PunctuatedWatermarkAssigner assigner;
        private final int timeFieldIdx;
        private final DataFormatConverters.DataFormatConverter<RowData, Row> converter;

        private PunctuatedWatermarkAssignerWrapper(PunctuatedWatermarkAssigner assigner, int timeFieldIdx, DataType sourceType) {
            this.assigner = assigner;
            this.timeFieldIdx = timeFieldIdx;
            DataType originDataType = sourceType instanceof FieldsDataType ? sourceType : DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)sourceType)});
            this.converter = DataFormatConverters.getConverterForDataType((DataType)((DataType)originDataType.bridgedTo(Row.class)));
        }

        @Nullable
        public Watermark checkAndGetNextWatermark(RowData row, long extractedTimestamp) {
            long timestamp = row.getLong(this.timeFieldIdx);
            return this.assigner.getWatermark((Row)this.converter.toExternal((Object)row), timestamp);
        }

        public long extractTimestamp(RowData element, long recordTimestamp) {
            return 0L;
        }
    }

    private static class PeriodicWatermarkAssignerWrapper
    implements AssignerWithPeriodicWatermarks<RowData> {
        private static final long serialVersionUID = 1L;
        private final PeriodicWatermarkAssigner assigner;
        private final int timeFieldIdx;

        private PeriodicWatermarkAssignerWrapper(PeriodicWatermarkAssigner assigner, int timeFieldIdx) {
            this.assigner = assigner;
            this.timeFieldIdx = timeFieldIdx;
        }

        @Nullable
        public Watermark getCurrentWatermark() {
            return this.assigner.getWatermark();
        }

        public long extractTimestamp(RowData row, long recordTimestamp) {
            long timestamp = row.getTimestamp(this.timeFieldIdx, 3).getMillisecond();
            this.assigner.nextTimestamp(timestamp);
            return 0L;
        }
    }
}

