/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.ByteBuffer;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimeIndex$$anonfun$kafka$log$TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002V5nK&sG-\u001a=\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u00055\t%m\u001d;sC\u000e$\u0018J\u001c3fq\"AQ\u0002\u0001B\u0001B\u0003%a\"A\u0003`M&dW\r\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005\u0011\u0011n\u001c\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0003GS2,\u0007\"C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u001f\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0005\u0019>tw-\u0003\u0002\u0018\u0015!I\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005J\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\t\u00033\tJ!a\t\u000e\u0003\u0007%sG/\u0003\u0002!\u0015!Ia\u0005\u0001B\u0001B\u0003%qEK\u0001\toJLG/\u00192mKB\u0011\u0011\u0004K\u0005\u0003Si\u0011qAQ8pY\u0016\fg.\u0003\u0002'\u0015!)A\u0006\u0001C\u0001[\u00051A(\u001b8jiz\"RAL\u00181cI\u0002\"!\u0003\u0001\t\u000b5Y\u0003\u0019\u0001\b\t\u000b]Y\u0003\u0019\u0001\r\t\u000f\u0001Z\u0003\u0013!a\u0001C!9ae\u000bI\u0001\u0002\u00049\u0003b\u0002\u001b\u0001\u0001\u0004%I!N\u0001\u000b?2\f7\u000f^#oiJLX#\u0001\u001c\u0011\u0005%9\u0014B\u0001\u001d\u0003\u0005=!\u0016.\\3ti\u0006l\u0007o\u00144gg\u0016$\bb\u0002\u001e\u0001\u0001\u0004%IaO\u0001\u000f?2\f7\u000f^#oiJLx\fJ3r)\tat\b\u0005\u0002\u001a{%\u0011aH\u0007\u0002\u0005+:LG\u000fC\u0004As\u0005\u0005\t\u0019\u0001\u001c\u0002\u0007a$\u0013\u0007\u0003\u0004C\u0001\u0001\u0006KAN\u0001\f?2\f7\u000f^#oiJL\b\u0005\u000b\u0002B\tB\u0011\u0011$R\u0005\u0003\rj\u0011\u0001B^8mCRLG.\u001a\u0005\u0006\u0011\u0002!\t%S\u0001\nK:$(/_*ju\u0016,\u0012!\t\u0005\u0006\u0017\u0002!\t\u0005T\u0001\u0007SN4U\u000f\u001c7\u0016\u0003\u001dBQA\u0014\u0001\u0005\n=\u000b\u0011\u0002^5nKN$\u0018-\u001c9\u0015\u0007a\u0001\u0006\fC\u0003R\u001b\u0002\u0007!+\u0001\u0004ck\u001a4WM\u001d\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+J\t1A\\5p\u0013\t9FK\u0001\u0006CsR,')\u001e4gKJDQ!W'A\u0002\u0005\n\u0011A\u001c\u0005\u00067\u0002!I\u0001X\u0001\u000fe\u0016d\u0017\r^5wK>3gm]3u)\r\tSL\u0018\u0005\u0006#j\u0003\rA\u0015\u0005\u00063j\u0003\r!\t\u0005\u0006A\u0002!\t!N\u0001\nY\u0006\u001cH/\u00128uefDQA\u0019\u0001\u0005\nU\na\u0003\\1ti\u0016sGO]=Ge>l\u0017J\u001c3fq\u001aKG.\u001a\u0005\u0006I\u0002!\t!Z\u0001\u0006K:$(/\u001f\u000b\u0003m\u0019DQ!W2A\u0002\u0005BQ\u0001\u001b\u0001\u0005B%\f!\u0002]1sg\u0016,e\u000e\u001e:z)\r1$n\u001b\u0005\u0006#\u001e\u0004\rA\u0015\u0005\u00063\u001e\u0004\r!\t\u0005\u0006[\u0002!\tA\\\u0001\f[\u0006L(-Z!qa\u0016tG\r\u0006\u0003=_B\u0014\b\"\u0002(m\u0001\u0004A\u0002\"B9m\u0001\u0004A\u0012AB8gMN,G\u000fC\u0004tYB\u0005\t\u0019A\u0014\u0002\u001bM\\\u0017\u000e\u001d$vY2\u001c\u0005.Z2l\u0011\u0015)\b\u0001\"\u0001w\u0003\u0019awn\\6vaR\u0011ag\u001e\u0005\u0006qR\u0004\r\u0001G\u0001\u0010i\u0006\u0014x-\u001a;US6,7\u000f^1na\")!\u0010\u0001C!w\u0006AAO];oG\u0006$X\rF\u0001=\u0011\u0015i\b\u0001\"\u0011\u007f\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0003y}DQ!\u001d?A\u0002aAq!a\u0001\u0001\t\u0003\n)!\u0001\u0004sKNL'0\u001a\u000b\u0004O\u0005\u001d\u0001bBA\u0005\u0003\u0003\u0001\r!I\u0001\b]\u0016<8+\u001b>f\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001f\t\u0011\u0003\u001e:v]\u000e\fG/\u001a+p\u000b:$(/[3t)\ra\u0014\u0011\u0003\u0005\b\u0003'\tY\u00011\u0001\"\u0003\u001d)g\u000e\u001e:jKNDa!a\u0006\u0001\t\u0003Z\u0018aC:b]&$\u0018p\u00115fG.D\u0011\"a\u0007\u0001#\u0003%\t!!\b\u0002+5\f\u0017PY3BaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0004\u0016\u0004O\u0005\u00052FAA\u0012!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055\"$\u0001\u0006b]:|G/\u0019;j_:LA!!\r\u0002(\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0019\u0005U\u0002\u0001%A\u0002\u0002\u0003%I!\u0013\u0013\u0002%M,\b/\u001a:%[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\u000e\u0003s\u0001\u0001\u0013aA\u0001\u0002\u0013%\u00111\b\u0010\u0002!M,\b/\u001a:%E\u0006\u001cXm\u00144gg\u0016$X#\u0001\r\t\u001d\u0005}\u0002\u0001%A\u0002\u0002\u0003%I!!\u0011\u0002F\u0005a1/\u001e9fe\u0012\u0012Xm]5{KR\u0019q%a\u0011\t\u000f\u0005%\u0011Q\ba\u0001C%\u0019\u00111\u0001\u0006\b\u000f\u0005%#\u0001#\u0001\u0002L\u0005IA+[7f\u0013:$W\r\u001f\t\u0004\u0013\u00055cAB\u0001\u0003\u0011\u0003\tye\u0005\u0004\u0002N\u0005E\u0013q\u000b\t\u00043\u0005M\u0013bAA+5\t1\u0011I\\=SK\u001a\u0004B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;\"\u0011!B;uS2\u001c\u0018\u0002BA1\u00037\u0012q\u0001T8hO&tw\rC\u0004-\u0003\u001b\"\t!!\u001a\u0015\u0005\u0005-\u0003BCA5\u0003\u001b\u0012\r\u0011\"\u0011\u0002l\u0005QAn\\4hKJt\u0015-\\3\u0016\u0005\u00055\u0004\u0003BA8\u0003kr1!GA9\u0013\r\t\u0019HG\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0014\u0011\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005M$\u0004C\u0005\u0002~\u00055\u0003\u0015!\u0003\u0002n\u0005YAn\\4hKJt\u0015-\\3!\u0011)\t\t)!\u0014\u0012\u0002\u0013\u0005\u00111Q\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0015%fA\u0011\u0002\"!Q\u0011\u0011RA'#\u0003%\t!!\b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public class TimeIndex
extends AbstractIndex {
    private volatile TimestampOffset kafka$log$TimeIndex$$_lastEntry = this.kafka$log$TimeIndex$$lastEntryFromIndexFile();

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        TimeIndex$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        TimeIndex$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        TimeIndex$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        TimeIndex$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        TimeIndex$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return TimeIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return TimeIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        TimeIndex$.MODULE$.trace(function0);
    }

    public static String msgWithLogIdent(String string) {
        return TimeIndex$.MODULE$.msgWithLogIdent(string);
    }

    public static void logIdent_$eq(String string) {
        TimeIndex$.MODULE$.logIdent_$eq(string);
    }

    public static String logIdent() {
        return TimeIndex$.MODULE$.logIdent();
    }

    public static Logger logger() {
        return TimeIndex$.MODULE$.logger();
    }

    public static boolean $lessinit$greater$default$4() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return TimeIndex$.MODULE$.loggerName();
    }

    public /* synthetic */ int kafka$log$TimeIndex$$super$maxIndexSize() {
        return super.maxIndexSize();
    }

    public /* synthetic */ long kafka$log$TimeIndex$$super$baseOffset() {
        return super.baseOffset();
    }

    public /* synthetic */ boolean kafka$log$TimeIndex$$super$resize(int newSize) {
        return super.resize(newSize);
    }

    public TimestampOffset kafka$log$TimeIndex$$_lastEntry() {
        return this.kafka$log$TimeIndex$$_lastEntry;
    }

    public void kafka$log$TimeIndex$$_lastEntry_$eq(TimestampOffset x$1) {
        this.kafka$log$TimeIndex$$_lastEntry = x$1;
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    public int kafka$log$TimeIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return this.kafka$log$TimeIndex$$_lastEntry();
    }

    public TimestampOffset kafka$log$TimeIndex$$lastEntryFromIndexFile() {
        return (TimestampOffset)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;

            public final TimestampOffset apply() {
                TimestampOffset timestampOffset;
                int n = this.$outer._entries();
                switch (n) {
                    default: {
                        timestampOffset = this.$outer.parseEntry(this.$outer.mmap(), n - 1);
                        break;
                    }
                    case 0: {
                        timestampOffset = new TimestampOffset(-1L, this.$outer.kafka$log$TimeIndex$$super$baseOffset());
                    }
                }
                return timestampOffset;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final int n$1;

            public final TimestampOffset apply() {
                if (this.n$1 >= this.$outer._entries()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to fetch the ", "th entry from  time index ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$1), this.$outer.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which has size ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer._entries())}))).toString());
                }
                return this.$outer.parseEntry(this.$outer.mmap(), this.n$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        });
    }

    @Override
    public TimestampOffset parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.kafka$log$TimeIndex$$relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset2, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, timestamp, offset2, skipFullCheck){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            public final long timestamp$1;
            public final long offset$1;
            private final boolean skipFullCheck$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (!this.skipFullCheck$1) {
                    Predef$.MODULE$.require(!this.$outer.isFull(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Attempt to append to a full time index (size = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$TimeIndex$$anonfun$$$outer()._entries())).append((Object)").").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                if (this.$outer._entries() != 0 && this.offset$1 < this.$outer.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to append an offset (", ") to slot ", " no larger than"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer._entries())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" the last offset appended (", ") to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.lastEntry().offset()), this.$outer.file().getAbsolutePath()}))).toString());
                }
                if (this.$outer._entries() != 0 && this.timestamp$1 < this.$outer.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to append a timestamp (", ") to slot ", " no larger"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timestamp$1), BoxesRunTime.boxToInteger((int)this.$outer._entries())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" than the last timestamp appended (", ") to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.lastEntry().timestamp()), this.$outer.file().getAbsolutePath()}))).toString());
                }
                if (this.timestamp$1 > this.$outer.lastEntry().timestamp()) {
                    TimeIndex$.MODULE$.trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding index entry ", " => ", " to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.timestamp$1), BoxesRunTime.boxToLong((long)this.$outer.offset$1), this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().file().getAbsolutePath()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.mmap().putLong(this.timestamp$1);
                    this.$outer.mmap().putInt(this.$outer.relativeOffset(this.offset$1));
                    this.$outer._entries_$eq(this.$outer._entries() + 1);
                    this.$outer.kafka$log$TimeIndex$$_lastEntry_$eq(new TimestampOffset(this.timestamp$1, this.offset$1));
                    Predef$.MODULE$.require(this.$outer._entries() * this.$outer.entrySize() == this.$outer.mmap().position(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$TimeIndex$$anonfun$$$outer()._entries()).append((Object)" entries but file position in index is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
            }

            public /* synthetic */ TimeIndex kafka$log$TimeIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
                this.offset$1 = offset$1;
                this.skipFullCheck$1 = skipFullCheck$1;
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), new Serializable(this, targetTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long targetTimestamp$1;

            public final TimestampOffset apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.targetTimestamp$1, IndexSearchType$.MODULE$.KEY());
                return slot == -1 ? new TimestampOffset(-1L, this.$outer.kafka$log$TimeIndex$$super$baseOffset()) : this.$outer.parseEntry(idx, slot);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetTimestamp$1 = targetTimestamp$1;
            }
        });
    }

    @Override
    public void truncate() {
        this.kafka$log$TimeIndex$$truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.offset$2, IndexSearchType$.MODULE$.VALUE());
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$TimeIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.kafka$log$TimeIndex$$super$baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$TimeIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    @Override
    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final int newSize$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                if (this.$outer.kafka$log$TimeIndex$$super$resize(this.newSize$1)) {
                    this.$outer.kafka$log$TimeIndex$$_lastEntry_$eq(this.$outer.kafka$log$TimeIndex$$lastEntryFromIndexFile());
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
    }

    public void kafka$log$TimeIndex$$truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            public final int entries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer._entries_$eq(this.entries$1);
                this.$outer.mmap().position(this.$outer._entries() * this.$outer.entrySize());
                this.$outer.kafka$log$TimeIndex$$_lastEntry_$eq(this.$outer.kafka$log$TimeIndex$$lastEntryFromIndexFile());
                TimeIndex$.MODULE$.debug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$kafka$log$TimeIndex$$truncateToEntries$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncated index ", " to ", " entries; position is now ", " and last entry is now ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.entries$1), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().mmap().position()), this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().kafka$log$TimeIndex$$_lastEntry()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TimeIndex kafka$log$TimeIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    @Override
    public void sanityCheck() {
        long lastTimestamp = this.lastEntry().timestamp();
        long lastOffset = this.lastEntry().offset();
        if (this._entries() != 0 && lastTimestamp < this.timestamp(this.mmap(), 0)) {
            throw new CorruptIndexException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-zero size but the last timestamp is ", " which is less than the first timestamp "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastTimestamp)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timestamp(this.mmap(), 0))}))).toString());
        }
        if (this._entries() != 0 && lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-zero size but the last offset is ", " which is less than the first offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastOffset), BoxesRunTime.boxToLong((long)super.baseOffset())}))).toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time index file ", " is corrupt, found ", " bytes "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToLong((long)this.length())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which is neither positive nor a multiple of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.entrySize())}))).toString());
        }
    }

    public TimeIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        TimeIndex$.MODULE$.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded index file ", " with maxEntries = ", ", maxIndexSize = ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.maxEntries()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$TimeIndex$$super$maxIndexSize())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" entries = ", ", lastOffset = ", ", file position = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer._entries()), this.$outer.kafka$log$TimeIndex$$_lastEntry(), BoxesRunTime.boxToInteger((int)this.$outer.mmap().position())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

