/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.inlong.manager.client.api.InlongStream;
import org.apache.inlong.manager.client.api.inner.InnerGroupContext;
import org.apache.inlong.manager.common.enums.SimpleGroupStatus;
import org.apache.inlong.manager.common.enums.SimpleSourceStatus;
import org.apache.inlong.manager.common.enums.SortStatus;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupStatusInfo;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlongGroupContext
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(InlongGroupContext.class);
    private String groupId;
    private String groupName;
    private InlongGroupInfo groupInfo;
    private Map<String, InlongStream> inlongStreamMap;
    private Map<String, String> extensions;
    private SimpleGroupStatus status;
    private SortStatus sortStatus = SortStatus.UNKNOWN;
    private InlongGroupStatusInfo statusInfo;

    public InlongGroupContext(InnerGroupContext groupContext) {
        InlongGroupInfo groupInfo = groupContext.getGroupInfo();
        Preconditions.expectNotNull((Object)groupInfo, (String)"inlong group info cannot be null");
        this.groupId = groupInfo.getInlongGroupId();
        this.groupName = groupInfo.getName();
        this.groupInfo = groupInfo;
        this.inlongStreamMap = groupContext.getStreamMap();
        this.status = SimpleGroupStatus.parseStatusByCode((int)groupInfo.getStatus());
        this.recheckState();
        this.statusInfo = InlongGroupStatusInfo.builder().inlongGroupId(groupInfo.getInlongGroupId()).originalStatus(groupInfo.getStatus()).simpleGroupStatus(this.status).sortStatus(this.sortStatus).streamSources(this.getGroupSources()).build();
        this.extensions = Maps.newHashMap();
        List extInfos = groupInfo.getExtList();
        if (CollectionUtils.isNotEmpty((Collection)extInfos)) {
            extInfos.forEach(extInfo -> this.extensions.put(extInfo.getKeyName(), extInfo.getKeyValue()));
        }
    }

    public void updateSortStatus(SortStatus sortStatus) {
        this.sortStatus = sortStatus;
        this.statusInfo.setSortStatus(sortStatus);
    }

    private List<StreamSource> getGroupSources() {
        ArrayList groupSources = Lists.newArrayList();
        this.inlongStreamMap.values().forEach(inlongStream -> {
            Map<String, StreamSource> sources = inlongStream.getSources();
            if (MapUtils.isNotEmpty(sources)) {
                for (Map.Entry<String, StreamSource> entry : sources.entrySet()) {
                    StreamSource source = entry.getValue();
                    if (source == null || source.getTemplateId() != null) continue;
                    groupSources.add(source);
                }
            }
        });
        return groupSources;
    }

    private void recheckState() {
        if (MapUtils.isEmpty(this.inlongStreamMap)) {
            return;
        }
        ArrayList sourcesInGroup = Lists.newArrayList();
        ArrayList failedSources = Lists.newArrayList();
        this.inlongStreamMap.values().forEach(inlongStream -> {
            Map<String, StreamSource> sources = inlongStream.getSources();
            if (MapUtils.isNotEmpty(sources)) {
                for (Map.Entry<String, StreamSource> entry : sources.entrySet()) {
                    StreamSource source = entry.getValue();
                    if (source == null) continue;
                    sourcesInGroup.add(source);
                    if (SimpleSourceStatus.parseByStatus((int)source.getStatus()) != SimpleSourceStatus.FAILED) continue;
                    failedSources.add(source);
                }
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)failedSources)) {
            this.status = SimpleGroupStatus.FAILED;
            return;
        }
        switch (this.status) {
            case STARTED: {
                for (StreamSource source : sourcesInGroup) {
                    if (SimpleSourceStatus.parseByStatus((int)source.getStatus()) == SimpleSourceStatus.NORMAL) continue;
                    log.warn("stream source is not started: {}", (Object)source);
                    this.status = SimpleGroupStatus.INITIALIZING;
                    break;
                }
                return;
            }
            case STOPPED: {
                for (StreamSource source : sourcesInGroup) {
                    if (SimpleSourceStatus.parseByStatus((int)source.getStatus()) == SimpleSourceStatus.FROZEN) continue;
                    log.warn("stream source is not stopped: {}", (Object)source);
                    this.status = SimpleGroupStatus.OPERATING;
                    break;
                }
                return;
            }
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public InlongGroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    public Map<String, InlongStream> getInlongStreamMap() {
        return this.inlongStreamMap;
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public SimpleGroupStatus getStatus() {
        return this.status;
    }

    public SortStatus getSortStatus() {
        return this.sortStatus;
    }

    public InlongGroupStatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setGroupInfo(InlongGroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public void setInlongStreamMap(Map<String, InlongStream> inlongStreamMap) {
        this.inlongStreamMap = inlongStreamMap;
    }

    public void setExtensions(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    public void setStatus(SimpleGroupStatus status) {
        this.status = status;
    }

    public void setSortStatus(SortStatus sortStatus) {
        this.sortStatus = sortStatus;
    }

    public void setStatusInfo(InlongGroupStatusInfo statusInfo) {
        this.statusInfo = statusInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongGroupContext)) {
            return false;
        }
        InlongGroupContext other = (InlongGroupContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        InlongGroupInfo this$groupInfo = this.getGroupInfo();
        InlongGroupInfo other$groupInfo = other.getGroupInfo();
        if (this$groupInfo == null ? other$groupInfo != null : !this$groupInfo.equals(other$groupInfo)) {
            return false;
        }
        Map<String, InlongStream> this$inlongStreamMap = this.getInlongStreamMap();
        Map<String, InlongStream> other$inlongStreamMap = other.getInlongStreamMap();
        if (this$inlongStreamMap == null ? other$inlongStreamMap != null : !((Object)this$inlongStreamMap).equals(other$inlongStreamMap)) {
            return false;
        }
        Map<String, String> this$extensions = this.getExtensions();
        Map<String, String> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        SimpleGroupStatus this$status = this.getStatus();
        SimpleGroupStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        SortStatus this$sortStatus = this.getSortStatus();
        SortStatus other$sortStatus = other.getSortStatus();
        if (this$sortStatus == null ? other$sortStatus != null : !this$sortStatus.equals(other$sortStatus)) {
            return false;
        }
        InlongGroupStatusInfo this$statusInfo = this.getStatusInfo();
        InlongGroupStatusInfo other$statusInfo = other.getStatusInfo();
        return !(this$statusInfo == null ? other$statusInfo != null : !this$statusInfo.equals(other$statusInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongGroupContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        InlongGroupInfo $groupInfo = this.getGroupInfo();
        result = result * 59 + ($groupInfo == null ? 43 : $groupInfo.hashCode());
        Map<String, InlongStream> $inlongStreamMap = this.getInlongStreamMap();
        result = result * 59 + ($inlongStreamMap == null ? 43 : ((Object)$inlongStreamMap).hashCode());
        Map<String, String> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        SimpleGroupStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        SortStatus $sortStatus = this.getSortStatus();
        result = result * 59 + ($sortStatus == null ? 43 : $sortStatus.hashCode());
        InlongGroupStatusInfo $statusInfo = this.getStatusInfo();
        result = result * 59 + ($statusInfo == null ? 43 : $statusInfo.hashCode());
        return result;
    }

    public String toString() {
        return "InlongGroupContext(groupId=" + this.getGroupId() + ", groupName=" + this.getGroupName() + ", groupInfo=" + this.getGroupInfo() + ", inlongStreamMap=" + this.getInlongStreamMap() + ", extensions=" + this.getExtensions() + ", status=" + this.getStatus() + ", sortStatus=" + this.getSortStatus() + ", statusInfo=" + this.getStatusInfo() + ")";
    }
}

