/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.enums.TenantUserTypeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateByIdValidation;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.cluster.BindTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagResponse;
import org.apache.inlong.manager.pojo.cluster.TenantClusterTagInfo;
import org.apache.inlong.manager.pojo.cluster.TenantClusterTagPageRequest;
import org.apache.inlong.manager.pojo.cluster.TenantClusterTagRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-Cluster-API"})
public class OpenInLongClusterController {
    @Autowired
    private InlongClusterService clusterService;

    @GetMapping(value={"/cluster/tag/get/{id}"})
    @ApiOperation(value="Get cluster tag by id")
    @ApiImplicitParam(name="id", value="Cluster ID", dataTypeClass=Integer.class, required=true)
    public Response<ClusterTagResponse> getTag(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"tag id cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.getTag(id, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/cluster/tag/list"})
    @ApiOperation(value="List cluster tags")
    public Response<List<ClusterTagResponse>> listTag(@RequestBody ClusterTagPageRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        request.setIsAdminRole(Boolean.valueOf(LoginUserUtils.getLoginUser().getRoles().contains(TenantUserTypeEnum.TENANT_ADMIN.name())));
        return Response.success((Object)this.clusterService.listTag(request, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/cluster/tag/save"})
    @ApiOperation(value="Save cluster tag")
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.CLUSTER)
    public Response<Integer> saveTag(@Validated(value={SaveValidation.class}) @RequestBody ClusterTagRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.saveTag(request, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/cluster/tag/update"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.CLUSTER)
    @ApiOperation(value="Update cluster tag")
    public Response<Boolean> updateTag(@Validated(value={UpdateValidation.class}) @RequestBody ClusterTagRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.updateTag(request, LoginUserUtils.getLoginUser()));
    }

    @DeleteMapping(value={"/cluster/tag/delete/{id}"})
    @ApiOperation(value="Delete cluster tag by id")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.CLUSTER)
    @ApiImplicitParam(name="id", value="Cluster tag ID", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> deleteTag(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"tag id cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.deleteTag(id, LoginUserUtils.getLoginUser()));
    }

    @GetMapping(value={"/cluster/get/{id}"})
    @ApiOperation(value="Get cluster by id")
    @ApiImplicitParam(name="id", value="Cluster ID", dataTypeClass=Integer.class, required=true)
    public Response<ClusterInfo> get(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster id cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.get(id, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/cluster/list"})
    @ApiOperation(value="List clusters")
    public Response<List<ClusterInfo>> list(@RequestBody ClusterPageRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        request.setIsAdminRole(Boolean.valueOf(LoginUserUtils.getLoginUser().getRoles().contains(TenantUserTypeEnum.TENANT_ADMIN.name())));
        return Response.success((Object)this.clusterService.list(request, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/cluster/save"})
    @ApiOperation(value="Save cluster")
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.CLUSTER)
    public Response<Integer> save(@Validated(value={SaveValidation.class}) @RequestBody ClusterRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.save(request, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/cluster/update"})
    @ApiOperation(value="Update cluster")
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.CLUSTER)
    public Response<Boolean> update(@Validated(value={UpdateByIdValidation.class}) @RequestBody ClusterRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.update(request, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/cluster/bindTag"})
    @ApiOperation(value="Bind or unbind cluster tag")
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.CLUSTER)
    public Response<Boolean> bindTag(@Validated @RequestBody BindTagRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.bindTag(request, LoginUserUtils.getLoginUser()));
    }

    @DeleteMapping(value={"/cluster/delete/{id}"})
    @ApiOperation(value="Delete cluster by id")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.CLUSTER)
    @ApiImplicitParam(name="id", value="Cluster ID", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> delete(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster id cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.delete(id, LoginUserUtils.getLoginUser()));
    }

    @GetMapping(value={"/cluster/node/get/{id}"})
    @ApiOperation(value="Get cluster node by id")
    @ApiImplicitParam(name="id", value="Cluster node ID", dataTypeClass=Integer.class, required=true)
    public Response<ClusterNodeResponse> getNode(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"Cluster node id cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.getNode(id, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/cluster/node/list"})
    @ApiOperation(value="List cluster nodes")
    public Response<List<ClusterNodeResponse>> listNode(@RequestBody ClusterPageRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.listNode(request, LoginUserUtils.getLoginUser()));
    }

    @GetMapping(value={"/cluster/node/listByGroupId"})
    @ApiOperation(value="List cluster nodes by groupId, clusterType and protocolType")
    @ApiImplicitParams(value={@ApiImplicitParam(name="inlongGroupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="clusterType", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="protocolType", dataTypeClass=String.class, required=false)})
    @OperationLog(operation=OperationType.GET, operationTarget=OperationTarget.CLUSTER)
    public Response<List<ClusterNodeResponse>> listByGroupId(@RequestParam String inlongGroupId, @RequestParam String clusterType, @RequestParam(required=false) String protocolType) {
        Preconditions.expectNotBlank((String)inlongGroupId, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlongGroupId cannot be blank");
        Preconditions.expectNotBlank((String)clusterType, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"clusterType cannot be blank");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.listNodeByGroupId(inlongGroupId, clusterType, protocolType, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/cluster/node/save"})
    @ApiOperation(value="Save cluster node")
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.CLUSTER)
    public Response<Integer> saveNode(@Validated @RequestBody ClusterNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.saveNode(request, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/cluster/node/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.CLUSTER)
    @ApiOperation(value="Update cluster node")
    public Response<Boolean> updateNode(@Validated(value={UpdateValidation.class}) @RequestBody ClusterNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.updateNode(request, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/cluster/node/delete/{id}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete cluster node")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.CLUSTER)
    @ApiImplicitParam(name="id", value="Cluster node ID", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> deleteNode(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster id cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.clusterService.deleteNode(id, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/cluster/tenant/tag/save"})
    @ApiOperation(value="Save tenant cluster tag")
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.CLUSTER)
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Integer> saveTenantTag(@Validated(value={SaveValidation.class}) @RequestBody TenantClusterTagRequest request) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.saveTenantTag(request, currentUser));
    }

    @PostMapping(value={"/cluster/tenant/tag/list"})
    @ApiOperation(value="List tenant cluster tags")
    public Response<PageResult<TenantClusterTagInfo>> listTenantTag(@RequestBody TenantClusterTagPageRequest request) {
        return Response.success((Object)this.clusterService.listTenantTag(request));
    }

    @PostMapping(value={"/cluster/tag/listTagByTenantRole"})
    @ApiOperation(value="List cluster tags by tenant condition")
    public Response<PageResult<ClusterTagResponse>> listTagByTenantRole(@RequestBody TenantClusterTagPageRequest request) {
        return Response.success((Object)this.clusterService.listTagByTenantRole(request));
    }

    @PostMapping(value={"/cluster/listByTenantRole"})
    @ApiOperation(value="List cluster by tenant condition")
    public Response<PageResult<ClusterInfo>> listByTenantRole(@RequestBody ClusterPageRequest request) {
        return Response.success((Object)this.clusterService.listByTenantRole(request));
    }

    @DeleteMapping(value={"/cluster/tenant/tag/delete/{id}"})
    @ApiOperation(value="Delete tenant cluster tag by id")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.CLUSTER)
    @ApiImplicitParam(name="id", value="Cluster tag ID", dataTypeClass=Integer.class, required=true)
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Boolean> deleteTenantTag(@PathVariable Integer id) {
        return Response.success((Object)this.clusterService.deleteTenantTag(id, LoginUserUtils.getLoginUser().getName()));
    }
}

