/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.network.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryUtils.class);
    private static final String GET_MANAGER_IP_LIST_API = "/inlong/manager/openapi/agent/getManagerIpList";
    private static String latestManagerIPList = "";
    private static String arraySed = ",";

    public static String getManagerIpList(ProxyClientConfig clientConfig) {
        String managerAddress = clientConfig.getManagerIP() + ":" + clientConfig.getManagerPort();
        if (StringUtils.isBlank(managerAddress)) {
            log.error("ServiceDiscovery get managerIpList but managerAddress is blank, just return");
            return null;
        }
        String managerIpList = ServiceDiscoveryUtils.getManagerIpListByHttp(managerAddress, clientConfig);
        if (StringUtils.isNotBlank(managerIpList)) {
            latestManagerIPList = managerIpList;
            return managerIpList;
        }
        log.error("ServiceDiscovery get managerIpList from {} occur error, try to get from latestManagerIPList", (Object)managerAddress);
        String[] managerIps = latestManagerIPList.split(arraySed);
        if (managerIps.length > 0) {
            for (String managerIp : managerIps) {
                if (StringUtils.isBlank(managerIp)) {
                    log.error("ServiceDiscovery managerIp is null, latestManagerIPList is {}", (Object)latestManagerIPList);
                    continue;
                }
                String currentAddress = managerIp + ":" + clientConfig.getManagerPort();
                managerIpList = ServiceDiscoveryUtils.getManagerIpListByHttp(currentAddress, clientConfig);
                if (StringUtils.isBlank(managerIpList)) {
                    log.error("ServiceDiscovery get latestManagerIPList from {} but got nothing, will try next ip", (Object)managerIp);
                    continue;
                }
                latestManagerIPList = managerIpList;
                return managerIpList;
            }
        } else {
            log.error("ServiceDiscovery latestManagerIpList {} format error, or not contain ip", (Object)latestManagerIPList);
        }
        String existedIpList = ServiceDiscoveryUtils.getLocalManagerIpList(clientConfig.getManagerIpLocalPath());
        if (StringUtils.isNotBlank(existedIpList)) {
            String[] existedIps = existedIpList.split(arraySed);
            if (existedIps.length > 0) {
                for (String existedIp : existedIps) {
                    if (StringUtils.isBlank(existedIp)) {
                        log.error("ServiceDiscovery get illegal format ipList from local file, exist ip is empty, managerIpList is {}, local file is {}", (Object)existedIpList, (Object)clientConfig.getManagerIpLocalPath());
                        continue;
                    }
                    String currentAddress = existedIp + ":" + clientConfig.getManagerPort();
                    managerIpList = ServiceDiscoveryUtils.getManagerIpListByHttp(currentAddress, clientConfig);
                    if (StringUtils.isBlank(managerIpList)) {
                        log.error("ServiceDiscovery get {} from local file {} but got nothing, will try next ip", (Object)existedIp, (Object)clientConfig.getManagerIpLocalPath());
                        continue;
                    }
                    latestManagerIPList = managerIpList;
                    return managerIpList;
                }
            } else {
                log.error("ServiceDiscovery get illegal format ipList from local file, exist ip is empty, managerIpList is {}, local file is {}", (Object)existedIpList, (Object)clientConfig.getManagerIpLocalPath());
            }
        } else {
            log.error("ServiceDiscovery get empty ipList from local file {}", (Object)clientConfig.getManagerIpLocalPath());
        }
        return managerIpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getManagerIpListByHttp(String managerIp, ProxyClientConfig proxyClientConfig) {
        DefaultHttpClient httpClient;
        String url = (proxyClientConfig.isLocalVisit() ? "http://" : "https://") + managerIp + GET_MANAGER_IP_LIST_API;
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("operation", "query"));
        params.add(new BasicNameValuePair("username", proxyClientConfig.getUserName()));
        log.info("Begin to get configure from manager {}, param is {}", (Object)url, params);
        BasicHttpParams myParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)myParams, (int)proxyClientConfig.getManagerConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)myParams, (int)proxyClientConfig.getManagerSocketTimeout());
        if (proxyClientConfig.isLocalVisit()) {
            httpClient = new DefaultHttpClient((HttpParams)myParams);
        } else {
            try {
                ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
                for (BasicNameValuePair paramItem : params) {
                    headers.add(new BasicHeader(paramItem.getName(), paramItem.getValue()));
                }
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(30000).build();
                SSLContext sslContext = SSLContexts.custom().build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
                httpClient = HttpClients.custom().setDefaultHeaders(headers).setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            }
            catch (Throwable t) {
                log.error("Create Https client failed: ", t);
                return null;
            }
        }
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(url);
            if (proxyClientConfig.isNeedAuthentication()) {
                long timestamp = System.currentTimeMillis();
                int nonce = new SecureRandom(String.valueOf(timestamp).getBytes()).nextInt(Integer.MAX_VALUE);
                httpPost.setHeader("authorization", Utils.getAuthorizenInfo(proxyClientConfig.getUserName(), proxyClientConfig.getSecretKey(), timestamp, nonce));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (Utils.isNotBlank(returnStr) && response.getStatusLine().getStatusCode() == 200) {
                log.info("Get configure from manager is " + returnStr);
                JsonParser jsonParser = new JsonParser();
                JsonObject jb = jsonParser.parse(returnStr).getAsJsonObject();
                if (jb == null) {
                    log.warn("ServiceDiscovery updated manager ip failed, returnStr = {} jb is null ", (Object)returnStr, (Object)jb);
                    String string = null;
                    return string;
                }
                JsonArray retData = jb.get("data").getAsJsonArray();
                ArrayList<String> managerIpList = new ArrayList<String>();
                for (JsonElement datum : retData) {
                    JsonObject record = datum.getAsJsonObject();
                    managerIpList.add(record.get("ip").getAsString());
                }
                if (managerIpList.isEmpty()) {
                    Iterator iterator = null;
                    return iterator;
                }
                String strIPs = String.join((CharSequence)",", managerIpList);
                log.info("ServiceDiscovery updated manager ip success, ip : " + strIPs + ", retStr : " + returnStr);
                String string = strIPs;
                return string;
            }
            String string = null;
            return string;
        }
        catch (Throwable t) {
            log.error("Connect Manager error: ", t);
            String string = null;
            return string;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    public static String getLocalManagerIpList(String localPath) {
        log.info("ServiceDiscovery start loading config from file {} ...", (Object)localPath);
        String newestIp = null;
        try {
            File managerIpListFile = new File(localPath);
            if (!managerIpListFile.exists()) {
                log.info("ServiceDiscovery not found local groupIdInfo file from {}", (Object)localPath);
                return null;
            }
            byte[] serialized = FileUtils.readFileToByteArray((File)managerIpListFile);
            if (serialized == null) {
                return null;
            }
            newestIp = new String(serialized, StandardCharsets.UTF_8);
            log.info("ServiceDiscovery get manager ip list from local success, result is: {}", (Object)newestIp);
        }
        catch (IOException e) {
            log.error("ServiceDiscovery load manager config error: ", (Throwable)e);
        }
        return newestIp;
    }

    public static void updateManagerInfo2Local(String storeString, String path) {
        if (StringUtils.isBlank(storeString)) {
            log.warn("ServiceDiscovery updateTdmInfo2Local error, configMap is empty or managerIpList is blank");
            return;
        }
        File localPath = new File(path);
        if (!localPath.getParentFile().exists()) {
            localPath.getParentFile().mkdirs();
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(localPath), StandardCharsets.UTF_8));){
            writer.write(storeString);
            writer.flush();
        }
        catch (IOException e) {
            log.error("ServiceDiscovery save manager config error: ", (Throwable)e);
        }
    }
}

