/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.utils;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    public static final Logger LOG = LoggerFactory.getLogger(IpUtils.class);
    private static String localIPAddress = null;
    private static byte[] localIPAddressBytes = null;

    public static String getLocalAddress() {
        if (localIPAddress != null) {
            return localIPAddress;
        }
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            InetAddress ipv6Address = null;
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                while (en.hasMoreElements()) {
                    byte firstByte;
                    InetAddress address = en.nextElement();
                    if (address.isLoopbackAddress()) continue;
                    if (address instanceof Inet6Address) {
                        ipv6Address = address;
                        return IpUtils.normalizeHostAddress(ipv6Address);
                    }
                    byte[] ipBytes = address.getAddress();
                    if (ipBytes.length <= 0 || ((firstByte = ipBytes[0]) <= 0 || firstByte > 30) && firstByte != 100) continue;
                    return IpUtils.normalizeHostAddress(address);
                }
            }
            InetAddress localHost = InetAddress.getLocalHost();
            localIPAddress = IpUtils.normalizeHostAddress(localHost);
            return localIPAddress;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return "127.0.0.1";
        }
    }

    public static byte[] getLocalAddressBytes() throws Exception {
        if (localIPAddressBytes != null) {
            return localIPAddressBytes;
        }
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        InetAddress ipv6Address = null;
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> en = networkInterface.getInetAddresses();
            while (en.hasMoreElements()) {
                byte firstByte;
                InetAddress address = en.nextElement();
                if (address.isLoopbackAddress()) continue;
                if (address instanceof Inet6Address) {
                    ipv6Address = address;
                    return ipv6Address.getAddress();
                }
                byte[] ipBytes = address.getAddress();
                if (ipBytes.length <= 0 || ((firstByte = ipBytes[0]) <= 0 || firstByte > 30) && firstByte != 100) continue;
                return ipBytes;
            }
        }
        InetAddress localHost = InetAddress.getLocalHost();
        localIPAddressBytes = localHost.getAddress();
        return localIPAddressBytes;
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    public static byte[] toBytes(String ipAddr) {
        byte[] ret = new byte[4];
        try {
            String[] ipArr = ipAddr.split("\\.");
            ret[0] = (byte)(Integer.parseInt(ipArr[0]) & 0xFF);
            ret[1] = (byte)(Integer.parseInt(ipArr[1]) & 0xFF);
            ret[2] = (byte)(Integer.parseInt(ipArr[2]) & 0xFF);
            ret[3] = (byte)(Integer.parseInt(ipArr[3]) & 0xFF);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ipAddr + " is invalid IP");
        }
    }

    public static int bytesToInt(byte[] bytes) {
        int addr = bytes[3] & 0xFF;
        addr |= bytes[2] << 8 & 0xFF00;
        addr |= bytes[1] << 16 & 0xFF0000;
        return addr |= bytes[0] << 24 & 0xFF000000;
    }

    public static int ipToInt(String ipAddr) {
        try {
            return IpUtils.bytesToInt(IpUtils.toBytes(ipAddr));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ipAddr + " is invalid IP");
        }
    }

    public static String intToIp(int ipInt) {
        return "" + (ipInt >> 24 & 0xFF) + '.' + (ipInt >> 16 & 0xFF) + '.' + (ipInt >> 8 & 0xFF) + '.' + (ipInt & 0xFF);
    }
}

