/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.threads;

import java.io.Closeable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.common.FileCallback;
import org.apache.inlong.sdk.dataproxy.common.SendResult;
import org.apache.inlong.sdk.dataproxy.metric.MessageRecord;
import org.apache.inlong.sdk.dataproxy.metric.MetricTimeNumSummary;
import org.apache.inlong.sdk.dataproxy.network.Sender;
import org.apache.inlong.sdk.dataproxy.network.SequentialID;
import org.apache.inlong.sdk.dataproxy.network.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricWorkerThread
extends Thread
implements Closeable {
    private static final String DEFAULT_KEY_ITEM = "";
    private static final String DEFAULT_KEY_SPLITTER = "#";
    private final Logger logger = LoggerFactory.getLogger(MetricWorkerThread.class);
    private final SequentialID idGenerator = new SequentialID(Utils.getLocalIp());
    private final ConcurrentHashMap<String, MessageRecord> metricValueCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MetricTimeNumSummary> metricPackTimeMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MetricTimeNumSummary> metricDtMap = new ConcurrentHashMap();
    private final ProxyClientConfig proxyClientConfig;
    private final long delayTime;
    private final Sender sender;
    private final boolean enableSlaMetric;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean bShutdown = false;

    public MetricWorkerThread(ProxyClientConfig proxyClientConfig, Sender sender) {
        this.proxyClientConfig = proxyClientConfig;
        this.enableSlaMetric = proxyClientConfig.isEnableSlaMetric();
        this.delayTime = 20000L;
        this.sender = sender;
        this.setDaemon(true);
        this.setName("MetricWorkerThread");
    }

    public long getFormatKeyTime(long keyTime) {
        return keyTime - keyTime % (long)this.proxyClientConfig.getMetricIntervalInMs();
    }

    private String getKeyStringByConfig(String groupId, String streamId, String localIp, long keyTime) {
        StringBuilder builder = new StringBuilder();
        String groupIdStr = this.proxyClientConfig.isUseGroupIdAsKey() ? groupId : DEFAULT_KEY_ITEM;
        String streamIdStr = this.proxyClientConfig.isUseStreamIdAsKey() ? streamId : DEFAULT_KEY_ITEM;
        String localIpStr = this.proxyClientConfig.isUseLocalIpAsKey() ? localIp : DEFAULT_KEY_ITEM;
        builder.append(groupIdStr).append(DEFAULT_KEY_SPLITTER).append(streamIdStr).append(DEFAULT_KEY_SPLITTER).append(localIpStr).append(DEFAULT_KEY_SPLITTER).append(keyTime);
        return builder.toString();
    }

    public void recordNumByKey(String msgId, String groupId, String streamId, String localIp, long packTime, long dt, int num) {
        if (!this.enableSlaMetric) {
            return;
        }
        MessageRecord messageRecord = new MessageRecord(groupId, streamId, localIp, msgId, this.getFormatKeyTime(dt), this.getFormatKeyTime(packTime), num);
        this.metricValueCache.putIfAbsent(msgId, messageRecord);
    }

    private MetricTimeNumSummary getMetricSummary(String keyName, MetricTimeNumSummary summary, ConcurrentHashMap<String, MetricTimeNumSummary> cacheMap) {
        MetricTimeNumSummary finalSummary = cacheMap.putIfAbsent(keyName, summary);
        if (finalSummary == null) {
            finalSummary = summary;
        }
        return finalSummary;
    }

    public void recordSuccessByMessageId(String msgId) {
        if (!this.enableSlaMetric) {
            return;
        }
        MessageRecord messageRecord = this.metricValueCache.remove(msgId);
        if (messageRecord != null) {
            String packTimeKeyName = this.getKeyStringByConfig(messageRecord.getGroupId(), messageRecord.getStreamId(), messageRecord.getLocalIp(), messageRecord.getPackTime());
            String dtKeyName = this.getKeyStringByConfig(messageRecord.getGroupId(), messageRecord.getStreamId(), messageRecord.getLocalIp(), messageRecord.getDt());
            MetricTimeNumSummary packTimeSummary = this.getMetricSummary(packTimeKeyName, new MetricTimeNumSummary(messageRecord.getPackTime()), this.metricPackTimeMap);
            MetricTimeNumSummary dtSummary = this.getMetricSummary(dtKeyName, new MetricTimeNumSummary(messageRecord.getDt()), this.metricDtMap);
            packTimeSummary.recordSuccessSendTime(messageRecord.getMessageTime(), messageRecord.getMsgCount());
            dtSummary.increaseSuccessNum(messageRecord.getMsgCount());
        }
    }

    public void recordFailedByMessageId(String msgId) {
        MessageRecord messageRecord = this.metricValueCache.remove(msgId);
        if (messageRecord != null) {
            String packTimeKeyName = this.getKeyStringByConfig(messageRecord.getGroupId(), messageRecord.getStreamId(), messageRecord.getLocalIp(), messageRecord.getPackTime());
            String dtKeyName = this.getKeyStringByConfig(messageRecord.getGroupId(), messageRecord.getStreamId(), messageRecord.getLocalIp(), messageRecord.getDt());
            MetricTimeNumSummary packTimeSummary = this.getMetricSummary(packTimeKeyName, new MetricTimeNumSummary(messageRecord.getMessageTime()), this.metricPackTimeMap);
            MetricTimeNumSummary dtSummary = this.getMetricSummary(dtKeyName, new MetricTimeNumSummary(messageRecord.getDt()), this.metricDtMap);
            packTimeSummary.increaseFailedNum(messageRecord.getMsgCount());
            dtSummary.increaseFailedNum(messageRecord.getMsgCount());
        }
    }

    @Override
    public void close() {
        this.bShutdown = true;
        this.flushMetric(true);
    }

    @Override
    public void run() {
        this.logger.info("MetricWorkerThread Thread=" + Thread.currentThread().getId() + " started!");
        while (!this.bShutdown) {
            try {
                this.checkCacheRecords();
                this.flushMetric(false);
                TimeUnit.MILLISECONDS.sleep(this.proxyClientConfig.getMetricIntervalInMs());
            }
            catch (Exception exception) {}
        }
    }

    private void tryToSendMetricToManager(EncodeObject encodeObject, MetricSendCallBack callBack) {
        callBack.increaseRetry();
        try {
            if (callBack.getRetryCount() < 4) {
                this.sender.asyncSendMessageIndex(encodeObject, callBack, String.valueOf(System.currentTimeMillis()), 20L, TimeUnit.SECONDS);
            } else {
                this.logger.error("error while sending {} {}", (Object)encodeObject.getBodyBytes(), encodeObject.getBodylist());
            }
        }
        catch (Exception ex) {
            this.logger.warn("exception caught {}", (Object)ex.getMessage());
            this.tryToSendMetricToManager(encodeObject, callBack);
        }
    }

    private void sendSingleLine(String line, String streamId, long dtTime) {
        EncodeObject encodeObject = new EncodeObject(line.getBytes(), 7, false, false, false, dtTime, this.idGenerator.getNextInt(), this.proxyClientConfig.getMetricGroupId(), streamId, DEFAULT_KEY_ITEM, DEFAULT_KEY_ITEM, Utils.getLocalIp());
        MetricSendCallBack callBack = new MetricSendCallBack(encodeObject);
        this.tryToSendMetricToManager(encodeObject, callBack);
    }

    private void flushMapRecords(boolean isClosing, ConcurrentHashMap<String, MetricTimeNumSummary> cacheMap) {
        for (String keyName : cacheMap.keySet()) {
            MetricTimeNumSummary summary = cacheMap.get(keyName);
            if (!isClosing && (summary == null || summary.getSummaryTime() + this.delayTime <= (long)this.proxyClientConfig.getMetricIntervalInMs()) || (summary = cacheMap.remove(keyName)) == null) continue;
            long metricDtTime = summary.getStartCalculateTime() / 1000L;
            String countLine = keyName + DEFAULT_KEY_SPLITTER + summary.getSuccessNum() + DEFAULT_KEY_SPLITTER + summary.getFailedNum() + DEFAULT_KEY_SPLITTER + summary.getTotalNum();
            String timeLine = keyName + DEFAULT_KEY_SPLITTER + summary.getTimeString();
            this.logger.info("sending {}", (Object)countLine);
            this.logger.info("sending {}", (Object)timeLine);
            this.sendSingleLine(countLine, "count", metricDtTime);
            this.sendSingleLine(timeLine, "time", metricDtTime);
        }
    }

    private void flushRecords(boolean isClosing) {
        this.flushMapRecords(isClosing, this.metricDtMap);
        this.flushMapRecords(isClosing, this.metricPackTimeMap);
    }

    private void checkCacheRecords() {
        for (String msgId : this.metricValueCache.keySet()) {
            MessageRecord record = this.metricValueCache.get(msgId);
            if (record == null || record.getMessageTime() + this.delayTime <= (long)this.proxyClientConfig.getMetricIntervalInMs()) continue;
            this.recordFailedByMessageId(msgId);
        }
    }

    private void flushMetric(boolean isClosing) {
        this.lock.writeLock().lock();
        try {
            this.flushRecords(isClosing);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private class MetricSendCallBack
    extends FileCallback {
        private final EncodeObject encodeObject;
        private int retryCount = 0;

        public MetricSendCallBack(EncodeObject encodeObject) {
            this.encodeObject = encodeObject;
        }

        public void increaseRetry() {
            ++this.retryCount;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        @Override
        public void onMessageAck(String result) {
            if (!SendResult.OK.toString().equals(result)) {
                MetricWorkerThread.this.tryToSendMetricToManager(this.encodeObject, this);
            } else {
                MetricWorkerThread.this.logger.info("metric is ok");
            }
        }

        @Override
        public void onMessageAck(SendResult result) {
        }
    }
}

