/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.threads;

import java.util.concurrent.TimeUnit;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.utils.ServiceDiscoveryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerFetcherThread
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(ManagerFetcherThread.class);
    private volatile boolean isShutdown = false;
    private final ProxyClientConfig proxyClientConfig;

    public ManagerFetcherThread(ProxyClientConfig proxyClientConfig) {
        this.proxyClientConfig = proxyClientConfig;
        this.setDaemon(true);
        this.setName("ManagerFetcherThread");
    }

    public void shutdown() {
        this.logger.info("Begin to shutdown ManagerFetcherThread.");
        this.isShutdown = true;
    }

    @Override
    public void run() {
        this.logger.info("ManagerFetcherThread Thread=" + Thread.currentThread().getId() + " started !");
        while (!this.isShutdown) {
            try {
                String managerIpList = ServiceDiscoveryUtils.getManagerIpList(this.proxyClientConfig);
                if (StringUtils.isBlank(managerIpList)) {
                    this.logger.error("ManagerFetcher get managerIpList is blank.");
                } else {
                    ServiceDiscoveryUtils.updateManagerInfo2Local(managerIpList, this.proxyClientConfig.getManagerIpLocalPath());
                }
                TimeUnit.MILLISECONDS.sleep((long)this.proxyClientConfig.getProxyUpdateIntervalMinutes() * 60L * 1000L);
            }
            catch (Throwable e) {
                this.logger.error("ManagerFetcher get or save managerIpList occur error,", e);
            }
        }
    }
}

