/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.threads;

import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCollectThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IndexCollectThread.class);
    private final Map<String, Long> storeIndex;
    private volatile boolean bShutDown = false;

    public IndexCollectThread(Map<String, Long> storeIndex) {
        this.storeIndex = storeIndex;
        this.setDaemon(true);
        this.setName("IndexCollectThread");
    }

    public void shutDown() {
        logger.info("begin to shut down IndexCollectThread!");
        this.bShutDown = true;
    }

    @Override
    public void run() {
        logger.info("IndexCollectThread Thread=" + Thread.currentThread().getId() + " started !");
        while (!this.bShutDown) {
            try {
                TimeUnit.MILLISECONDS.sleep(60000L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (Map.Entry<String, Long> entry : this.storeIndex.entrySet()) {
                    String key = entry.getKey();
                    Long val = entry.getValue();
                    key = "|" + sdf.format(System.currentTimeMillis()) + "|" + key;
                    logger.info("Monitor {} send message {}", (Object)key, (Object)val);
                    entry.setValue(0L);
                }
            }
            catch (Exception e) {
                if (this.bShutDown) continue;
                logger.error("IndexCollectThread exception", (Throwable)e);
            }
        }
    }
}

