/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.network;

import java.net.InetSocketAddress;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.math.NumberUtils;

public class IpPort {
    public final String ip;
    public final int port;
    public final String key;
    public final InetSocketAddress addr;

    public IpPort() {
        this("127.0.0.1", 0);
    }

    public IpPort(String ip, int port) {
        this.ip = ip;
        this.port = port;
        this.key = IpPort.getIpPortKey(ip, port);
        this.addr = new InetSocketAddress(ip, port);
    }

    public IpPort(InetSocketAddress addr) {
        this.ip = addr.getHostName();
        this.port = addr.getPort();
        this.key = IpPort.getIpPortKey(this.ip, this.port);
        this.addr = addr;
    }

    public static String getIpPortKey(String ip, int port) {
        return ip + ":" + port;
    }

    public int hashCode() {
        int result = this.ip.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!(o instanceof IpPort)) {
            return false;
        }
        try {
            IpPort ctp = (IpPort)o;
            if (this.ip != null && this.ip.equals(ctp.ip) && this.port == ctp.port) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static IpPort parseIpPort(String ipPort) {
        String[] splits = ipPort.split(":");
        if (splits.length == 2) {
            String strIp = splits[0];
            String strPort = splits[1];
            int port = NumberUtils.toInt(strPort, 0);
            if (port > 0) {
                return new IpPort(strIp, port);
            }
        }
        return null;
    }

    public String toString() {
        return this.key;
    }
}

