/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.metrics;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.Event;
import org.apache.inlong.common.metric.CountMetric;
import org.apache.inlong.common.metric.Dimension;
import org.apache.inlong.common.metric.MetricDomain;
import org.apache.inlong.common.metric.MetricItem;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.math.NumberUtils;
import org.apache.inlong.sdk.dataproxy.pb.metrics.SdkMetricItemSet;

@MetricDomain(name="ProxySdk")
public class SdkMetricItem
extends MetricItem {
    public static final String KEY_NODE_ID = "nodeId";
    public static final String KEY_NODE_IP = "nodeIp";
    public static final String KEY_INLONG_GROUP_ID = "inlongGroupId";
    public static final String KEY_INLONG_STREAM_ID = "inlongStreamId";
    public static final String KEY_SINK_ID = "sinkId";
    public static final String KEY_MESSAGE_TIME = "msgTime";
    public static final String M_READ_SUCCESS_COUNT = "readSuccessCount";
    public static final String M_READ_SUCCESS_SIZE = "readSuccessSize";
    public static final String M_READ_FAIL_COUNT = "readFailCount";
    public static final String M_READ_FAIL_SIZE = "readFailSize";
    public static final String M_SEND_COUNT = "sendCount";
    public static final String M_SEND_SIZE = "sendSize";
    public static final String M_SEND_SUCCESS_COUNT = "sendSuccessCount";
    public static final String M_SEND_SUCCESS_SIZE = "sendSuccessSize";
    public static final String M_SEND_FAIL_COUNT = "sendFailCount";
    public static final String M_SEND_FAIL_SIZE = "sendFailSize";
    public static final String M_SINK_DURATION = "sinkDuration";
    public static final String M_NODE_DURATION = "nodeDuration";
    public static final String M_WHOLE_DURATION = "wholeDuration";
    @Dimension
    public String nodeId;
    @Dimension
    public String nodeIp;
    @Dimension
    public String inlongGroupId;
    @Dimension
    public String inlongStreamId;
    @Dimension
    public String sinkId;
    @Dimension
    public String msgTime = String.valueOf(0);
    @CountMetric
    public AtomicLong readSuccessCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong readSuccessSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong readFailCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong readFailSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendSuccessCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendSuccessSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendFailCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendFailSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sinkDuration = new AtomicLong(0L);
    @CountMetric
    public AtomicLong nodeDuration = new AtomicLong(0L);
    @CountMetric
    public AtomicLong wholeDuration = new AtomicLong(0L);

    public static void fillInlongId(Event event, Map<String, String> dimensions) {
        Map headers = event.getHeaders();
        String inlongGroupId = SdkMetricItem.getInlongGroupId(headers);
        String inlongStreamId = SdkMetricItem.getInlongStreamId(headers);
        dimensions.put(KEY_INLONG_GROUP_ID, inlongGroupId);
        dimensions.put(KEY_INLONG_STREAM_ID, inlongStreamId);
    }

    public static String getInlongGroupId(Map<String, String> headers) {
        String inlongGroupId = headers.get(KEY_INLONG_GROUP_ID);
        if (inlongGroupId == null) {
            inlongGroupId = headers.getOrDefault("topic", "");
        }
        return inlongGroupId;
    }

    public static String getInlongStreamId(Map<String, String> headers) {
        String inlongStreamId = headers.get(KEY_INLONG_STREAM_ID);
        if (inlongStreamId == null) {
            inlongStreamId = headers.getOrDefault("streamId", "");
        }
        return inlongStreamId;
    }

    public static long getLogTime(Map<String, String> headers) {
        String strLogTime = headers.get(KEY_MESSAGE_TIME);
        if (strLogTime == null) {
            strLogTime = headers.get("dt");
        }
        if (strLogTime == null) {
            return System.currentTimeMillis();
        }
        long logTime = NumberUtils.toLong(strLogTime, 0L);
        if (logTime == 0L) {
            logTime = System.currentTimeMillis();
        }
        return logTime;
    }

    public static long getLogTime(Event event) {
        if (event != null) {
            Map headers = event.getHeaders();
            return SdkMetricItem.getLogTime(headers);
        }
        return System.currentTimeMillis();
    }

    public static void reportDurations(Event currentRecord, boolean result, long sendTime, Map<String, String> dimensions, long msgTime, SdkMetricItemSet metricItemSet) {
        SdkMetricItem metricItem = (SdkMetricItem)metricItemSet.findMetricItem(dimensions);
        if (result) {
            metricItem.sendSuccessCount.incrementAndGet();
            metricItem.sendSuccessSize.addAndGet(currentRecord.getBody().length);
            if (sendTime > 0L) {
                long currentTime = System.currentTimeMillis();
                long sinkDuration = currentTime - sendTime;
                long nodeDuration = currentTime - NumberUtils.toLong("sourceTime", msgTime);
                long wholeDuration = currentTime - msgTime;
                metricItem.sinkDuration.addAndGet(sinkDuration);
                metricItem.nodeDuration.addAndGet(nodeDuration);
                metricItem.wholeDuration.addAndGet(wholeDuration);
            }
        } else {
            metricItem.sendFailCount.incrementAndGet();
            metricItem.sendFailSize.addAndGet(currentRecord.getBody().length);
        }
    }
}

