/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.dispatch;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flume.Context;
import org.apache.inlong.sdk.commons.protocol.SdkEvent;
import org.apache.inlong.sdk.dataproxy.pb.context.ProfileEvent;
import org.apache.inlong.sdk.dataproxy.pb.dispatch.DispatchProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchManager {
    public static final Logger LOG = LoggerFactory.getLogger(DispatchManager.class);
    public static final String KEY_DISPATCH_TIMEOUT = "dispatchTimeout";
    public static final String KEY_DISPATCH_MAX_PACKCOUNT = "dispatchMaxPackCount";
    public static final String KEY_DISPATCH_MAX_PACKSIZE = "dispatchMaxPackSize";
    public static final long DEFAULT_DISPATCH_TIMEOUT = 2000L;
    public static final long DEFAULT_DISPATCH_MAX_PACKCOUNT = 256L;
    public static final long DEFAULT_DISPATCH_MAX_PACKSIZE = 327680L;
    public static final long MINUTE_MS = 60000L;
    private LinkedBlockingQueue<DispatchProfile> dispatchQueue;
    private final long dispatchTimeout;
    private final long maxPackCount;
    private final long maxPackSize;
    private ConcurrentHashMap<String, DispatchProfile> profileCache = new ConcurrentHashMap();
    private AtomicBoolean needOutputOvertimeData = new AtomicBoolean(false);

    public DispatchManager(Context context, LinkedBlockingQueue<DispatchProfile> dispatchQueue) {
        this.dispatchQueue = dispatchQueue;
        this.dispatchTimeout = context.getLong(KEY_DISPATCH_TIMEOUT, Long.valueOf(2000L));
        this.maxPackCount = context.getLong(KEY_DISPATCH_MAX_PACKCOUNT, Long.valueOf(256L));
        this.maxPackSize = context.getLong(KEY_DISPATCH_MAX_PACKSIZE, Long.valueOf(327680L));
    }

    public void addEvent(ProfileEvent event) {
        boolean addResult;
        if (this.needOutputOvertimeData.get()) {
            this.outputOvertimeData();
            this.needOutputOvertimeData.set(false);
        }
        SdkEvent sdkEvent = event.getProfile().getEvent();
        String eventUid = sdkEvent.getUid();
        long dispatchTime = sdkEvent.getMsgTime() - sdkEvent.getMsgTime() % 60000L;
        String dispatchKey = eventUid + "." + dispatchTime;
        DispatchProfile dispatchProfile = this.profileCache.get(dispatchKey);
        if (dispatchProfile == null) {
            dispatchProfile = new DispatchProfile(eventUid, sdkEvent.getInlongGroupId(), sdkEvent.getInlongStreamId(), dispatchTime);
            this.profileCache.put(dispatchKey, dispatchProfile);
        }
        if (!(addResult = dispatchProfile.addEvent(event, this.maxPackCount, this.maxPackSize))) {
            DispatchProfile newDispatchProfile = new DispatchProfile(eventUid, sdkEvent.getInlongGroupId(), sdkEvent.getInlongStreamId(), dispatchTime);
            DispatchProfile oldDispatchProfile = this.profileCache.put(dispatchKey, newDispatchProfile);
            this.dispatchQueue.offer(oldDispatchProfile);
            newDispatchProfile.addEvent(event, this.maxPackCount, this.maxPackSize);
        }
    }

    public void outputOvertimeData() {
        LOG.debug("start to outputOvertimeData profileCacheSize:{},dispatchQueueSize:{}", (Object)this.profileCache.size(), (Object)this.dispatchQueue.size());
        long currentTime = System.currentTimeMillis();
        long createThreshold = currentTime - this.dispatchTimeout;
        ArrayList<String> removeKeys = new ArrayList<String>();
        long eventCount = 0L;
        for (Map.Entry<String, DispatchProfile> entry : this.profileCache.entrySet()) {
            DispatchProfile dispatchProfile = entry.getValue();
            eventCount += dispatchProfile.getCount();
            if (!dispatchProfile.isTimeout(createThreshold)) continue;
            removeKeys.add(entry.getKey());
        }
        removeKeys.forEach(key -> this.dispatchQueue.offer(this.profileCache.remove(key)));
        LOG.debug("end to outputOvertimeData profileCacheSize:{},dispatchQueueSize:{},eventCount:{}", new Object[]{this.profileCache.size(), this.dispatchQueue.size(), eventCount});
    }

    public long getDispatchTimeout() {
        return this.dispatchTimeout;
    }

    public long getMaxPackCount() {
        return this.maxPackCount;
    }

    public long getMaxPackSize() {
        return this.maxPackSize;
    }

    public void setNeedOutputOvertimeData() {
        this.needOutputOvertimeData.set(true);
    }
}

