/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.config.pojo;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.InlongStreamConfig;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyNodeInfo;

public class ProxyClusterConfig {
    private String clusterId;
    private String regionId;
    private List<InlongStreamConfig> inlongStreamList;
    private List<ProxyNodeInfo> nodeList;
    private Map<String, String> proxyParams;

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public List<InlongStreamConfig> getInlongStreamList() {
        return this.inlongStreamList;
    }

    public void setInlongStreamList(List<InlongStreamConfig> inlongStreamList) {
        this.inlongStreamList = inlongStreamList;
    }

    public List<ProxyNodeInfo> getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(List<ProxyNodeInfo> nodeList) {
        this.nodeList = nodeList;
    }

    public Map<String, String> getProxyParams() {
        return this.proxyParams;
    }

    public void setProxyParams(Map<String, String> proxyParams) {
        this.proxyParams = proxyParams;
    }

    public static ProxyClusterConfig getExample() {
        ProxyClusterConfig config = new ProxyClusterConfig();
        config.setClusterId("inlong6th.sz.sz1");
        config.setRegionId("sz");
        config.setProxyParams(new HashMap<String, String>());
        config.getProxyParams().put("reloadInterval", "60000");
        config.setInlongStreamList(new ArrayList<InlongStreamConfig>());
        InlongStreamConfig streamConfig = new InlongStreamConfig();
        streamConfig.setInlongGroupId("inlongGroupId");
        streamConfig.setInlongStreamId("inlongStreamId");
        streamConfig.setStatus(0);
        streamConfig.setSampling(1);
        config.getInlongStreamList().add(streamConfig);
        config.setNodeList(new ArrayList<ProxyNodeInfo>());
        ProxyNodeInfo nodeInfo = new ProxyNodeInfo();
        nodeInfo.setNodeIp("127.0.0.1");
        nodeInfo.setNodePort(8080);
        config.getNodeList().add(nodeInfo);
        return config;
    }

    public static String generateMd5(ProxyClusterConfig config) {
        return DigestUtils.md5Hex((String)JSON.toJSONString((Object)config));
    }

    public static String generateMd5(List<ProxyClusterConfig> configList) {
        return DigestUtils.md5Hex((String)JSON.toJSONString(configList));
    }
}

