/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.config;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flume.Context;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.ClassUtils;
import org.apache.inlong.sdk.commons.protocol.InlongId;
import org.apache.inlong.sdk.dataproxy.pb.config.ContextProxyClusterConfigLoader;
import org.apache.inlong.sdk.dataproxy.pb.config.FileProxyClusterConfigLoader;
import org.apache.inlong.sdk.dataproxy.pb.config.LoaderType;
import org.apache.inlong.sdk.dataproxy.pb.config.ManagerProxyClusterConfigLoader;
import org.apache.inlong.sdk.dataproxy.pb.config.ProxyClusterConfigLoader;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.InlongStreamConfig;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyClusterConfig;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyClusterResult;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClusterConfigHolder {
    public static final Logger LOG = LoggerFactory.getLogger(ProxyClusterConfigHolder.class);
    private static ProxyClusterConfigHolder instance;
    protected Context context;
    private long reloadInterval;
    private Timer reloadTimer;
    private ProxyClusterConfigLoader loader;
    private Map<String, ProxyClusterResult> inlongStreamMap = new ConcurrentHashMap<String, ProxyClusterResult>();
    private Map<String, ProxyClusterResult> proxyClusterMap = new ConcurrentHashMap<String, ProxyClusterResult>();

    private ProxyClusterConfigHolder() {
    }

    private void configure(Context context) {
        this.context = context;
        this.reloadInterval = context.getLong("config.reloadInterval", Long.valueOf(60000L));
        String strLoaderType = context.getString("config.loaderType");
        LoaderType loaderType = LoaderType.valueOf(strLoaderType);
        switch (loaderType) {
            case File: {
                this.loader = new FileProxyClusterConfigLoader();
                break;
            }
            case Manager: {
                this.loader = new ManagerProxyClusterConfigLoader();
                break;
            }
            case Plugin: {
                try {
                    String strLoaderClass = context.getString("config.loaderType.pluginClass");
                    Class<?> loaderClass = ClassUtils.getClass(strLoaderClass);
                    Object loaderObject = loaderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!(loaderObject instanceof ManagerProxyClusterConfigLoader)) break;
                    this.loader = (ManagerProxyClusterConfigLoader)loaderObject;
                }
                catch (Throwable t) {
                    LOG.error("Fail to init loader,loaderType:{},error:{}", (Object)loaderType, (Object)t);
                }
                break;
            }
            default: {
                this.loader = new ContextProxyClusterConfigLoader();
            }
        }
        this.loader.configure(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(Context context) {
        if (instance != null) {
            return;
        }
        Class<ProxyClusterConfigHolder> clazz = ProxyClusterConfigHolder.class;
        synchronized (ProxyClusterConfigHolder.class) {
            try {
                if (instance != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                instance = new ProxyClusterConfigHolder();
                instance.configure(context);
                instance.reload();
                instance.setReloadTimer();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return;
        }
    }

    public static void close() {
        try {
            ProxyClusterConfigHolder.instance.reloadTimer.cancel();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setReloadTimer() {
        this.reloadTimer = new Timer(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    ProxyClusterConfigHolder.this.reload();
                }
                catch (Throwable e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        };
        this.reloadTimer.schedule(task, new Date(System.currentTimeMillis() + this.reloadInterval), this.reloadInterval);
    }

    private void reload() {
        Map<String, ProxyClusterResult> currentProxyMap = this.proxyClusterMap;
        ArrayList<ProxyInfo> proxys = new ArrayList<ProxyInfo>(currentProxyMap.size());
        for (Map.Entry<String, ProxyClusterResult> entry : currentProxyMap.entrySet()) {
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setClusterId(entry.getKey());
            proxyInfo.setMd5(entry.getValue().getMd5());
        }
        Map<String, ProxyClusterResult> newResultMap = this.loader.loadByClusterIds(proxys);
        if (newResultMap == null) {
            return;
        }
        ConcurrentHashMap<String, ProxyClusterResult> newProxyMap = new ConcurrentHashMap<String, ProxyClusterResult>();
        for (Map.Entry entry : newResultMap.entrySet()) {
            if (((ProxyClusterResult)entry.getValue()).isHasUpdated()) {
                newProxyMap.put((String)entry.getKey(), (ProxyClusterResult)entry.getValue());
                continue;
            }
            ProxyClusterResult oldResult = currentProxyMap.get(entry.getKey());
            if (oldResult == null) continue;
            newProxyMap.put(oldResult.getClusterId(), oldResult);
        }
        ConcurrentHashMap<String, ProxyClusterResult> newStreamMap = new ConcurrentHashMap<String, ProxyClusterResult>();
        for (Map.Entry entry : newProxyMap.entrySet()) {
            ProxyClusterResult result = (ProxyClusterResult)entry.getValue();
            for (InlongStreamConfig stream : result.getConfig().getInlongStreamList()) {
                String newUid = InlongId.generateUid(stream.getInlongGroupId(), stream.getInlongStreamId());
                newStreamMap.put(newUid, result);
            }
        }
        this.proxyClusterMap = newProxyMap;
        this.inlongStreamMap = newStreamMap;
    }

    public static ProxyClusterConfig getConfigByStream(String inlongGroupId, String inlongStreamId) {
        Map<String, ProxyClusterResult> currentStreamMap = ProxyClusterConfigHolder.instance.inlongStreamMap;
        String uid = InlongId.generateUid(inlongGroupId, inlongStreamId);
        ProxyClusterResult result = currentStreamMap.get(uid);
        if (result != null) {
            return result.getConfig();
        }
        result = ProxyClusterConfigHolder.instance.loader.loadByStream(inlongGroupId, inlongStreamId);
        if (result == null || result.getConfig() == null) {
            result = new ProxyClusterResult();
            result.setConfig(null);
            currentStreamMap.put(uid, result);
        } else {
            for (InlongStreamConfig stream : result.getConfig().getInlongStreamList()) {
                String newUid = InlongId.generateUid(stream.getInlongGroupId(), stream.getInlongStreamId());
                currentStreamMap.put(newUid, result);
            }
            ConcurrentHashMap<String, ProxyClusterResult> newProxyMap = new ConcurrentHashMap<String, ProxyClusterResult>();
            newProxyMap.putAll(ProxyClusterConfigHolder.instance.proxyClusterMap);
            newProxyMap.put(result.getClusterId(), result);
            ProxyClusterConfigHolder.instance.proxyClusterMap = newProxyMap;
        }
        return result.getConfig();
    }

    public static ProxyClusterConfig getConfigByClusterId(String clusterId) {
        ProxyClusterResult result = ProxyClusterConfigHolder.instance.proxyClusterMap.get(clusterId);
        if (result != null) {
            return result.getConfig();
        }
        return null;
    }

    public static Map<String, ProxyClusterResult> getInlongStreamMap() {
        return ProxyClusterConfigHolder.instance.inlongStreamMap;
    }

    public static Map<String, ProxyClusterResult> getProxyClusterMap() {
        return ProxyClusterConfigHolder.instance.proxyClusterMap;
    }
}

