/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.config;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.flume.Context;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.pb.config.ProxyClusterConfigLoader;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.GetProxyConfigBySdkResponse;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.InlongStreamConfig;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyClusterResult;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProxyClusterConfigLoader
implements ProxyClusterConfigLoader {
    private static Logger LOG = LoggerFactory.getLogger(FileProxyClusterConfigLoader.class);
    private Context context;

    public void configure(Context context) {
        this.context = context;
    }

    @Override
    public ProxyClusterResult loadByStream(String inlongGroupId, String inlongStreamId) {
        try {
            String fileName = this.context.getString("config.loaderType.fileName");
            String jsonString = FileUtils.readFileToString((File)new File(fileName), (Charset)Charset.defaultCharset());
            LOG.info("Get ProxyClusterConfigLoader result:{}", (Object)jsonString);
            GetProxyConfigBySdkResponse configResponse = (GetProxyConfigBySdkResponse)JSON.parseObject((String)jsonString, GetProxyConfigBySdkResponse.class);
            for (Map.Entry<String, ProxyClusterResult> entry : configResponse.getData().entrySet()) {
                for (InlongStreamConfig stream : entry.getValue().getConfig().getInlongStreamList()) {
                    if (!StringUtils.equals(inlongGroupId, stream.getInlongGroupId()) || !StringUtils.equals(inlongStreamId, stream.getInlongStreamId())) continue;
                    return entry.getValue();
                }
            }
            return null;
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ProxyClusterResult> loadByClusterIds(List<ProxyInfo> proxys) {
        Object httpPost = null;
        try {
            String fileName = this.context.getString("config.loaderType.fileName");
            String jsonString = FileUtils.readFileToString((File)new File(fileName), (Charset)Charset.defaultCharset());
            LOG.info("Get ProxyClusterConfigLoader result:{}", (Object)jsonString);
            GetProxyConfigBySdkResponse configResponse = (GetProxyConfigBySdkResponse)JSON.parseObject((String)jsonString, GetProxyConfigBySdkResponse.class);
            Map<String, ProxyClusterResult> map = configResponse.getData();
            return map;
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            Map<String, ProxyClusterResult> map = null;
            return map;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
    }
}

