/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.channel;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class SizeSemaphore {
    public static final int ONEKB = 1024;
    private int maxSize = 0;
    private int leftSize = 0;
    private Semaphore sizeSemaphore = null;
    private AtomicInteger leftSemaphore = new AtomicInteger(0);

    public SizeSemaphore(int maxSize, int leftSize) {
        this.maxSize = maxSize;
        this.leftSize = leftSize;
        this.sizeSemaphore = new Semaphore(maxSize, true);
    }

    public int leftSemaphore() {
        return this.leftSemaphore.get();
    }

    public int availablePermits() {
        return this.sizeSemaphore.availablePermits();
    }

    public int maxSize() {
        return this.maxSize;
    }

    public double getIdleRate() {
        double remaining = this.sizeSemaphore.availablePermits();
        return remaining * 100.0 / (double)this.maxSize;
    }

    public boolean tryAcquire(long sizeInByte) {
        int sizeInKb = (int)(sizeInByte / (long)this.leftSize);
        int sizeChange = (int)(sizeInByte % (long)this.leftSize);
        if (this.leftSemaphore.get() - sizeChange < 0) {
            boolean result = this.sizeSemaphore.tryAcquire(sizeInKb + 1);
            if (result) {
                this.leftSemaphore.addAndGet(-sizeChange + this.leftSize);
            }
            return result;
        }
        boolean result = this.sizeSemaphore.tryAcquire(sizeInKb);
        if (result) {
            this.leftSemaphore.addAndGet(-sizeChange);
        }
        return result;
    }

    public void acquire(long sizeInByte) {
        int sizeInKb = (int)(sizeInByte / (long)this.leftSize);
        int sizeChange = (int)(sizeInByte % (long)this.leftSize);
        if (this.leftSemaphore.get() - sizeChange < 0) {
            this.sizeSemaphore.acquireUninterruptibly(sizeInKb + 1);
            this.leftSemaphore.addAndGet(-sizeChange + this.leftSize);
        } else {
            this.sizeSemaphore.acquireUninterruptibly(sizeInKb);
            this.leftSemaphore.addAndGet(-sizeChange);
        }
    }

    public void release(long sizeInByte) {
        int sizeInKb = (int)(sizeInByte / (long)this.leftSize);
        int sizeChange = (int)(sizeInByte % (long)this.leftSize);
        if (this.leftSemaphore.get() + sizeChange > this.leftSize) {
            this.sizeSemaphore.release(sizeInKb + 1);
            this.leftSemaphore.addAndGet(sizeChange - this.leftSize);
        } else {
            this.sizeSemaphore.release(sizeInKb);
            this.leftSemaphore.addAndGet(sizeChange);
        }
    }
}

