/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb;

import org.apache.inlong.sdk.dataproxy.pb.SdkProxyChannelManager;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkSenderClientHandler
extends SimpleChannelHandler {
    public static final Logger LOG = LoggerFactory.getLogger(SdkSenderClientHandler.class);
    private SdkProxyChannelManager manager;

    public SdkSenderClientHandler(SdkProxyChannelManager manager) {
        this.manager = manager;
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.info("proxyClusterId:{},connect success:{}", (Object)this.manager.getProxyClusterId(), (Object)e);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            this.manager.onMessageReceived(ctx, e);
        }
        catch (Throwable ex) {
            LOG.error(ex.getMessage(), ex);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        LOG.error("proxyClusterId:{},exceptionCaught error:{}", (Object)this.manager.getProxyClusterId(), (Object)e.getCause());
        if (e.getCause() != null) {
            LOG.error(e.getCause().getMessage(), e.getCause());
        }
        try {
            Channel channel = this.getChannel(ctx, e);
            this.manager.setChannelException(channel);
            super.exceptionCaught(ctx, e);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            LOG.error(ex.getMessage(), ex);
        }
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.info("proxyClusterId:{},channel disconnect:{}", (Object)this.manager.getProxyClusterId(), (Object)e);
        try {
            Channel channel = this.getChannel(ctx, e);
            this.manager.setChannelException(channel);
            super.channelDisconnected(ctx, e);
        }
        catch (Throwable ex) {
            LOG.error(ex.getMessage(), ex);
        }
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.info("proxyClusterId:{},connect close:{}", (Object)this.manager.getProxyClusterId(), (Object)e);
        try {
            Channel channel = this.getChannel(ctx, e);
            this.manager.setChannelException(channel);
            super.channelClosed(ctx, e);
        }
        catch (Throwable ex) {
            LOG.error(ex.getMessage(), ex);
        }
    }

    @Override
    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        super.writeComplete(ctx, e);
    }

    private Channel getChannel(ChannelHandlerContext ctx, ChannelEvent e) {
        Channel channel = ctx.getChannel();
        if (channel == null) {
            channel = e.getChannel();
        }
        return channel;
    }
}

