/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.RandomUtils;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.apache.inlong.sdk.dataproxy.common.SendResult;
import org.apache.inlong.sdk.dataproxy.pb.SdkChannelWorker;
import org.apache.inlong.sdk.dataproxy.pb.SdkSenderClientHandler;
import org.apache.inlong.sdk.dataproxy.pb.context.SdkProfile;
import org.apache.inlong.sdk.dataproxy.pb.context.SdkSinkContext;
import org.apache.inlong.sdk.dataproxy.pb.dispatch.DispatchProfile;
import org.apache.inlong.sdk.dataproxy.pb.network.IpPort;
import org.apache.inlong.sdk.dataproxy.pb.network.TcpChannelGroup;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkProxyChannelManager {
    public static final Logger LOG = LoggerFactory.getLogger(SdkProxyChannelManager.class);
    public static final int DEFAULT_LENGTH_FIELD_OFFSET = 0;
    public static final int DEFAULT_LENGTH_FIELD_LENGTH = 4;
    public static final int DEFAULT_LENGTH_ADJUSTMENT = -4;
    public static final int DEFAULT_INITIAL_BYTES_TO_STRIP = 0;
    public static final boolean DEFAULT_FAIL_FAST = true;
    private String proxyClusterId;
    private SdkSinkContext context;
    private LinkedBlockingQueue<DispatchProfile> proxyDispatchQueue = new LinkedBlockingQueue();
    private AtomicLong offerCounter = new AtomicLong(0L);
    private ConcurrentHashMap<String, AtomicLong> offerGroupCounter = new ConcurrentHashMap();
    private AtomicLong takeCounter = new AtomicLong(0L);
    private Timer reloadTimer;
    private List<SdkChannelWorker> workers = new ArrayList<SdkChannelWorker>();
    private TcpChannelGroup sender;
    private AtomicLong sdkPackId = new AtomicLong(RandomUtils.nextLong());
    private ConcurrentHashMap<Long, SdkProfile> profileMap = new ConcurrentHashMap();

    public SdkProxyChannelManager(String proxyClusterId, SdkSinkContext context) {
        this.proxyClusterId = proxyClusterId;
        this.context = context;
    }

    public void start() {
        try {
            LOG.info("start to SdkProxyChannelManager:{}", (Object)this.proxyClusterId);
            SdkSenderClientHandler clientHandler = new SdkSenderClientHandler(this);
            this.sender = new TcpChannelGroup(this.proxyClusterId, this.context.getMaxThreads(), new LengthFieldBasedFrameDecoder(32768, 0, 4, -4, 0, true), clientHandler);
            for (int i = 0; i < this.context.getMaxThreads(); ++i) {
                SdkChannelWorker worker = new SdkChannelWorker(this, i);
                this.workers.add(worker);
                worker.start();
            }
            this.reload();
            this.setReloadTimer();
        }
        catch (Exception e) {
            LOG.error("proxyClusterId:{},error:{}", (Object)this.proxyClusterId, (Object)e);
        }
    }

    private void setReloadTimer() {
        this.reloadTimer = new Timer(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    SdkProxyChannelManager.this.reload();
                }
                catch (Exception e) {
                    LOG.error("proxyClusterId:{},error:{}", (Object)SdkProxyChannelManager.this.proxyClusterId, (Object)e);
                }
            }
        };
        this.reloadTimer.schedule(task, new Date(System.currentTimeMillis() + this.context.getReloadInterval()), this.context.getReloadInterval());
    }

    public long nextPackId() {
        return this.sdkPackId.getAndIncrement();
    }

    public void reload() {
        try {
            Set<IpPort> ipPortList = this.context.getProxyIpListMap().get(this.proxyClusterId);
            this.sender.updateConfig(ipPortList);
            this.clearTimeoutPack();
        }
        catch (Exception e) {
            LOG.error("proxyClusterId:{},error:{}", (Object)this.proxyClusterId, (Object)e);
        }
    }

    private void clearTimeoutPack() {
        LOG.info("ProxyClusterIdChannelManager clearTimeoutPack proxyClusterId:{},queueSize:{},waitingSize:{},offerCount:{},takeCount:{},offerGroupCount:{}", new Object[]{this.proxyClusterId, this.proxyDispatchQueue.size(), this.profileMap.size(), this.offerCounter.getAndSet(0L), this.takeCounter.getAndSet(0L), this.offerGroupCounter});
        this.offerGroupCounter.clear();
        long currentTime = System.currentTimeMillis();
        ArrayList<Long> timeoutPackId = new ArrayList<Long>(this.profileMap.size());
        for (Map.Entry<Long, SdkProfile> entry : this.profileMap.entrySet()) {
            if (currentTime - entry.getValue().getSendTime() <= this.context.getSdkPackTimeout()) continue;
            timeoutPackId.add(entry.getKey());
        }
        if (timeoutPackId.size() > 0) {
            LOG.info("clearTimeoutPack timeoutSize:{}", (Object)timeoutPackId.size());
            for (Long tdbankPackId : timeoutPackId) {
                SdkProfile tProfile = this.profileMap.remove(tdbankPackId);
                if (tProfile == null) continue;
                this.offerDispatchQueue(tProfile.getDispatchProfile());
            }
        }
    }

    public void putWaitCompletedProfile(SdkProfile tProfile) {
        this.profileMap.put(tProfile.getSdkPackId(), tProfile);
    }

    public void removeWaitCompletedProfile(SdkProfile tProfile) {
        this.profileMap.remove(tProfile.getSdkPackId());
    }

    public void setChannelException(Channel channel) {
        SdkProfile tProfile;
        SocketAddress socketAddress = channel.getRemoteAddress();
        if (!(socketAddress instanceof InetSocketAddress)) {
            return;
        }
        InetSocketAddress addr = (InetSocketAddress)socketAddress;
        IpPort ipPort = new IpPort(addr);
        ArrayList<Long> packIds = new ArrayList<Long>(this.profileMap.size());
        for (Map.Entry<Long, SdkProfile> entry : this.profileMap.entrySet()) {
            tProfile = entry.getValue();
            if (!ipPort.equals(tProfile.getIpPort())) continue;
            packIds.add(entry.getKey());
        }
        LOG.warn("proxyClusterId:{},clear channel:local:{},remote:{},profile size:{}", new Object[]{this.proxyClusterId, channel.getLocalAddress(), channel.getRemoteAddress(), packIds.size()});
        for (Long packId : packIds) {
            tProfile = this.profileMap.remove(packId);
            if (tProfile == null) continue;
            this.offerDispatchQueue(tProfile.getDispatchProfile());
            this.context.addSendResultMetric(tProfile.getDispatchProfile(), this.proxyClusterId, false, tProfile.getSendTime());
        }
        this.sender.exceptionChannel(channel);
        this.sender.releaseChannel(channel);
    }

    public static InetSocketAddress parseInetSocketAddress(Channel channel) {
        InetSocketAddress destAddr = null;
        if (channel.getRemoteAddress() instanceof InetSocketAddress) {
            destAddr = (InetSocketAddress)channel.getRemoteAddress();
        } else if (channel.getRemoteAddress() != null) {
            String sendIp = channel.getRemoteAddress().toString();
            destAddr = new InetSocketAddress(sendIp, 0);
        } else {
            destAddr = new InetSocketAddress("127.0.0.1", 0);
        }
        return destAddr;
    }

    public void onMessageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        if (!(e.getMessage() instanceof ChannelBuffer)) {
            LOG.error("proxyClusterId:{},onMessageReceived e.getMessage:{}", (Object)this.proxyClusterId, e.getMessage());
            this.setChannelException(e.getChannel());
            return;
        }
        ChannelBuffer nettyBuffer = (ChannelBuffer)e.getMessage();
        int responseLength = nettyBuffer.readInt();
        short packVersion = nettyBuffer.readShort();
        if (packVersion != 1) {
            LOG.error("proxyClusterId:{},Error result from:{},error pack version:{}", new Object[]{this.proxyClusterId, String.valueOf(e.getChannel().getRemoteAddress()), (int)packVersion});
            this.setChannelException(e.getChannel());
            return;
        }
        byte[] responseBytes = new byte[responseLength - 2];
        nettyBuffer.readBytes(responseBytes);
        ProxySdk.ResponseInfo responseInfo = null;
        try {
            responseInfo = ProxySdk.ResponseInfo.parseFrom(responseBytes);
        }
        catch (Exception ex) {
            LOG.error("proxyClusterId:{},Error result from:{},parseFrom exception:{}", new Object[]{this.proxyClusterId, String.valueOf(e.getChannel().getRemoteAddress()), ex});
            this.setChannelException(e.getChannel());
            return;
        }
        ProxySdk.ResultCode result = responseInfo.getResult();
        if (result != ProxySdk.ResultCode.SUCCUSS) {
            LOG.error("proxyClusterId:{},Error result from:{},resultCode:{}", new Object[]{this.proxyClusterId, String.valueOf(e.getChannel().getRemoteAddress()), result.toString()});
            this.setChannelException(e.getChannel());
            return;
        }
        long sdkPackId = responseInfo.getPackId();
        SdkProfile tProfile = this.profileMap.remove(sdkPackId);
        if (tProfile == null) {
            LOG.error("proxyClusterId:%s,Can not find MessageDispatchProfile by sdkPackId:%d,from:%s", new Object[]{this.proxyClusterId, sdkPackId, String.valueOf(e.getChannel().getRemoteAddress())});
            this.setChannelException(e.getChannel());
            return;
        }
        this.onMessageOK(tProfile, e.getChannel());
    }

    private void onMessageOK(SdkProfile tProfile, Channel channel) {
        this.context.addSendResultMetric(tProfile.getDispatchProfile(), this.proxyClusterId, true, tProfile.getSendTime());
        this.sender.releaseChannel(channel);
        tProfile.getDispatchProfile().getEvents().forEach(pEvent -> {
            try {
                pEvent.getProfile().getCallback().onMessageAck(SendResult.OK);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    public void close() {
        LOG.info("begin to close proxyClusterId:{}.", (Object)this.proxyClusterId);
        this.reloadTimer.cancel();
        for (SdkChannelWorker worker : this.workers) {
            worker.close();
        }
        this.workers.clear();
        this.profileMap.clear();
        this.sender.close();
        LOG.info("end to close proxyClusterId:{}.", (Object)this.proxyClusterId);
    }

    public String getProxyClusterId() {
        return this.proxyClusterId;
    }

    public SdkSinkContext getContext() {
        return this.context;
    }

    public boolean offerDispatchQueue(DispatchProfile profile) {
        this.offerCounter.incrementAndGet();
        String key = new Exception().getStackTrace()[1].toString();
        AtomicLong value = this.offerGroupCounter.computeIfAbsent(key, k -> new AtomicLong(0L));
        value.incrementAndGet();
        return this.proxyDispatchQueue.offer(profile);
    }

    public DispatchProfile takeDispatchQueue() throws InterruptedException {
        this.takeCounter.incrementAndGet();
        return this.proxyDispatchQueue.take();
    }

    public TcpChannelGroup getSender() {
        return this.sender;
    }
}

