/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.inlong.sdk.commons.protocol.EventUtils;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.apache.inlong.sdk.commons.protocol.SdkEvent;
import org.apache.inlong.sdk.dataproxy.pb.SdkProxyChannelManager;
import org.apache.inlong.sdk.dataproxy.pb.context.SdkProfile;
import org.apache.inlong.sdk.dataproxy.pb.context.SdkSinkContext;
import org.apache.inlong.sdk.dataproxy.pb.dispatch.DispatchProfile;
import org.apache.inlong.sdk.dataproxy.pb.network.IpPort;
import org.apache.inlong.sdk.dataproxy.pb.network.TcpResult;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkChannelWorker
extends Thread {
    public static final Logger LOG = LoggerFactory.getLogger(SdkChannelWorker.class);
    public static final int MAX_TRY_TIMES = 3;
    private final SdkProxyChannelManager manager;
    private SdkSinkContext context;
    private LifecycleState status;
    private ChannelBuffer totalBuffer = ChannelBuffers.dynamicBuffer();

    public SdkChannelWorker(SdkProxyChannelManager manager, int index) {
        super(manager.getProxyClusterId() + "-worker-" + index);
        this.manager = manager;
        this.context = manager.getContext();
        this.status = LifecycleState.IDLE;
    }

    @Override
    public void run() {
        this.status = LifecycleState.START;
        LOG.info("start to TdbankChannelWorker:{},status:{}", (Object)this.getName(), (Object)this.status);
        while (this.status == LifecycleState.START) {
            try {
                this.packAndSend();
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
            }
        }
    }

    private void packAndSend() throws InterruptedException {
        DispatchProfile currentRecord = this.manager.takeDispatchQueue();
        try {
            if (currentRecord == null) {
                Thread.sleep(this.manager.getContext().getProcessInterval());
                return;
            }
            String inlongGroupId = currentRecord.getInlongGroupId();
            String inlongStreamId = currentRecord.getInlongStreamId();
            ProxySdk.INLONG_COMPRESSED_TYPE compressedType = this.context.getCompressedType();
            ArrayList<SdkEvent> events = new ArrayList<SdkEvent>(currentRecord.getEvents().size());
            currentRecord.getEvents().forEach(value -> events.add(value.getProfile().getEvent()));
            ProxySdk.MessagePack packObject = EventUtils.encodeSdkEvents(inlongGroupId, inlongStreamId, compressedType, events);
            byte[] packBytes = packObject.toByteArray();
            this.totalBuffer.clear();
            this.totalBuffer.writeInt(packBytes.length + 2);
            this.totalBuffer.writeShort(1);
            this.totalBuffer.writeBytes(packObject.toByteArray());
            long sdkPackId = this.manager.nextPackId();
            SdkProfile sdkProfile = new SdkProfile(currentRecord, sdkPackId);
            this.manager.putWaitCompletedProfile(sdkProfile);
            this.context.addSendMetric(currentRecord, this.manager.getProxyClusterId());
            TcpResult result = this.manager.getSender().send(this.totalBuffer);
            if (!result.result) {
                for (int i = 0; i < 3; ++i) {
                    result = this.manager.getSender().send(this.totalBuffer);
                    if (result.result) break;
                    Thread.sleep(this.manager.getContext().getProcessInterval());
                }
            }
            if (!this.checkSendResult(currentRecord, result, result.ipPort, sdkProfile)) {
                LOG.info("proxyClusterId:{},packAndSend:{},result:{}", new Object[]{this.manager.getProxyClusterId(), currentRecord.getCount(), JSON.toJSONString((Object)result)});
                return;
            }
            sdkProfile.setIpPort(result.ipPort);
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
            if (currentRecord != null) {
                this.manager.offerDispatchQueue(currentRecord);
            }
            try {
                Thread.sleep(this.manager.getContext().getProcessInterval());
            }
            catch (InterruptedException e1) {
                LOG.error(e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private boolean checkSendResult(DispatchProfile currentRecord, TcpResult result, IpPort ipPort, SdkProfile tProfile) {
        if (!result.result) {
            this.manager.removeWaitCompletedProfile(tProfile);
            this.manager.offerDispatchQueue(currentRecord);
            try {
                Thread.sleep(this.manager.getContext().getProcessInterval());
            }
            catch (InterruptedException e1) {
                LOG.error(e1.getMessage(), (Throwable)e1);
            }
            return false;
        }
        return true;
    }

    public LifecycleState getStatus() {
        return this.status;
    }

    public SdkProxyChannelManager getManager() {
        return this.manager;
    }

    public void close() {
        this.status = LifecycleState.STOP;
    }
}

