/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.inlong.common.util.NetworkUtils;
import org.apache.inlong.sdk.commons.protocol.SdkEvent;
import org.apache.inlong.sdk.dataproxy.MessageSender;
import org.apache.inlong.sdk.dataproxy.common.SendMessageCallback;
import org.apache.inlong.sdk.dataproxy.common.SendResult;
import org.apache.inlong.sdk.dataproxy.network.ProxysdkException;
import org.apache.inlong.sdk.dataproxy.pb.ProxySdkSink;
import org.apache.inlong.sdk.dataproxy.pb.channel.BufferQueueChannel;
import org.apache.inlong.sdk.dataproxy.pb.context.CallbackProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbProtocolMessageSender
implements MessageSender,
Configurable {
    public static final Logger LOG = LoggerFactory.getLogger(PbProtocolMessageSender.class);
    private String name;
    private String localIp;
    private LifecycleState lifecycleState = LifecycleState.IDLE;
    private Context context;
    private BufferQueueChannel channel;
    private ProxySdkSink sink;

    public PbProtocolMessageSender(String name) {
        this.name = name == null ? PbProtocolMessageSender.class.getSimpleName() + "-" + Thread.currentThread().getName() : name;
        this.localIp = NetworkUtils.getLocalIp();
    }

    public void start() {
        this.lifecycleState = LifecycleState.START;
        this.channel.start();
        this.sink.start();
    }

    @Override
    public void close() {
        this.lifecycleState = LifecycleState.STOP;
        this.sink.stop();
        this.channel.stop();
    }

    public void configure(Context context) {
        this.context = context;
        this.channel = new BufferQueueChannel();
        this.channel.setName(this.name + "-channel");
        this.channel.configure(context);
        this.sink = new ProxySdkSink();
        this.sink.setName(this.name + "-sink");
        this.sink.configure(context);
        this.sink.setChannel((Channel)this.channel);
    }

    private void put(CallbackProfile event) {
        tx.begin();
        try (Transaction tx = this.channel.getTransaction();){
            this.channel.put(event);
            tx.commit();
        }
    }

    private void putAll(List<CallbackProfile> events) {
        tx.begin();
        try (Transaction tx = this.channel.getTransaction();){
            events.forEach(event -> this.channel.put((Event)event));
            tx.commit();
        }
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public SendResult sendMessage(byte[] body, String attributes, String msgUUID, long timeout, TimeUnit timeUnit) {
        return SendResult.INVALID_ATTRIBUTES;
    }

    @Override
    public SendResult sendMessage(byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit) {
        return this.sendMessage(body, groupId, streamId, dt, msgUUID, timeout, timeUnit, null);
    }

    @Override
    public SendResult sendMessage(byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap) {
        SdkEvent sdkEvent = new SdkEvent();
        sdkEvent.setInlongGroupId(groupId);
        sdkEvent.setInlongStreamId(streamId);
        sdkEvent.setBody(body);
        sdkEvent.setMsgTime(dt);
        sdkEvent.setSourceIp(this.localIp);
        if (extraAttrMap != null) {
            sdkEvent.setHeaders(extraAttrMap);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<SendResult> refResult = new AtomicReference<SendResult>();
        SendMessageCallback callback = new SendMessageCallback(){

            @Override
            public void onMessageAck(SendResult result) {
                refResult.set(SendResult.OK);
                latch.countDown();
            }

            @Override
            public void onException(Throwable e) {
                LOG.error(e.getMessage(), e);
                refResult.set(SendResult.CONNECTION_BREAK);
                latch.countDown();
            }
        };
        CallbackProfile profile = new CallbackProfile(sdkEvent, callback);
        this.put(profile);
        try {
            boolean success = latch.await(timeout, timeUnit);
            if (!success) {
                refResult.set(SendResult.TIMEOUT);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            refResult.set(SendResult.UNKOWN_ERROR);
        }
        return (SendResult)((Object)refResult.get());
    }

    @Override
    public SendResult sendMessage(List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit) {
        return this.sendMessage(bodyList, groupId, streamId, dt, msgUUID, timeout, timeUnit, null);
    }

    @Override
    public SendResult sendMessage(List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap) {
        final AtomicReference<SendResult> refResult = new AtomicReference<SendResult>();
        final CountDownLatch latch = new CountDownLatch(bodyList.size());
        ArrayList<CallbackProfile> events = new ArrayList<CallbackProfile>(bodyList.size());
        for (byte[] body : bodyList) {
            SdkEvent sdkEvent = new SdkEvent();
            sdkEvent.setInlongGroupId(groupId);
            sdkEvent.setInlongStreamId(streamId);
            sdkEvent.setBody(body);
            sdkEvent.setMsgTime(dt);
            sdkEvent.setSourceIp(this.localIp);
            if (extraAttrMap != null) {
                sdkEvent.setHeaders(extraAttrMap);
            }
            SendMessageCallback callback = new SendMessageCallback(){

                @Override
                public void onMessageAck(SendResult result) {
                    refResult.set(SendResult.OK);
                    latch.countDown();
                }

                @Override
                public void onException(Throwable e) {
                    LOG.error(e.getMessage(), e);
                    refResult.set(SendResult.CONNECTION_BREAK);
                    latch.countDown();
                }
            };
            CallbackProfile profile = new CallbackProfile(sdkEvent, callback);
            events.add(profile);
        }
        this.putAll(events);
        try {
            boolean success = latch.await(timeout, timeUnit);
            if (!success) {
                refResult.set(SendResult.TIMEOUT);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            refResult.set(SendResult.UNKOWN_ERROR);
        }
        return (SendResult)((Object)refResult.get());
    }

    @Override
    public void asyncSendMessage(SendMessageCallback callback, byte[] body, String attributes, String msgUUID, long timeout, TimeUnit timeUnit) throws ProxysdkException {
        throw new ProxysdkException("Not support");
    }

    @Override
    public void asyncSendMessage(SendMessageCallback callback, byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap) throws ProxysdkException {
        SdkEvent sdkEvent = new SdkEvent();
        sdkEvent.setInlongGroupId(groupId);
        sdkEvent.setInlongStreamId(streamId);
        sdkEvent.setBody(body);
        sdkEvent.setMsgTime(dt);
        sdkEvent.setSourceIp(this.localIp);
        if (extraAttrMap != null) {
            sdkEvent.setHeaders(extraAttrMap);
        }
        CallbackProfile profile = new CallbackProfile(sdkEvent, callback);
        this.put(profile);
    }

    @Override
    public void asyncSendMessage(SendMessageCallback callback, byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit) throws ProxysdkException {
        this.asyncSendMessage(callback, body, groupId, streamId, dt, msgUUID, timeout, timeUnit, null);
    }

    @Override
    public void asyncSendMessage(SendMessageCallback callback, List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit) throws ProxysdkException {
        this.asyncSendMessage(callback, bodyList, groupId, streamId, dt, msgUUID, timeout, timeUnit, null);
    }

    @Override
    public void asyncSendMessage(SendMessageCallback callback, List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap) throws ProxysdkException {
        ArrayList<CallbackProfile> events = new ArrayList<CallbackProfile>(bodyList.size());
        for (byte[] body : bodyList) {
            SdkEvent sdkEvent = new SdkEvent();
            sdkEvent.setInlongGroupId(groupId);
            sdkEvent.setInlongStreamId(streamId);
            sdkEvent.setBody(body);
            sdkEvent.setMsgTime(dt);
            sdkEvent.setSourceIp(this.localIp);
            if (extraAttrMap != null) {
                sdkEvent.setHeaders(extraAttrMap);
            }
            CallbackProfile profile = new CallbackProfile(sdkEvent, callback);
            events.add(profile);
        }
        this.putAll(events);
    }

    @Override
    public void asyncSendMessage(String inlongGroupId, String inlongStreamId, byte[] body, SendMessageCallback callback) throws ProxysdkException {
        this.asyncSendMessage(callback, body, inlongGroupId, inlongStreamId, System.currentTimeMillis(), null, 0L, null, null);
    }

    @Override
    public void asyncSendMessage(String inlongGroupId, String inlongStreamId, List<byte[]> bodyList, SendMessageCallback callback) throws ProxysdkException {
        this.asyncSendMessage(callback, bodyList, inlongGroupId, inlongStreamId, System.currentTimeMillis(), null, 0L, null, null);
    }
}

